// -*- C++ -*- generated by wxGlade 0.4cvs on Sun Aug 21 17:40:35 2005

#include "DicMainFrame.h"
#include "DicBook.h"
#include "DicBitmaps.h"
#include "DicReferences.h"
#include <stdio.h>
#include <stdlib.h>
#include <wx/confbase.h>
#include <wx/utils.h>
#include <wx/msgdlg.h>

#include "find.xpm"
#include "htmbook.xpm"

enum
{
	ID_SPLITTER,
	ID_SEARCH_WORD,
	ID_SEARCH_END_WORD,
	ID_SEARCH_EXACT_WORD,
	ID_SEARCH_KEYWORD,
	ID_SEARCH_CROSS,
	ID_SEARCH_MULTI,
	ID_SEARCH,
	ID_COMBO,
	ID_LIST
};

BEGIN_EVENT_TABLE(DicMainFrame, wxFrame)
	EVT_MENU(wxID_EXIT, DicMainFrame::OnExit)
	EVT_TOOL_RANGE(ID_SEARCH_WORD, ID_SEARCH_MULTI, DicMainFrame::OnSearchMethod)
	EVT_TOOL(ID_SEARCH, DicMainFrame::OnSearch)
	EVT_TEXT_ENTER(ID_COMBO, DicMainFrame::OnSearch)
	EVT_LIST_ITEM_SELECTED(ID_LIST, DicMainFrame::OnListItemSelected)
END_EVENT_TABLE()

/**
 * RXgN^
 */
DicMainFrame::DicMainFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxFrame(parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE)
{
    // begin wxGlade: DicMainFrame::DicMainFrame
    m_splitter = new wxSplitterWindow(this, -1, wxDefaultPosition, wxDefaultSize, wxSP_3D|wxSP_BORDER);
    m_rightPane = new wxPanel(m_splitter, -1);
    m_leftPane = new wxPanel(m_splitter, -1);
    m_menubar = new wxMenuBar();
    SetMenuBar(m_menubar);
    wxMenu* wxglade_tmp_menu_1 = new wxMenu();
    wxglade_tmp_menu_1->Append(wxID_EXIT, _("E&xit\tCtrl+Q"), wxT(""), wxITEM_NORMAL);
    m_menubar->Append(wxglade_tmp_menu_1, _("&File"));
    wxMenu* wxglade_tmp_menu_2 = new wxMenu();
    wxMenu* wxglade_tmp_menu_2_sub = new wxMenu();
    wxglade_tmp_menu_2_sub->Append(ID_SEARCH_WORD, _("Word"), wxT(""), wxITEM_RADIO);
    wxglade_tmp_menu_2_sub->Append(ID_SEARCH_END_WORD, _("End-word"), wxT(""), wxITEM_RADIO);
    wxglade_tmp_menu_2_sub->Append(ID_SEARCH_EXACT_WORD, _("Exact-word"), wxT(""), wxITEM_RADIO);
    wxglade_tmp_menu_2_sub->Append(ID_SEARCH_KEYWORD, _("Keyword"), wxT(""), wxITEM_RADIO);
    wxglade_tmp_menu_2_sub->Append(ID_SEARCH_CROSS, _("Cross"), wxT(""), wxITEM_RADIO);
    wxglade_tmp_menu_2_sub->Append(ID_SEARCH_MULTI, _("Multi"), wxT(""), wxITEM_RADIO);
    wxglade_tmp_menu_2->Append(wxNewId(), _("Search method"), wxglade_tmp_menu_2_sub, wxT(""));
    m_menubar->Append(wxglade_tmp_menu_2, _("&Edit"));
    m_statusbar = CreateStatusBar(1, wxST_SIZEGRIP);
    m_toolbar = new wxToolBar(this, -1);
    SetToolBar(m_toolbar);
    m_toolbar->Realize();
    const wxString m_combo_choices[] = {
        
    };
    m_combo = new wxComboBox(m_leftPane, ID_COMBO, wxT(""), wxDefaultPosition, wxDefaultSize, 0, m_combo_choices, wxCB_DROPDOWN);
    m_list = new wxListCtrl(m_leftPane, ID_LIST, wxDefaultPosition, wxDefaultSize, wxLC_REPORT|wxSUNKEN_BORDER);
    m_html = new DicHtmlWindow(m_rightPane, -1);

    set_properties();
    do_layout();
    // end wxGlade

    m_toolbar->AddTool(ID_SEARCH, _("Search"), wxBitmap(find_xpm));
    m_toolbar->Realize();
    
	SetSize(800,500);
	Centre();
    
    m_statusbar->SetStatusText(wxT(""));
    
    m_splitter->SetMinimumPaneSize(10);
    m_splitter->SetSashPosition(200);
    
    m_combo->SetFocus();
    
    m_list->InsertColumn(0, wxT(""));
    m_list->InsertColumn(1, wxT(""));
    m_list->SetColumnWidth(0, 50);
    m_list->SetColumnWidth(1, 1000);
    
    m_html->SetBorders(4);
    const int sizes[] = { 12, 14, 16, 18, 20, 22, 24 };
    m_html->SetFonts(wxT("Terminal"), wxT("Terminal"), sizes);
    m_html->WriteCustomization(wxConfigBase::Get());
    
    m_eb.Initialize();
	wxConfigBase* config = wxConfigBase::Get();
	config->SetPath(wxT("/book"));
	wxString key;
	long index;
	if (config->GetFirstEntry(key, index)) {
		do {
			wxString path = config->Read(key, wxEmptyString);
			m_eb.AddBook(path);
		} while (config->GetNextEntry(key, index));
	}
}

/**
 * fXgN^
 */
DicMainFrame::~DicMainFrame()
{
	m_hits.DeleteAll();
}


/**
 * vpeBݒ
 */
void DicMainFrame::set_properties()
{
    // begin wxGlade: DicMainFrame::set_properties
    SetTitle(_("digdic"));
    int m_statusbar_widths[] = { -1 };
    m_statusbar->SetStatusWidths(1, m_statusbar_widths);
    const wxString m_statusbar_fields[] = {
        _("frame_1_statusbar")
    };
    for(int i = 0; i < m_statusbar->GetFieldsCount(); ++i) {
        m_statusbar->SetStatusText(m_statusbar_fields[i], i);
    }
    m_combo->SetSelection(-1);
    // end wxGlade

	// ACRݒ肷B
    wxIcon _icon;
    _icon.CopyFromBitmap(wxBitmap(htmbook_xpm));
    SetIcon(_icon);
}

/**
 * CAEg
 */
void DicMainFrame::do_layout()
{
    // begin wxGlade: DicMainFrame::do_layout
    wxBoxSizer* m_mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* m_rightSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* m_leftSizer = new wxBoxSizer(wxVERTICAL);
    m_leftSizer->Add(m_combo, 0, wxEXPAND|wxADJUST_MINSIZE, 0);
    m_leftSizer->Add(m_list, 1, wxEXPAND, 0);
    m_leftPane->SetAutoLayout(true);
    m_leftPane->SetSizer(m_leftSizer);
    m_leftSizer->Fit(m_leftPane);
    m_leftSizer->SetSizeHints(m_leftPane);
    m_rightSizer->Add(m_html, 1, wxEXPAND, 0);
    m_rightPane->SetAutoLayout(true);
    m_rightPane->SetSizer(m_rightSizer);
    m_rightSizer->Fit(m_rightPane);
    m_rightSizer->SetSizeHints(m_rightPane);
    m_splitter->SplitVertically(m_leftPane, m_rightPane);
    m_mainSizer->Add(m_splitter, 1, wxEXPAND, 0);
    SetAutoLayout(true);
    SetSizer(m_mainSizer);
    m_mainSizer->Fit(this);
    m_mainSizer->SetSizeHints(this);
    Layout();
    // end wxGlade
}

/**
 * I
 */
void DicMainFrame::OnExit(wxCommandEvent& WXUNUSED(event))
{
	Close(TRUE);
}

#include <wx/msgdlg.h>

/**
 * \bh
 */
void DicMainFrame::OnSearchMethod(wxCommandEvent& event)
{
	switch (event.GetId()) {
	case ID_SEARCH_WORD:
		m_eb.SetSearchMethod(DicBook::SEARCH_WORD);
		break;
	case ID_SEARCH_END_WORD:
		m_eb.SetSearchMethod(DicBook::SEARCH_END_WORD);
		break;
	case ID_SEARCH_EXACT_WORD:
		m_eb.SetSearchMethod(DicBook::SEARCH_EXACT_WORD);
		break;
	case ID_SEARCH_KEYWORD:
		m_eb.SetSearchMethod(DicBook::SEARCH_KEYWORD);
		break;
	case ID_SEARCH_CROSS:
		m_eb.SetSearchMethod(DicBook::SEARCH_CROSS);
		break;
	case ID_SEARCH_MULTI:
		m_eb.SetSearchMethod(DicBook::SEARCH_MULTI);
		break;
	default:
		break;
	}
	OnSearch(event);
}

/**
 * 
 */
void DicMainFrame::OnSearch(wxCommandEvent& WXUNUSED(event))
{
	wxBusyCursor wait;
	
	DicHits hits;
	wxString key = m_combo->GetValue();
	int count = m_eb.Search(key, hits);
	if (!count) {
		::wxMessageBox(_("'") + key + _("' is not found."),
			_("digdic"), wxICON_INFORMATION);
		return;
	}

	m_hits.DeleteAll();	
	WX_APPEND_ARRAY(m_hits, hits);
		
	m_list->DeleteAllItems();
	for (int i = 0; i < count; ++i) {
		DicHit* hit = m_hits[i];
		m_list->InsertItem(i, hit->GetSubbookTitle());
		m_list->SetItem(i, 1, hit->GetHeading());
		m_list->SetItemData(i, (long)hit);
	}
	
	DicBitmaps::Get().DeleteAll();
	DicReferences::Get().DeleteAll();
	
	wxString html = wxT("<html><body>");
	DicHit* hit = m_hits[0];
	html += hit->GetText();
	html += wxT("</body></html>");
	
	m_html->Freeze();
	m_html->SetPage(html);
	m_html->Thaw();
}

/**
 * XgvfI
 */
void DicMainFrame::OnListItemSelected(wxListEvent& event)
{
	wxBusyCursor wait;
	
	DicHit* hit = (DicHit*)event.GetItem().GetData();

	DicBitmaps::Get().DeleteAll();
	DicReferences::Get().DeleteAll();
	
	wxString html = wxT("<html><body>");
	html += hit->GetText();
	html += wxT("</body></html>");

	m_html->Freeze();
	m_html->SetPage(html);
	m_html->Thaw();
}
