#!/usr/bin/wish

# Dillo configuration script
# This script is written in Japanese EUC-JP code.

# Bob Thomson <rjt@ee.ed.ac.uk>
# Jim Huang <jimchyun@ccns.ncku.edu.tw>
# (c)2003 Kiyo <kiyo@teki.jpn.ph>

# The settings are kept in the global array called $prefs[].
# It is indexed by key name.

### FONT SETTING ###
if {[file exists "/usr/bin/dpkg"]} {
option add *font a12    ;#for Debian
} else {
option add *font fixed  ;#for RedHat or Vine and other
}
#option add *font naga10 ;#small font

# use the file in the home directory, or in /etc ??
proc find_source_file {} {
    
}

# this make some of the more awkward options into a convenient form
proc unpack_options {} {
    global prefs width height colors
    regexp {([0-9]+)[xX]([0-9]+)} $prefs(geometry) ignore width height
    
    # tcl/tk doesn't like C-style colors
    foreach c {link_color visited_color bg_color text_color} {
	regsub {0[xX]} $prefs($c) \# colors($c)
    }
}

# the reverse of unpack_options
proc pack_options {} {
    global prefs width height colors
    set prefs(geometry) ${width}x${height}

    # dillo doesn't like tcl/tk-style colors
    foreach c {link_color visited_color bg_color text_color} {
	regsub \# $colors($c) "0x" prefs($c)
    }
}

# update the display for new settings
proc refresh {} {
    global colors
    .entries.color1.b18 configure -bg $colors(link_color) \
	-activebackground $colors(link_color)
    .entries.color1.b19 configure -bg $colors(visited_color) \
	-activebackground $colors(visited_color)
    .entries.color2.b20 configure -bg $colors(text_color) \
	-activebackground $colors(text_color)
    .entries.color2.b21 configure -bg $colors(bg_color) \
	-activebackground $colors(bg_color)
}

# set everything to reasonable values
proc load_defaults {} {
    global prefs
    # these values must be the same as the defaults that dillo uses
    array set prefs {
        allow_white_bg YES
        bg_color white
        compress_common_prefixes "\"index of ;re: ;fwd: ;www.;welcome to ;the \""
        compress_vowels "\"aeiouyEIOUY\""
        enterpress_forces_submit NO
        font_factor 1.0
        font_sizes "\"10 12 14 16 18 20\""
        force_my_colors NO
        force_visited_color YES
        focus_location_on_new YES
        fullwindow_start NO
        fw_fontname "\"*-*\""
        fw_aafontname "\"*\""
        generate_submit YES 
        geometry 640x550
        home "http://www.google.co.jp/"
        http_proxy ""
        limit_text_width NO
        limit_font_decoration NO
        link_color blue
        no_proxy   "\"\""
        panel_size tiny
        show_back YES
        show_bookmarks YES
        show_clear_url YES
        show_forw YES
        show_home YES   
        show_menubar YES
        show_popup_navigation YES
        show_progress_box YES
        show_reload YES
        show_save NO
        show_stop YES
        show_tooltip YES
        show_url YES
        show_user_agent YES
        small_icons YES
        startup "about:splash"
        tab_bar_homogeneous YES
        tab_bar_scroller NO
        tab_bar_show_fullscreen NO
        tab_bar_show_single_tab NO
        tab_load_in_background YES
        tab_instead_of_window YES
        tab_title_compress YES
        text_color black
        transient_dialogs NO
        use_dicache NO
        use_oblique NO
        user_agent "\"Dillo/%v\""
        visited_color purple
        vw_fontname "\"*-*\""
        vw_aafontname "\"*\""
    }
    unpack_options
}

# read from file f, which must be readable
proc read_a_file {f} {
    global prefs
    set fh [open $f "r"]
    while {![eof $fh]} {
	gets $fh line
	# this next line skips comments, and finds options
	if {![regexp {^[ \t]*\#} $line]
		&& [regexp {([^= \t]+)[ \t]*=[ \t]*(.+)} $line ignore a b]} {
        set sp  [split $line =]
        set a [lindex $sp 0]
        set b [lindex $sp 1]
	    set prefs($a) $b
	}
    }
    close $fh
}

proc read_prefs {} {
    global prefs oldprefs
    # this next line makes sure all parameters are set, if not in the file
    load_defaults
    if {[file exists "~/.dillo/dillorc"] 
	&&[file readable "~/.dillo/dillorc"]} {
	read_a_file "~/.dillo/dillorc"
    } else {
	# read /etc/dillorc if no per-user config file
	if {[file exists "/etc/dillorc"] 
	    &&[file readable "/etc/dillorc"]} {
	    read_a_file "/etc/dillorc"
	} elseif {[file exists "/usr/local/etc/dillorc"] 
	    &&[file readable "/usr/local/etc/dillorc"]} {
	    read_a_file "/usr/local/etc/dillorc"
	}
    }
    unpack_options
    array set oldprefs [array get prefs]
}

proc write_prefs {} {
    global prefs oldprefs
    pack_options

    # create the config dir?
    if {[file exists "~/.dillo"] == 0} {
	file mkdir "~/.dillo"
    }

    if {![file exists "~/.dillo/dillorc"] 
	|| [file writable "~/.dillo/dillorc"]} {
	set fh [open "~/.dillo/dillorc" "w"]
	set keys [array names prefs]
	foreach k $keys {
	    # only write the line if there is a value
	    if {[regexp {[^ \t]} $prefs($k)]} {
		puts $fh ${k}=$prefs($k)
	    }
	}
	close $fh
    } else {
	tk_dialog .broken "顼" \
	    "Dilloե \"~/.dillo/dillorc\" ˽񤭹ޤ!"\
	    "" 0 "λ"
    }
    array set oldprefs [array get prefs]
}

# leave, possibly popping up a dialogue asking whether or not to save
proc quit_save {} {
    global prefs oldprefs
    pack_options

    set modified 0
    foreach {k v} [array get prefs] {
	if {$v != $oldprefs($k)} {
	    set modified 1
	    break
	}
    }

    if {$modified} {
	set button [tk_dialog .savepopup "Dillo:¸ޤ?" \
			"λѹ¸ޤ?"\
			"" 0 "¸" "˴" "" ]
	if {$button == 0} write_prefs
	if {$button == 0 || $button == 1} exit
    } else {
	exit
    }
}

# construct the top-level window
proc build_window {} {
    global prefs colors
    frame .entries
    frame .entries.window
    frame .entries.color1
    frame .entries.color2
    frame .agent_urls
    frame .boxes
    frame .boxes.btn
    frame .boxes.btn2
    frame .buttons

    label .entries.l1 -text "Window" 
    entry .entries.window.e1 -textvariable width -width 5 
#	-validate key -vcmd {string is integer %P} 
    label .entries.window.l2 -text "x" 
    entry .entries.window.e2 -textvariable height -width 5 
#	-validate key -vcmd {string is integer %P}
    label .entries.l3 -text "եȤΨ" 
    entry .entries.e3 -textvariable prefs(font_factor) -width 5 
#	-validate key -vcmd {string is double %P}
    checkbutton .boxes.c4 -text "åեȤǼΤȤ" -onvalue YES -offvalue NO \
	    -variable prefs(use_oblique)
    checkbutton .boxes.btn2.c5 -text "Υȥݥåץåפ" -onvalue YES \
	-offvalue NO -variable prefs(show_tooltip)
    checkbutton .boxes.btn2.c7 -text "طʤĤ" -onvalue YES \
	-offvalue NO -variable prefs(allow_white_bg) 
    checkbutton .boxes.btn.c8 -text "\"\"" -onvalue YES \
	-offvalue NO -variable prefs(show_back) 
    checkbutton .boxes.btn.c9 -text "\"ʤ\"" -onvalue YES \
	-offvalue NO -variable prefs(show_forw) 
    checkbutton .boxes.btn.c10 -text "\"ۡ\"" -onvalue YES \
	-offvalue NO -variable prefs(show_home) 
    checkbutton .boxes.btn.c11 -text "\"ɹ\"" -onvalue YES \
	-offvalue NO -variable prefs(show_reload) 
    checkbutton .boxes.btn.c12 -text "\"¸\"" -onvalue YES \
	-offvalue NO -variable prefs(show_save) 
    checkbutton .boxes.btn.c13 -text "\"\"" -onvalue YES \
	-offvalue NO -variable prefs(show_stop) 
    checkbutton .boxes.btn.c14 -text "˥塼С" -onvalue YES -offvalue NO \
	    -variable prefs(show_menubar)
    checkbutton .boxes.btn.c15 -text "URLС" -onvalue YES -offvalue NO \
	    -variable prefs(show_url)
    checkbutton .boxes.c16 -text "ץ쥹ܥåɽ" -onvalue YES \
	-offvalue NO -variable prefs(show_progress_box)
    checkbutton .boxes.c35 -text "桼ȥܥåɽ" -onvalue YES \
	-offvalue NO -variable prefs(show_user_agent)
    checkbutton .boxes.btn2.c17 -text "˥ǥեȤοѤ" -onvalue YES \
	-offvalue NO -variable prefs(force_my_colors)
    checkbutton .boxes.c18 -text "Ѥ" -onvalue YES -offvalue NO \
	    -variable prefs(small_icons)
    checkbutton .boxes.c19 -text "ƥȤ¤" -onvalue YES \
	-offvalue NO -variable prefs(limit_text_width)
    checkbutton .boxes.c_limit_font_decoration -text "ʸ¤" -onvalue YES \
	-offvalue NO -variable prefs(limit_font_decoration)
    checkbutton .boxes.btn2.c20 -text "󰵽̤ǥå夹" -onvalue YES \
	-offvalue NO -variable prefs(use_dicache)
    checkbutton .boxes.c21 -text "URLꥢܥɽ" -onvalue YES \
	-offvalue NO -variable prefs(show_clear_url)
    checkbutton .boxes.c22 -text "ŪʥĤ" -onvalue YES \
	-offvalue NO -variable prefs(transient_dialogs)
    checkbutton .boxes.c_fullwindow_start -text "ե륹꡼ǳϤ" -onvalue YES \
	-offvalue NO -variable prefs(fullwindow_start)
    checkbutton .boxes.c24 -text "tab΢ɤ߹" -onvalue YES \
	-offvalue NO -variable prefs(tab_load_in_background)
    checkbutton .boxes.c25 -text "Windowtabǳ" -onvalue YES \
	-offvalue NO -variable prefs(tab_instead_of_window)
    checkbutton .boxes.c26 -text "tabΥȥ򰵽̤" -onvalue YES \
	-offvalue NO -variable prefs(tab_title_compress)
    checkbutton .boxes.c27 -text "ܥư" -onvalue YES \
	-offvalue NO -variable prefs(generate_submit)
    checkbutton .boxes.c28 -text "tabƱˤ" -onvalue YES \
	-offvalue NO -variable prefs(tab_bar_homogeneous)
    checkbutton .boxes.c29 -text "WindowURLС˥ե" -onvalue YES \
	-offvalue NO -variable prefs(focus_location_on_new)
    checkbutton .boxes.c30 -text "tabС˥ܥɽ" -onvalue YES \
	-offvalue NO -variable prefs(tab_bar_scroller)
    checkbutton .boxes.c31 -text "ե륹꡼tabСɽ" -onvalue YES \
	-offvalue NO -variable prefs(tab_bar_show_fullscreen)
    checkbutton .boxes.c32 -text "Enterǥե" -onvalue YES \
	-offvalue NO -variable prefs(enterpress_forces_submit)
    checkbutton .boxes.c33 -text "ݥåץåץ˥塼ʤɤɽ" -onvalue YES \
	-offvalue NO -variable prefs(show_popup_navigation)
    checkbutton .boxes.c34 -text "tabĤǤɽ" -onvalue YES \
	-offvalue NO -variable prefs(tab_bar_show_single_tab)
    label .entries.l29 -text "ѥͥΥ"
    tk_optionMenu .entries.o1 prefs(panel_size) tiny medium large
    label .entries.l_font_sizes -text "եȥ"
    entry .entries.e_font_sizes  -textvariable prefs(font_sizes) -width 19
    label .entries.l30 -text "̾ե"
    entry .entries.e30 -textvariable prefs(vw_fontname) -width 19
    label .entries.l31 -text "ե"
    entry .entries.e31 -textvariable prefs(fw_fontname) -width 19
    label .entries.l_vw_aafontname -text "AA̾ե"
    entry .entries.e_vw_aafontname -textvariable prefs(vw_aafontname) -width 19
    label .entries.l_fw_aafontname -text "AAե"
    entry .entries.e_fw_aafontname -textvariable prefs(fw_aafontname) -width 19
    label .entries.l32 -text "άʸ"
    entry .entries.e32 -textvariable prefs(compress_vowels) -width 19
    label .entries.l33 -text "άƬ"
    entry .entries.e33 -textvariable prefs(compress_common_prefixes) -width 19
    
    label .entries.color1.l22 -text "̤ˬ"
    # note that named colors work in tcl/tk; eg. "blue" will not break this
    button .entries.color1.b18 -bg $colors(link_color) \
	-activebackground $colors(link_color) \
	-command {
	    set c [tk_chooseColor -initialcolor $colors(link_color) \
		       -title "̤ˬ󥯤ο"]
	    if {$c != ""} {
		set colors(link_color) $c
		.entries.color1.b18 configure -bg $c -activebackground $c
	    }
	}
    label .entries.color1.l23 -text "ˬѥ"
    button .entries.color1.b19 -bg $colors(visited_color) -activebackground \
	$colors(visited_color) \
	-command {
	    set c [tk_chooseColor -initialcolor $colors(visited_color) \
		       -title "ˬ䤷󥯤ο"]
	    if {$c != ""} {
		set colors(visited_color) $c
		.entries.color1.b19 configure -bg $c -activebackground $c
	    }
	}
    label .entries.color2.l24 -text "ƥ"
    button .entries.color2.b20 -bg $colors(text_color) \
	-activebackground $colors(text_color) \
	-command {
	    set c [tk_chooseColor -initialcolor $colors(text_color) \
		       -title "ƥȤο"]
	    if {$c != ""} {
		set colors(text_color) $c
		.entries.color2.b20 configure -bg $c -activebackground $c
	    }
	}
    label .entries.color2.l25 -text "ط"
    button .entries.color2.b21 -bg $colors(bg_color) \
	-activebackground $colors(bg_color) \
	-command {
	    set c [tk_chooseColor -initialcolor $colors(bg_color) \
		       -title "طʤο"]
	    if {$c != ""} {
		set colors(bg_color) $c
		.entries.color2.b21 configure -bg $c -activebackground $c
	    }
	}
    label .agent_urls.l1 -text "桼"
    tk_optionMenu .agent_urls.o1 prefs(user_agent) \
        "\"Dillo/%v\"" \
    	"\"Mozilla/3.0 (compatible;) Dillo/%v\"" \
    	"\"Mozilla/4.0 (compatible; MSIE 4.0;) Dillo/%v\"" \
        "\"Mozilla/4.0 (Macintosh; U; PPC Mac OS X; ja-jp) Dillo/%v\"" \
    	"\"DoCoMo/1.0/x505i (Dillo/%v)\"" \
    	"\"J-PHONE/4.2/J-x53 (Dillo/%v)\"" \
    	"\"KDDI-x24 UP.Browser/6.0.x.x (GUI) MMP/1.1 (Dillo/%v)\""

    label .agent_urls.l6 -text "ۡڡURL" 
    entry .agent_urls.e4 -textvariable prefs(home) -width 64 
    label .agent_urls.l7 -text "ư˳URL" 
    entry .agent_urls.e5 -textvariable prefs(startup) -width 64 
    label .agent_urls.l26 -text "HTTPץ"
    entry .agent_urls.e27 -textvariable prefs(http_proxy) -width 64
    label .agent_urls.l28 -text "ץȤʤΤ"
    entry .agent_urls.e29 -textvariable prefs(no_proxy) -width 64

    button .buttons.b1 -text "ꥻå" -command {
	load_defaults
	refresh
    }
    button .buttons.b2 -text "ɹ" -command {
	read_prefs
	refresh
    }
    button .buttons.b3 -text "" -command write_prefs
    button .buttons.b4 -text "λ" -command quit_save

    grid .entries.l1 -row 0 -column 0 -sticky e
    grid .entries.window.e1 -row 0 -column 1 -sticky w
    grid .entries.window.l2 -row 0 -column 2 -sticky w
    grid .entries.window.e2 -row 0 -column 3 -sticky w

    grid .buttons.b1 -row 0 -column 1
    grid .buttons.b2 -row 0 -column 2
    grid .buttons.b3 -row 0 -column 3
    grid .buttons.b4 -row 0 -column 4

    grid .boxes.btn.c8 -row 0 -column 0 -sticky w
    grid .boxes.btn.c9 -row 0 -column 1 -sticky w
    grid .boxes.btn.c10 -row 1 -column 0 -sticky w
    grid .boxes.btn.c11 -row 1 -column 1 -sticky w
    grid .boxes.btn.c12 -row 2 -column 0 -sticky w
    grid .boxes.btn.c13 -row 2 -column 1 -sticky w
    grid .boxes.btn.c14 -row 3 -column 0 -sticky w
    grid .boxes.btn.c15 -row 3 -column 1 -sticky w
    grid .boxes.btn -row 0 -column 0 -sticky w
    grid .boxes.c21 -row 1 -column 0 -sticky w
    grid .boxes.c16 -row 2 -column 0 -sticky w
    grid .boxes.c35 -row 3 -column 0 -sticky w
    grid .boxes.c18 -row 4 -column 0 -sticky w
    grid .boxes.c27 -row 5 -column 0 -sticky w
    grid .boxes.c29 -row 6 -column 0 -sticky w
    grid .boxes.c32 -row 7 -column 0 -sticky w
    grid .boxes.c4  -row 8 -column 0 -sticky w
    grid .boxes.c19 -row 9 -column 0 -sticky w
    grid .boxes.c_limit_font_decoration -row 10 -column 0 -sticky w
    grid .boxes.btn2.c5 -row 0 -column 0 -sticky w
    grid .boxes.btn2.c7 -row 1 -column 0 -sticky w
    grid .boxes.btn2.c17 -row 2 -column 0 -sticky w
    grid .boxes.btn2.c20 -row 3 -column 0 -sticky w
    grid .boxes.btn2 -row 0 -column 1 -sticky w
    grid .boxes.c22 -row 1 -column 1 -sticky w
    grid .boxes.c33 -row 2 -column 1 -sticky w
    grid .boxes.c24 -row 3 -column 1 -sticky w
    grid .boxes.c25 -row 4 -column 1 -sticky w
    grid .boxes.c26 -row 5 -column 1 -sticky w
    grid .boxes.c28 -row 6 -column 1 -sticky w
    grid .boxes.c30 -row 7 -column 1 -sticky w
    grid .boxes.c31 -row 8 -column 1 -sticky w
    grid .boxes.c34 -row 9 -column 1 -sticky w
    grid .boxes.c_fullwindow_start -row 10 -column 1 -sticky w

    grid .entries.l3 -row 2 -column 0 -sticky e
    grid .entries.e3 -row 2 -column 1 -sticky w

    
    grid .entries.color1.l22 -row 0 -column 0 -sticky e
    grid .entries.color1.b18 -row 0 -column 1 -sticky w
    grid .entries.color1.l23 -row 1 -column 0 -sticky e
    grid .entries.color1.b19 -row 1 -column 1 -sticky w
    grid .entries.color2.l24 -row 0 -column 0 -sticky e
    grid .entries.color2.b20 -row 0 -column 1 -sticky w
    grid .entries.color2.l25 -row 1 -column 0 -sticky e
    grid .entries.color2.b21 -row 1 -column 1 -sticky w
    grid .entries.l29 -row 8 -column 0 -sticky e
    grid .entries.o1 -row 8 -column 1 -sticky w
    
    grid .entries.l_font_sizes -row 10 -column 0 -sticky e
    grid .entries.e_font_sizes -row 10 -column 1 -sticky w
    grid .entries.l30 -row 11 -column 0 -sticky e
    grid .entries.e30 -row 11 -column 1 -sticky w
    grid .entries.l31 -row 12 -column 0 -sticky e
    grid .entries.e31 -row 12 -column 1 -sticky w
    grid .entries.l_vw_aafontname -row 13 -column 0 -sticky e
    grid .entries.e_vw_aafontname -row 13 -column 1 -sticky w
    grid .entries.l_fw_aafontname -row 14 -column 0 -sticky e
    grid .entries.e_fw_aafontname -row 14 -column 1 -sticky w
    grid .entries.l32 -row 15 -column 0 -sticky e
    grid .entries.e32 -row 15 -column 1 -sticky w
    grid .entries.l33 -row 16 -column 0 -sticky e
    grid .entries.e33 -row 16 -column 1 -sticky w

    grid .agent_urls.l1 -row 0 -column 0 -sticky e
    grid .agent_urls.o1 -row 0 -column 1 -sticky w

    grid .agent_urls.l6 -row 1 -column 0 -sticky e
    grid .agent_urls.e4 -row 1 -column 1 -sticky "ew"
    grid .agent_urls.l7 -row 2 -column 0 -sticky e
    grid .agent_urls.e5 -row 2 -column 1 -sticky "ew"
    grid .agent_urls.l26 -row 3 -column 0 -sticky e
    grid .agent_urls.e27 -row 3 -column 1 -sticky "ew"
    grid .agent_urls.l28 -row 4 -column 0 -sticky e
    grid .agent_urls.e29 -row 4 -column 1 -sticky "ew"

    grid .buttons -row 2 -column 0 -columnspan 2 -sticky "ew"
    grid .agent_urls -row 1 -column 0 -columnspan 2 -sticky "ew"
    grid .boxes -row 0 -column 1 -sticky e
    grid .entries -row 0 -column 0 -sticky w
    grid .entries.window -row 0 -column 1 -sticky w
    grid .entries.color1 -row 1 -column 0 -sticky w
    grid .entries.color2 -row 1 -column 1 -sticky w
    wm title . "Dillo"
}

read_prefs
build_window
