#ifndef __ENCODING_H__
#define __ENCODING_H__

#include <gtk/gtk.h>
#include <stdlib.h> /* for getenv() */
#include <iconv.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define IS_UTF8_FIRST_CHAR(c) ((((unsigned char)(c)) >> 6) == 0x03)
#define IS_UTF8_NON_FIRST_CHAR(c) ((((unsigned char)(c)) >> 6) == 0x02)
#define IS_UTF8_2BYTE_FIRST_CHAR(c) ((((unsigned char)(c)) >> 5) == 0x06)
#define IS_UTF8_3BYTE_FIRST_CHAR(c) ((((unsigned char)(c)) >> 4) == 0x0E)
#define IS_UTF8_4BYTE_FIRST_CHAR(c) ((((unsigned char)(c)) >> 3) == 0x1E)

#define IS_HANKANA_CHAR(c) \
   (((unsigned char)(c))>=0xa1 && ((unsigned char)(c))<=0xdf)

#if 1
#define IS_EUC_CHAR(c) \
((((unsigned char)(c))>=0xa0 && ((unsigned char)(c))<=0xfe) \
   || ((unsigned char)(c) == 0x8E)) //hankaku kana
#else
#define IS_EUC_CHAR(c) \
((((unsigned char)(c))>=0xe0 && ((unsigned char)(c))<=0xfe) \
   || ((unsigned char)(c) == 0x8E)) //hankaku kana
#endif
#define IS_EUC_HANKANA_CHAR(c) (((unsigned char)(c))==0x8E)
#define IS_EUC_ZENASCII_CHAR(c) (((unsigned char)(c))==0xa3)
#define IS_EUC_HIRA_CHAR(c) (((unsigned char)(c))==0xa4)
#define IS_EUC_ZENKANA_CHAR(c) (((unsigned char)(c))==0xa5) 
#define IS_EUC_KANJI_CHAR(c) \
(((unsigned char)(c))>=0xb0 && ((unsigned char)(c))<=0xfe)

#define IS_SJIS_CHAR1(c) \
   ((((unsigned char)(c))>=0x81 && ((unsigned char)(c))<=0x9f) \
    || (((unsigned char)(c))>=0xe0 && ((unsigned char)(c))<=0xef))
#define IS_SJIS_CHAR2(c) \
   (((unsigned char)(c))>=0x40 && ((unsigned char)(c))<=0xfc)

#define MAX_WORD_LENGTH 20

#define IS_ASCII_CHAR(c) (!(((unsigned char)(c)) & 0x80))

#define DILLO_CHARSET "UTF-8"
#define D_CHAR_GROWTH 3
#define DW_CHARSET (a_Encoding_get_DW_charset())
#ifndef DISABLE_ANTI_ALIAS
 #define RENDER_CHARSET "UTF-8"
#else
 #define RENDER_CHARSET DW_CHARSET
#endif

void   a_Encoding_set_DW_lang(const gchar *lang);
gchar *a_Encoding_get_DW_charset();
gboolean a_Encoding_has_latin1_charset();
gchar *a_Encoding_fix_charset(gchar *charset);
gchar* a_Encoding_get_encoding(gchar *buf, gint bufsize, gboolean *usemeta);
size_t a_Encoding_iconv(iconv_t *cd,
      char **inbuf, size_t *inbytesleft,
      char **outbuf, size_t *outbytesleft, const gint *max_char_growth);
gchar* a_Encoding_Convert_Raw(iconv_t* it, const gchar* buf, size_t bufsize, gint char_growth);
gchar* a_Encoding_Convert(const gchar* from, const gchar* to, const gchar* buf, size_t bufsize);
gint a_Encoding_mblen(gchar *str);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ENCODING_H__ */
/* vim: set ts=3 sw=3 sts=3 expandtab:*/
