/* pthread.h: */

#ifndef _PTHREAD_H
#define _PTHREAD_H

#include <glib/gthread.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct pthread_attr_impl* pthread_attr_t;
typedef struct pthread_mutexattr_impl* pthread_mutexattr_t;
typedef struct pthread_condattr_impl* pthread_condattr_t;

typedef GThread* pthread_t;
typedef GMutex* pthread_mutex_t;
typedef GCond*  pthread_cond_t;

static inline
int pthread_create (pthread_t *th, const pthread_attr_t *attr,void *(*start)(void *), void *arg)
{
	if ((*th = g_thread_create(start,arg,FALSE /*not join */,NULL))==NULL) return -1;
	return 0;
}
static inline
int pthread_detach (pthread_t th) { return 0; }

#if 0 /* not used */
static inline
void pthread_exit (void *val) { g_thread_exit(val); }
static inline
int pthread_join (pthread_t th, void **rval) { gointer val = g_thread_join(); *rval=val; return 0; }
static inline
pthread_t pthread_self (void) { return g_thread_self(); }
#endif

static inline
int pthread_mutex_init (pthread_mutex_t *mutex, const pthread_mutexattr_t *attr) { *mutex = g_mutex_new(); return 0; }
static inline
int pthread_mutex_destroy (pthread_mutex_t *mutex) { g_mutex_free(*mutex); return 0; } 
static inline
int pthread_mutex_lock (pthread_mutex_t *mutex) { g_mutex_lock(*mutex); return 0; }
#if 0
static inline
int pthread_mutex_trylock (pthread_mutex_t *mutex) { return g_mutex_trylock(*mutex)?0:EBUSY; }
#endif
static inline
int pthread_mutex_unlock (pthread_mutex_t *mutex) { g_mutex_unlock(*mutex); return 0; }

static inline
int pthread_cond_init (pthread_cond_t *cond, const pthread_condattr_t *attr) { *cond = g_cond_new(); return 0; }
static inline
int pthread_cond_destroy (pthread_cond_t *cond) { g_cond_free(*cond); return 0; }
static inline
int pthread_cond_signal (pthread_cond_t *cond) { g_cond_signal(*cond); return 0; }
static inline
int pthread_cond_broadcast (pthread_cond_t *cond) { g_cond_broadcast(*cond); return 0; }
static inline
int pthread_cond_wait (pthread_cond_t *cond, pthread_mutex_t *mutex) { g_cond_wait(*cond,*mutex); return 0; }

#ifdef __cplusplus
}
#endif

#endif /* _PTHREAD_H */
