-- <pre>
-- $ createdb -U skelton_user help_desk_manager
-- $ psql -U skelton_user help_desk_manager < help_desk_manager.sql
--
-- sql file for "help_desk_manager"

CREATE TABLE auth_user (
	username text not null,
	password text not null, -- to be stored md5 hashed password
	auth_level int not null default 0, -- level of access granted
	auth_perm text default null, --  ',' seperated 
	primary key (username)
);

-- logging class for Dino_DB
CREATE TABLE __logging_sql (
	logging_time timestamp not null default current_timestamp,
	func_name text not null,
	query text not null,
	result_option text
);
CREATE INDEX idx___logging_sql_logging_time
on __logging_sql (logging_time);


-- ڡ
CREATE TABLE page (
	"key" text, -- key
	parent_key text default '', -- ƥڡ
	ctime text default '', -- 
	mtime text default '', -- ǽ
	contents text, -- ƥ
	contents_type text not null default 'wiki', -- ƥĥ
	visible boolean not null default 'f', -- Ļ
	enable boolean not null default 't', -- Ѳǽ
	template text default 'default', -- ƥץ졼

	primary key ("key")
);

-- insert into page("key",visible,template) values('default','t','default');


-- 

CREATE TABLE kanri (

	username text not null primary key,
	name text not null, -- ̾
	office_id text not null, -- ҰID


	dummy_field_of_auth_user int default null -- dummy 
) inherits (auth_user);



-- 䤤碌

CREATE TABLE toi_syurui (

	id serial, -- 䤤碌ID
	toi text not null, -- 䤤碌


	primary key (id)
);



-- ϡɥ

CREATE TABLE hard_ware (

	id serial, -- ϡɥID
	name text not null, -- ̾
	state text, -- 

	unique(name),

	primary key (id)
);



-- OS

CREATE TABLE os (

	id serial, -- osID
	name text not null, -- OS̾

	unique(name),

	primary key (id)
);



-- ܵҥꥹ

CREATE TABLE kokyaku (

	id serial, -- ܵID
	user_id text not null, -- 桼ꥢID
	hardware__hard_ware_id integer, -- ϡɥ
	os__os_id integer, -- os
	note text, -- 

	foreign key (hardware__hard_ware_id) references hard_ware(id)
	on update cascade on delete set null,
	foreign key (os__os_id) references os(id)
	on update cascade on delete set null,

	primary key (id)
);

create index kokyaku_hardware__hard_ware_id_idx on kokyaku using btree(hardware__hard_ware_id);
create index kokyaku_os__os_id_idx on kokyaku using btree(os__os_id);


-- ɽ

CREATE TABLE uketuke (

	id serial, -- ID
	kokyaku__kokyaku_id integer not null, -- ܵID
	kanri__kanri_username text not null, -- б
	toisyu__toi_syurui_id integer not null, -- 䤤碌
	hardware__hard_ware_id integer, -- ϡɥ
	os__os_id integer, -- os
	naiyou text not null, -- 
	taiou text not null, -- б
	note text default 'ϡɥܺ', -- 
	state text not null, -- 
	uke_date timestamp default current_timestamp, -- դ
	syori_date timestamp default current_timestamp, -- бλ

	foreign key (kokyaku__kokyaku_id) references kokyaku(id)
	on update cascade on delete set null,
	foreign key (toisyu__toi_syurui_id) references toi_syurui(id)
	on update cascade on delete set null,
	foreign key (hardware__hard_ware_id) references hard_ware(id)
	on update cascade on delete set null,
	foreign key (os__os_id) references os(id)
	on update cascade on delete set null,

	primary key (id)
);

create index uketuke_kokyaku__kokyaku_id_idx on uketuke using btree(kokyaku__kokyaku_id);
create index uketuke_toisyu__toi_syurui_id_idx on uketuke using btree(toisyu__toi_syurui_id);
create index uketuke_hardware__hard_ware_id_idx on uketuke using btree(hardware__hard_ware_id);
create index uketuke_os__os_id_idx on uketuke using btree(os__os_id);


-- </pre>
