<?php
/* OOHForms: textarea
 *
 * Copyright (c) 1998 by Jay Bloodworth
 * This file is modified by Dino Co.,Ltd.
 *
 * $Id: of_textarea.inc.php,v 1.7 2003/03/13 14:34:12 noriko Exp $
 */


/**
 * OOHForms: textarea
 *
 *
 * @package Dino_Form
 * @access public
 */


class of_textarea extends of_element {

  var $rows;
  var $cols;
  var $wrap;

  // for self_get_js 
  var $minlength;
  var $length_e;
  var $valid_regex;
  var $valid_e;
  var $valid_icase;


  // Constructor
  function of_textarea($a) {
    $this->setup_element($a);
  }

  function self_get($val,$which, &$count) {
    $str  = "";
    $str .= "<textarea name='$this->name'";
    $str .= " rows='$this->rows' cols='$this->cols'";
    if ($this->wrap) 
      $str .= " wrap='$this->wrap'";
    if ($this->extrahtml) 
      $str .= " $this->extrahtml";
    $str .= " />" . htmlspecialchars($this->value, ENT_QUOTES) ."</textarea>";
    
    $count = 1;
    return $str;
  }

  function self_get_frozen($val,$which, &$count) {
    $str  = "";
    $str .= "<input type='hidden' name='$this->name'";
    $str .= " value='";
    $str .= htmlspecialchars($this->value, ENT_QUOTES) . "' />\n";
    $str .= "<table><tr><td>\n";
    $str .=  nl2br(htmlspecialchars($this->value, ENT_QUOTES));
    $str .= "\n</td></tr></table>\n";
    
    $count = 1;
    return $str;
  }

  function self_get_js($ndx_array) {
    $str = "";
    $i = 0;

    if(!$ndx_array){ return; }

    reset($ndx_array);
    while (list($k,$n) = each($ndx_array)) {
      $n = $this->name;
      if ($this->length_e) {
	$str .= "if (f.elements['${n}'].value.length < $this->minlength) {\n";
	$str .= "  alert(\"$this->length_e\");\n";
	$str .= "  f.elements['${n}'].focus();\n";
	$str .= "  return(false);\n}\n";
      }
      if ($this->valid_e) {
	$flags = ($this->icase ? "gi" : "g");
	$str .= "if (window.RegExp) {\n";
	$str .= "  var reg = new RegExp(\"$this->valid_regex\",\"$flags\");\n";
	$str .= "  if (!reg.test(f.elements['${n}'].value)) {\n";
	$str .= "    alert(\"$this->valid_e\");\n";
	$str .= "    f.elements['${n}'].focus();\n";
	$str .= "    return(false);\n";
	$str .= "  }\n}\n";
      }
      $i++;
    }

    return $str;
  }

  function self_validate($val) {
    if (!is_array($val)) $val = array($val);
    reset($val);
    while (list($k,$v) = each($val)) {
      if ($this->length_e && (strlen($v) < $this->minlength))
        return $this->length_e;
      if ($this->valid_e && (($this->icase &&
			      !eregi($this->valid_regex,$v)) ||
			     (!$this->icase &&
			      !ereg($this->valid_regex,$v))))
        return $this->valid_e;
    }
    return false;
  }


} // end TEXTAREA

?>
