/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload;

import ikdnet.diload.ConfigMessages;
import ikdnet.diload.DefaultTransFormer;
import ikdnet.diload.InstrumentationFactory;
import ikdnet.diload.Messages;
import ikdnet.diload.check.AutoModifyChecker;
import ikdnet.diload.exception.RedefineClassesSupportedException;
import ikdnet.diload.utils.DILoadUtils;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ReloaderAgent {
    private static URLClassLoader jsloader;
    private static Logger logger;

    static {
        logger = DILoadUtils.createLogger(ReloaderAgent.class);
    }

    public static void premain(String args, Instrumentation inst) {
        String vendor = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.vm.vendor");
            }
        });
        String cp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.class.path");
            }
        });
        logger.info("classpath=" + cp);
        if (!"Sun Microsystems Inc.".equals(vendor)) {
            throw new RedefineClassesSupportedException("DILoad is\u3000only supported sun jvm.");
        }
        logger.info("argument:=" + args);
        if (!inst.isRedefineClassesSupported()) {
            throw new RedefineClassesSupportedException(Messages.getString("ReloaderAgent.0"));
        }
        if (!inst.isRetransformClassesSupported()) {
            throw new RedefineClassesSupportedException(Messages.getString("ReloaderAgent.0"));
        }
        ReloaderAgent.createjsCLFactory();
        InstrumentationFactory.setInstrumentation(inst);
        InstrumentationFactory.setAgent(ReloaderAgent.getInstance());
        InstrumentationFactory.addTransformer();
        AutoModifyChecker mc = new AutoModifyChecker();
        mc.init(args);
        mc.start();
    }

    private static void createjsCLFactory() {
        String file_name = ConfigMessages.getString("javassist.file.name");
        if (file_name == null || "".equals(file_name)) {
            file_name = "javassist-3.4.ga.jar";
        }
        String path = ReloaderAgent.getSearchJarPath(file_name);
        File jarFile = new File(path);
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        try {
            jsloader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, parent);
            jsloader.loadClass("javassist.ClassPool");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ClassFileTransformer getInstance() {
        String TRANSFORMER_CLASS = "ikdnet.diload.DITransFormer";
        try {
            Class<?> actionClass = Class.forName("ikdnet.diload.DITransFormer", true, jsloader);
            return (ClassFileTransformer)actionClass.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> actionClass = Class.forName("ikdnet.diload.DITransFormer");
                return (ClassFileTransformer)actionClass.newInstance();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return new DefaultTransFormer();
            }
        }
        catch (Error e) {
            logger.warning("Not found dependency jar file [javassist.jar] unable to implement the method of measuring time.");
            return new DefaultTransFormer();
        }
    }

    private static String getSearchJarPath(String jarFileName) {
        String sCurrentDirTemp;
        String sCurrentDir = new File(".").getAbsoluteFile().getParent();
        String base = sCurrentDirTemp = DILoadUtils.combinePath(sCurrentDir);
        File in = new File(String.valueOf(sCurrentDirTemp) + jarFileName);
        if (in.exists()) {
            return String.valueOf(sCurrentDir) + jarFileName;
        }
        sCurrentDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        sCurrentDirTemp = DILoadUtils.combinePath(sCurrentDir);
        in = new File(String.valueOf(sCurrentDirTemp) + jarFileName);
        if (in.exists()) {
            return String.valueOf(sCurrentDir) + jarFileName;
        }
        sCurrentDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        });
        sCurrentDirTemp = DILoadUtils.combinePath(sCurrentDir);
        in = new File(String.valueOf(sCurrentDirTemp) + jarFileName);
        if (in.exists()) {
            return String.valueOf(sCurrentDir) + jarFileName;
        }
        URL u = ClassLoader.getSystemResource(jarFileName);
        if (u == null) {
            u = Thread.currentThread().getClass().getResource(jarFileName);
        }
        if (u != null && (in = new File(u.getPath())).exists()) {
            return u.getPath();
        }
        String classpath = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.class.path");
            }
        });
        String dir = ReloaderAgent.getCurrentDir(classpath);
        if (dir != null && !"".equals(dir)) {
            in = new File(String.valueOf(dir = DILoadUtils.combinePath(dir)) + jarFileName);
            if (in.exists()) {
                return String.valueOf(dir) + jarFileName;
            }
            sCurrentDir = ReloaderAgent.searchWeb(dir, jarFileName);
            if (sCurrentDir != null) {
                return String.valueOf(sCurrentDir) + jarFileName;
            }
        }
        if ((sCurrentDir = ReloaderAgent.searchWeb(base, jarFileName)) != null) {
            return String.valueOf(sCurrentDir) + jarFileName;
        }
        throw new RuntimeException("Not found file [javassist.jar]");
    }

    private static String searchWeb(String base, String jarFileName) {
        String sCurrentDirTemp = String.valueOf(base) + "web\\WEB-INF\\lib\\";
        File in = new File(String.valueOf(sCurrentDirTemp) + jarFileName);
        if (in.exists()) {
            return sCurrentDirTemp;
        }
        sCurrentDirTemp = String.valueOf(base) + "WebContent\\WEB-INF\\lib\\";
        in = new File(String.valueOf(sCurrentDirTemp) + jarFileName);
        if (in.exists()) {
            return sCurrentDirTemp;
        }
        sCurrentDirTemp = String.valueOf(base) + "WEB-INF\\lib\\";
        in = new File(String.valueOf(sCurrentDirTemp) + jarFileName);
        if (in.exists()) {
            return sCurrentDirTemp;
        }
        return null;
    }

    private static String getDIloadPath(String classpath) {
        if (classpath == null || "".equals(System.getProperty("java.class.path"))) {
            throw new RuntimeException("Not found file [diload.jar]");
        }
        StringTokenizer st = new StringTokenizer(classpath, ";");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (!path.endsWith("diload.jar")) continue;
            return path;
        }
        throw new RuntimeException("Not found file [diload.jar]");
    }

    private static String getCurrentDir(String classpath) {
        String s = ReloaderAgent.getDIloadPath(classpath);
        return ReloaderAgent.getHiguchiCut(s);
    }

    private static String getHiguchiCut(String classpath) {
        if (classpath == null || "".equals(classpath)) {
            return "";
        }
        String path = classpath.replace("diload.jar", "");
        return path.replace("/", "\\");
    }

    public static URLClassLoader getJsloader() {
        return jsloader;
    }

    public static void setJsloader(URLClassLoader jsloader) {
        ReloaderAgent.jsloader = jsloader;
    }
}

