/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.aop.time;

import ikdnet.diload.ConfigMessages;
import ikdnet.diload.aop.time.ClassList;
import ikdnet.diload.aop.time.MethodList;
import ikdnet.diload.aop.time.PackageList;
import ikdnet.diload.aop.time.TimeFilter;
import java.io.File;

public class LoggingProperties {
    private static LoggingProperties p;
    private boolean enable = false;
    private boolean usefile = false;
    private String formatter = "";
    private String filePath = "";
    private String limit = "";
    private String count = "";
    private TimeFilter packagelist;
    private TimeFilter classlist;
    private TimeFilter methodlist;

    private LoggingProperties() {
    }

    public void init() {
        if ("".equals(this.formatter)) {
            this.formatter = "ikdnet.diload.aop.time.TimeFormatter";
        }
        if ("".equals(this.limit)) {
            this.limit = "1000";
        }
        if ("".equals(this.count)) {
            this.count = "3";
        }
        if ("".equals(this.filePath)) {
            String home = System.getProperty("user.home");
            if (!home.endsWith(File.separator)) {
                home = String.valueOf(home) + File.separator;
            }
            this.filePath = String.valueOf(home) + "diload.log";
        }
    }

    public String getFormatter() {
        return this.formatter;
    }

    private void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public String getFilePath() {
        return this.filePath;
    }

    private void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getLimit() {
        return this.limit;
    }

    private void setLimit(String limit) {
        this.limit = limit;
    }

    public String getCount() {
        return this.count;
    }

    private void setCount(String count) {
        this.count = count;
    }

    public static LoggingProperties getInstance() {
        if (p != null) {
            return p;
        }
        p = new LoggingProperties();
        LoggingProperties.createProperties();
        p.init();
        return p;
    }

    private static void createProperties() {
        String value = ConfigMessages.getString("method.time.enable");
        if ("true".equals(value) || "TRUE".equals(value)) {
            LoggingProperties.p.enable = true;
        }
        if ("true".equals(value = ConfigMessages.getString("method.time.useFile")) || "TRUE".equals(value)) {
            LoggingProperties.p.usefile = true;
        }
        value = ConfigMessages.getString("java.util.logging.FileHandler.count");
        p.setCount(value);
        value = ConfigMessages.getString("java.util.logging.FileHandler.pattern");
        p.setFilePath(value);
        value = ConfigMessages.getString("java.util.logging.FileHandler.limit");
        p.setLimit(value);
        value = ConfigMessages.getString("java.util.logging.FileHandler.formatter");
        p.setFormatter(value);
        value = ConfigMessages.getString("method.time.target.package");
        p.setPackagelist(value);
        value = ConfigMessages.getString("method.time.target.class");
        p.setClasslist(value);
        value = ConfigMessages.getString("method.time.filter");
        p.setMethodlist(value);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isUseFile() {
        return this.usefile;
    }

    public TimeFilter getPackagelist() {
        return this.packagelist;
    }

    private void setPackagelist(String packagelist) {
        this.packagelist = new PackageList();
        this.packagelist.setFilterSentence(packagelist);
    }

    public TimeFilter getClasslist() {
        return this.classlist;
    }

    private void setClasslist(String classlist) {
        this.classlist = new ClassList();
        this.classlist.setFilterSentence(classlist);
    }

    public TimeFilter getMethodlist() {
        return this.methodlist;
    }

    private void setMethodlist(String methodlist) {
        this.methodlist = new MethodList();
        this.methodlist.setFilterSentence(methodlist);
    }
}

