/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.aop.time;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TimeFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] o = new Object[1];
    private String lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    @Override
    public synchronized String format(LogRecord logrecord) {
        StringBuffer s = new StringBuffer();
        this.dat.setTime(logrecord.getMillis());
        this.o[0] = this.dat;
        StringBuffer sb = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.o, sb, (FieldPosition)null);
        s.append(logrecord.getLevel().getLocalizedName());
        s.append(":,");
        s.append(sb);
        s.append(",");
        if (logrecord.getSourceClassName() != null) {
            s.append(logrecord.getSourceClassName());
        } else {
            s.append(String.valueOf(logrecord.getLoggerName()) + "[className:None]");
        }
        if (logrecord.getSourceMethodName() != null) {
            s.append(",");
            s.append(logrecord.getSourceMethodName());
            s.append(",");
        } else {
            s.append(",");
            s.append("[methodName:None]");
            s.append(",");
        }
        String ss = this.formatMessage(logrecord);
        s.append(ss);
        s.append(this.lineSeparator);
        if (logrecord.getThrown() != null) {
            try {
                StringWriter stringwriter = new StringWriter();
                PrintWriter printwriter = new PrintWriter(stringwriter);
                logrecord.getThrown().printStackTrace(printwriter);
                printwriter.close();
                s.append(stringwriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s.toString();
    }
}

