/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.argument;

import ikdnet.diload.ArgAttribute;
import ikdnet.diload.argument.ArgBin;
import ikdnet.diload.argument.ArgExclude;
import ikdnet.diload.argument.ArgInclude;
import ikdnet.diload.argument.ArgLib;
import ikdnet.diload.argument.ArgSrc;
import ikdnet.diload.argument.Argument;
import ikdnet.diload.argument.ArgumentTokenizer;
import ikdnet.diload.exception.InvailedArgumentException;
import ikdnet.diload.utils.DILoadUtils;
import java.util.logging.Logger;

public class ArgumentBuilder {
    private static Logger logger = DILoadUtils.createLogger(ArgumentBuilder.class);
    private static final String PATHSEP = "\\";
    private static final char L_BRACES = '{';
    private static final char R_BRACES = '}';
    private static final char DELI = ',';

    public static Argument build(String arg) {
        ArgumentTokenizer t = new ArgumentTokenizer(arg);
        Argument argument = new Argument();
        while (t.hasToken()) {
            ArgAttribute argattribute;
            String token = t.getToken();
            if (token == null || "".equals(token) || token.length() <= 1) {
                throw new InvailedArgumentException("InvaildeArgument:=" + token);
            }
            if (!ArgumentBuilder.isReservedWord(token)) {
                System.out.println("Ignore the Argument token:=" + token);
                logger.info("Ignore the Argument token:=" + token);
                continue;
            }
            if (token.startsWith("bin")) {
                argattribute = ArgumentBuilder.createBinArg(token);
                argument.addArgAttribute("bin", argattribute);
                continue;
            }
            if (token.startsWith("src")) {
                argattribute = ArgumentBuilder.createSrcArg(token);
                argument.addArgAttribute("src", argattribute);
                continue;
            }
            if (token.startsWith("lib")) {
                argattribute = ArgumentBuilder.createLibArg(token);
                argument.addArgAttribute("lib", argattribute);
                continue;
            }
            if (token.startsWith("container.lib")) {
                argattribute = ArgumentBuilder.createContainerLibArg(token);
                argument.addArgAttribute("container.lib", argattribute);
                continue;
            }
            if (token.startsWith("include")) {
                argattribute = ArgumentBuilder.createIncludeArg(token);
                argument.addArgAttribute("include", argattribute);
                continue;
            }
            if (!token.startsWith("exclude")) continue;
            argattribute = ArgumentBuilder.createExcludeArg(token);
            argument.addArgAttribute("exclude", argattribute);
        }
        return argument;
    }

    private static boolean isReservedWord(String token) {
        if (token.startsWith("bin")) {
            return true;
        }
        if (token.startsWith("src")) {
            return true;
        }
        if (token.startsWith("lib")) {
            return true;
        }
        if (token.startsWith("include")) {
            return true;
        }
        if (token.startsWith("exclude")) {
            return true;
        }
        return token.startsWith("container.lib");
    }

    private static ArgAttribute createBinArg(String token) {
        String path = token;
        if (token.length() <= "bin".length() + 1) {
            throw new InvailedArgumentException("InvaildeArgument [bin]:=" + token);
        }
        path = path.substring("bin".length() + 1);
        if (!DILoadUtils.isURLFromFileOrURLName(path = ArgumentBuilder.combinePath(path))) {
            throw new InvailedArgumentException("InvaildeArgument [bin]:=" + token);
        }
        ArgBin argbin = new ArgBin();
        argbin.setArg(path);
        return argbin;
    }

    private static ArgAttribute createSrcArg(String token) {
        String path = token;
        if (token.length() <= "src".length() + 1) {
            throw new InvailedArgumentException("InvaildeArgument [src]:=" + token);
        }
        path = path.substring("src".length() + 1);
        if (!DILoadUtils.isURLFromFileOrURLName(path = ArgumentBuilder.combinePath(path))) {
            throw new InvailedArgumentException("InvaildeArgument [src]:=" + token);
        }
        ArgSrc argSrc = new ArgSrc();
        argSrc.setArg(path);
        return argSrc;
    }

    private static ArgAttribute createLibArg(String token) {
        String path = token;
        if (token.length() <= "lib".length() + 1) {
            throw new InvailedArgumentException("InvaildeArgument [lib]:=" + token);
        }
        path = path.substring("lib".length() + 1);
        if (!DILoadUtils.isURLFromFileOrURLName(path = ArgumentBuilder.combinePath(path))) {
            throw new InvailedArgumentException("InvaildeArgument [lib]:=" + token);
        }
        ArgLib arglib = new ArgLib();
        arglib.setArg(path);
        return arglib;
    }

    private static ArgAttribute createContainerLibArg(String token) {
        String path = token;
        if (token.length() <= "container.lib".length() + 1) {
            throw new InvailedArgumentException("InvaildeArgument [container.lib]:=" + token);
        }
        path = path.substring("container.lib".length() + 1);
        if (!DILoadUtils.isURLFromFileOrURLName(path = ArgumentBuilder.combinePath(path))) {
            throw new InvailedArgumentException("InvaildeArgument [container.lib]:=" + token);
        }
        ArgLib arglib = new ArgLib();
        arglib.setArg(path);
        return arglib;
    }

    private static ArgAttribute createIncludeArg(String token) {
        String path = token;
        if (token.length() <= "include".length() + 1) {
            throw new InvailedArgumentException("InvaildeArgument [include]:=" + token);
        }
        path = path.substring("include".length() + 1);
        char[] c = path.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean flg = false;
        ArgInclude in = new ArgInclude();
        int i = 0;
        while (i < c.length) {
            if ('{' == c[i]) {
                flg = true;
            } else if ('}' == c[i]) {
                flg = false;
            }
            if (!flg && c[i] == ',') {
                in.addArg(sb.toString());
                sb.delete(0, sb.length());
            } else {
                sb.append(c[i]);
                if (i == c.length - 1) {
                    in.addArg(sb.toString());
                }
            }
            ++i;
        }
        return in;
    }

    private static ArgAttribute createExcludeArg(String token) {
        String path = token;
        if (token.length() <= "exclude".length() + 1) {
            throw new InvailedArgumentException("InvaildeArgument [exclude]:=" + token);
        }
        path = path.substring("exclude".length() + 1);
        char[] c = path.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean flg = false;
        ArgExclude ex = new ArgExclude();
        int i = 0;
        while (i < c.length) {
            if ('{' == c[i]) {
                flg = true;
            } else if ('}' == c[i]) {
                flg = false;
            }
            if (!flg && c[i] == ',') {
                ex.addArg(sb.toString());
                sb.delete(0, sb.length());
            } else {
                sb.append(c[i]);
                if (i == c.length - 1) {
                    ex.addArg(sb.toString());
                }
            }
            ++i;
        }
        return ex;
    }

    private static String combinePath(String path) {
        if (!path.endsWith(PATHSEP)) {
            path = String.valueOf(path) + PATHSEP;
        }
        return path;
    }
}

