/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.argument;

import ikdnet.diload.Tokenizer;
import ikdnet.diload.exception.IllegalArgumentException;
import java.util.StringTokenizer;

public class ArgumentTokenizer
implements Tokenizer {
    private static final String DELIMITER = ";";
    private StringTokenizer tokens;
    private String argument;

    public ArgumentTokenizer(String args) {
        this.argument = args;
        this.argument = this.cuttheArgumentHeader(this.argument);
        this.execute();
    }

    private ArgumentTokenizer() {
    }

    @Override
    public String getToken() {
        return this.tokens.nextToken();
    }

    public void setArgument(String args) {
        this.argument = args;
        this.argument = this.cuttheArgumentHeader(this.argument);
        this.execute();
    }

    private void execute() {
        StringTokenizer st;
        this.tokens = st = new StringTokenizer(this.argument, DELIMITER);
    }

    @Override
    public boolean hasToken() {
        return this.tokens.hasMoreTokens();
    }

    private String cuttheArgumentHeader(String argument) {
        if (argument == null || "".equals(argument) || argument.length() <= 1) {
            throw new IllegalArgumentException("IllegalArgument:=" + argument);
        }
        if (argument.startsWith("=")) {
            return argument.substring(1);
        }
        return argument;
    }
}

