/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.check;

import ikdnet.diload.ArgAttribute;
import ikdnet.diload.ConfigMessages;
import ikdnet.diload.Messages;
import ikdnet.diload.ModifyChecker;
import ikdnet.diload.argument.Argument;
import ikdnet.diload.argument.ArgumentBuilder;
import ikdnet.diload.exception.IllegalArgumentException;
import ikdnet.diload.filter.ManagedClassFileFilterImpl;
import ikdnet.diload.filter.UnManagedClassFileFilterImpl;
import ikdnet.diload.manage.TargetResourceManager;
import ikdnet.diload.utils.DILoadUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class AutoModifyChecker
implements ModifyChecker {
    private static long INTERVAL = 1000L;
    private boolean stop;
    private boolean initilized;
    private static TargetResourceManager trm;

    @Override
    public void init(String args) {
        Argument arg;
        ArgAttribute argbin;
        this.initilized = true;
        if (args == null || "".equals(args)) {
            args = this.createPropertiesArg();
        }
        if ((argbin = (arg = ArgumentBuilder.build(args)).getArgAttribute("bin")) == null) {
            throw new IllegalArgumentException("require the bin argument.");
        }
        URL url = DILoadUtils.getURLFromFileOrURLName((String)argbin.getAttribute());
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(url);
        ArgAttribute arglib = arg.getArgAttribute("lib");
        if (arglib != null) {
            List<URL> listlib = DILoadUtils.getJarURLFromFileName((String)arglib.getAttribute());
            for (URL u : listlib) {
                list.add(u);
            }
        }
        URL[] urls = list.toArray(new URL[0]);
        AutoModifyChecker.appendClassPath(arg);
        trm = new TargetResourceManager();
        TargetResourceManager.setArgument(arg);
        UnManagedClassFileFilterImpl unfilter = new UnManagedClassFileFilterImpl();
        unfilter.setArgAttribute(arg.getArgAttribute("exclude"));
        ManagedClassFileFilterImpl filter = new ManagedClassFileFilterImpl();
        filter.setArgAttribute(arg.getArgAttribute("include"));
        TargetResourceManager.registResource(urls, filter, unfilter);
    }

    private static void appendClassPath(Argument arg) {
        Class[] parameters = new Class[]{URL.class};
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            ArgAttribute arglib = arg.getArgAttribute("lib");
            if (arglib != null) {
                List<URL> listlib = DILoadUtils.getJarURLFromFileName((String)arglib.getAttribute());
                for (URL uRL : listlib) {
                }
            }
            if (arglib == null) {
                return;
            }
            String lib = (String)arglib.getAttribute();
            if (lib == null) {
                return;
            }
            System.out.println("lib = " + lib);
            lib = lib.replace("\\", "");
            System.out.println("lib = " + lib);
            File f = new File(lib);
            URL u = f.toURI().toURL();
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String createPropertiesArg() {
        String containerlib;
        String include;
        String exclude;
        String lib;
        String src;
        String args = "";
        String bin = ConfigMessages.getString("bin");
        if (bin != null && !"".equals(bin)) {
            args = String.valueOf(args) + "bin" + "=" + bin + ";";
        }
        if ((src = ConfigMessages.getString("src")) != null && !"".equals(src)) {
            args = String.valueOf(args) + "src" + "=" + src + ";";
        }
        if ((lib = ConfigMessages.getString("lib")) != null && !"".equals(lib)) {
            args = String.valueOf(args) + "lib" + "=" + lib + ";";
        }
        if ((exclude = ConfigMessages.getString("exclude")) != null && !"".equals(exclude)) {
            args = String.valueOf(args) + "exclude" + "=" + exclude + ";";
        }
        if ((include = ConfigMessages.getString("include")) != null && !"".equals(include)) {
            args = String.valueOf(args) + "include" + "=" + include + ";";
        }
        if ((containerlib = ConfigMessages.getString("container.lib")) != null && !"".equals(containerlib)) {
            args = String.valueOf(args) + "container.lib" + "=" + containerlib + ";";
        }
        return args;
    }

    public void checkWeb() {
        block10: {
            try {
                if (!DILoadUtils.validateWebJarFile()) break block10;
                Class c = DILoadUtils.getServletClass();
                Object o = DILoadUtils.getCreateProxy(c, null);
                try {
                    Method m = c.getDeclaredMethod("getServletContext", new Class[1]);
                    m.setAccessible(true);
                    Object x = m.invoke(o, new Object[0]);
                    Class<?> cx = Class.forName("javax.servlet.ServletContext");
                    if (cx != null && x != null) {
                        Method mx = c.getDeclaredMethod("getRealPath", String.class);
                        mx.setAccessible(true);
                        Object xx = mx.invoke(x, "/");
                        System.out.println((String)xx);
                        break block10;
                    }
                    System.out.println("null");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void start() {
        if (!this.initilized) {
            throw new RuntimeException(Messages.getString("AutoModifyChecker.0"));
        }
        Thread thread = new Thread(new AutoChecker());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public void terminate() {
        if (!this.stop) {
            throw new RuntimeException(Messages.getString("AutoModifyChecker.1"));
        }
    }

    protected void checkModified() {
        TargetResourceManager.checkModified();
    }

    private class AutoChecker
    implements Runnable {
        private AutoChecker() {
        }

        @Override
        public void run() {
            while (!AutoModifyChecker.this.stop) {
                try {
                    Thread.sleep(INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AutoModifyChecker.this.checkModified();
            }
        }
    }
}

