/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.manage;

import ikdnet.diload.InstrumentationFactory;
import ikdnet.diload.ManagedClassFileFilter;
import ikdnet.diload.ManagedFilter;
import ikdnet.diload.Messages;
import ikdnet.diload.Redifiner;
import ikdnet.diload.UnManagedClassFileFilter;
import ikdnet.diload.argument.Argument;
import ikdnet.diload.filter.ClassFileFilter;
import ikdnet.diload.resource.JavaClassResource;
import ikdnet.diload.utils.DILoadUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class TargetResourceManager {
    private static Logger logger = DILoadUtils.createLogger(TargetResourceManager.class);
    private static Map<String, JavaClassResource> resourceMap = new LinkedHashMap<String, JavaClassResource>();
    private static URLClassLoader urlcl;
    private static Object LOCK;
    private static Argument argument;

    static {
        LOCK = new Object();
    }

    public static Map<String, JavaClassResource> getResourceMap() {
        return resourceMap;
    }

    public static void setResourceMap(Map<String, JavaClassResource> resourceMap) {
        TargetResourceManager.resourceMap = resourceMap;
    }

    public static boolean isExit(Object key) {
        if (resourceMap == null) {
            return false;
        }
        return resourceMap.containsKey(key);
    }

    public static boolean isExitName(String name) {
        boolean ret = false;
        if (resourceMap == null) {
            return ret;
        }
        for (Map.Entry<String, JavaClassResource> e : resourceMap.entrySet()) {
            JavaClassResource jcr = e.getValue();
            if (!jcr.getName().replace(".", "/").equals(name)) continue;
            ret = true;
        }
        return ret;
    }

    public static URLClassLoader getUrlcl() {
        return urlcl;
    }

    public static void setUrlcl(URLClassLoader urlcl) {
        TargetResourceManager.urlcl = urlcl;
    }

    public static boolean isResourceModified(String key) {
        return false;
    }

    public static void registResource(URL[] urls) {
    }

    public static void registResource(URL[] urls, ManagedFilter[] filter) {
    }

    private static void regist(URL url, ManagedClassFileFilter filter, UnManagedClassFileFilter unfilter) {
        File fl;
        File f = new File(url.getPath());
        if (f.isDirectory()) {
            File[] files = f.listFiles(new ClassFileFilter());
            int i = 0;
            while (i < files.length) {
                String name;
                JavaClassResource jcr;
                URL lurl;
                File fl2;
                if (filter.accept(files[i].getName())) {
                    fl2 = files[i];
                    if (fl2.isFile()) {
                        lurl = DILoadUtils.getURLFromFileOrURLName(fl2.getPath());
                        jcr = new JavaClassResource();
                        jcr.setUrl(lurl);
                        jcr.setLastModified(fl2.lastModified());
                        name = DILoadUtils.getPackageName(urlcl.getURLs(), jcr.getUrl());
                        jcr.setName(name);
                        resourceMap.put(lurl.getPath(), jcr);
                        logger.info(String.valueOf(lurl.getPath()) + Messages.getString("TargetResourceManager.0"));
                    } else {
                        TargetResourceManager.regist(DILoadUtils.getURLFromFileOrURLName(fl2.getPath()), filter, unfilter);
                    }
                } else if (unfilter.accept(files[i].getName())) {
                    fl2 = files[i];
                    if (fl2.isFile()) {
                        lurl = DILoadUtils.getURLFromFileOrURLName(fl2.getPath());
                        jcr = new JavaClassResource();
                        jcr.setUrl(lurl);
                        jcr.setLastModified(fl2.lastModified());
                        name = DILoadUtils.getPackageName(urlcl.getURLs(), jcr.getUrl());
                        jcr.setName(name);
                        resourceMap.put(lurl.getPath(), jcr);
                        logger.info(String.valueOf(lurl.getPath()) + Messages.getString("TargetResourceManager.2"));
                    } else {
                        TargetResourceManager.regist(DILoadUtils.getURLFromFileOrURLName(fl2.getPath()), filter, unfilter);
                    }
                }
                ++i;
            }
        } else if (filter.accept(f.getPath())) {
            File fl3 = f;
            if (fl3.isFile()) {
                URL lurl = DILoadUtils.getURLFromFileOrURLName(fl3.getPath());
                JavaClassResource jcr = new JavaClassResource();
                jcr.setUrl(lurl);
                jcr.setLastModified(fl3.lastModified());
                String name = DILoadUtils.getPackageName(urlcl.getURLs(), jcr.getUrl());
                jcr.setName(name);
                resourceMap.put(lurl.getPath(), jcr);
                logger.info(String.valueOf(f.getPath()) + Messages.getString("TargetResourceManager.1"));
            }
        } else if (unfilter.accept(f.getName()) && (fl = f).isFile()) {
            URL lurl = DILoadUtils.getURLFromFileOrURLName(fl.getPath());
            JavaClassResource jcr = new JavaClassResource();
            jcr.setUrl(lurl);
            jcr.setLastModified(fl.lastModified());
            String name = DILoadUtils.getPackageName(urlcl.getURLs(), jcr.getUrl());
            jcr.setName(name);
            resourceMap.put(lurl.getPath(), jcr);
            logger.info(String.valueOf(lurl.getPath()) + Messages.getString("TargetResourceManager.2"));
        }
    }

    public static void registResource(URL[] urls, ManagedClassFileFilter filter, UnManagedClassFileFilter unfilter) {
        urlcl = new URLClassLoader(urls);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            File f = new File(url.getPath());
            if (f.isDirectory()) {
                File[] files = f.listFiles(new ClassFileFilter());
                int i = 0;
                while (i < files.length) {
                    String name;
                    JavaClassResource jcr;
                    URL lurl;
                    File fl;
                    if (filter.accept(files[i].getName())) {
                        fl = files[i];
                        if (fl.isFile()) {
                            lurl = DILoadUtils.getURLFromFileOrURLName(fl.getPath());
                            jcr = new JavaClassResource();
                            jcr.setUrl(lurl);
                            jcr.setLastModified(fl.lastModified());
                            name = DILoadUtils.getPackageName(urlcl.getURLs(), jcr.getUrl());
                            jcr.setName(name);
                            resourceMap.put(lurl.getPath(), jcr);
                            logger.info(String.valueOf(lurl.getPath()) + Messages.getString("TargetResourceManager.2"));
                        } else {
                            TargetResourceManager.regist(DILoadUtils.getURLFromFileOrURLName(fl.getPath()), filter, unfilter);
                        }
                    } else if (unfilter.accept(files[i].getName())) {
                        fl = files[i];
                        if (fl.isFile()) {
                            lurl = DILoadUtils.getURLFromFileOrURLName(fl.getPath());
                            jcr = new JavaClassResource();
                            jcr.setUrl(lurl);
                            jcr.setLastModified(fl.lastModified());
                            name = DILoadUtils.getPackageName(urlcl.getURLs(), jcr.getUrl());
                            jcr.setName(name);
                            resourceMap.put(lurl.getPath(), jcr);
                            logger.info(String.valueOf(lurl.getPath()) + Messages.getString("TargetResourceManager.2"));
                        } else {
                            TargetResourceManager.regist(DILoadUtils.getURLFromFileOrURLName(fl.getPath()), filter, unfilter);
                        }
                    }
                    ++i;
                }
            } else {
                logger.info(String.valueOf(f.getPath()) + Messages.getString("TargetResourceManager.3"));
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkModified() {
        if (resourceMap == null) {
            return;
        }
        for (Map.Entry<String, JavaClassResource> e : resourceMap.entrySet()) {
            String filename = e.getKey();
            File file = new File(filename);
            JavaClassResource jcr = resourceMap.get(filename);
            Long lastModified = jcr.getLastModified();
            long newLastModified = file.lastModified();
            if (lastModified == null || lastModified >= newLastModified) continue;
            jcr.setLastModified(newLastModified);
            String name = jcr.getName();
            try {
                Class<?> c = jcr.getResourceClass();
                if (c == null) {
                    c = urlcl.loadClass(name);
                    jcr.setResourceClass(c);
                }
                if (c == null || (c = DILoadUtils.getSameClass(InstrumentationFactory.getLoadedClass(), c)) == null) continue;
                logger.info(String.valueOf(filename) + Messages.getString("AutoModifyChecker.2"));
                logger.info(String.valueOf(filename) + Messages.getString("AutoModifyChecker.3"));
                Object object = LOCK;
                synchronized (object) {
                    Redifiner.redefine(c, filename);
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Argument getArgument() {
        return argument;
    }

    public static void setArgument(Argument argument) {
        TargetResourceManager.argument = argument;
    }
}

