/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils;

import ikdnet.diload.filter.JarFileFilter;
import ikdnet.diload.utils.InvocationHandlerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DILoadUtils {
    public static URL getURLFromFileOrURLName(String name) {
        try {
            return new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                char sep = File.separator.charAt(0);
                String file = name.replace(sep, '/');
                if (file.charAt(0) != '/' && file.indexOf(":") < 0) {
                    String dir = System.getProperty("user.dir");
                    if ((dir = String.valueOf(dir.replace(sep, '/')) + '/').charAt(0) != '/') {
                        dir = "/" + dir;
                    }
                    file = String.valueOf(dir) + file;
                }
                return new URL("file", "", file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<URL> getJarURLFromFileName(String filename) {
        char sep = File.separator.charAt(0);
        File file = new File(filename);
        URL url = null;
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            if (file.isDirectory()) {
                File[] files;
                File[] fileArray = files = file.listFiles(new JarFileFilter());
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    String name = f.getPath();
                    name = name.replace(sep, '/');
                    String base = new File(name).getCanonicalFile().toURI().toString();
                    url = new URL("jar:" + base + "!/");
                    list.add(url);
                    ++n2;
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static boolean isURLFromFileOrURLName(String name) {
        try {
            new URL(name);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                char sep = File.separator.charAt(0);
                String file = name.replace(sep, '/');
                if (file.charAt(0) != '/' && file.indexOf(":") < 0) {
                    String dir = System.getProperty("user.dir");
                    if ((dir = String.valueOf(dir.replace(sep, '/')) + '/').charAt(0) != '/') {
                        dir = "/" + dir;
                    }
                    file = String.valueOf(dir) + file;
                }
                new URL("file", "", file);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
    }

    public static String getPackageName(URL[] urls, URL targetUrl) {
        URL url = urls[0];
        String target = url.getPath();
        target = target.replace("//", "/");
        String name = targetUrl.getPath();
        name = name.replace(target, "");
        name = name.replace("/", ".");
        name = name.replace(".class", "");
        return name;
    }

    public static byte[] loadByte(String fileName) {
        try {
            File f = new File(fileName);
            byte[] b = null;
            long lb = f.length();
            b = new byte[(int)lb];
            FileInputStream fi = new FileInputStream(f);
            fi.read(b);
            fi.close();
            return b;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static boolean isSameClass(Class<?> c1, Class<?> c2) {
        String c2Name;
        if (c1 == null) {
            throw new RuntimeException("c1 class is null!");
        }
        if (c2 == null) {
            throw new RuntimeException("c2 class is null!");
        }
        String c1Name = c1.getName();
        return c1Name.equals(c2Name = c2.getName());
    }

    public static Class<?> getSameClass(Class<?>[] c1, Class<?> target) {
        if (c1 == null) {
            throw new RuntimeException("Class array is null!");
        }
        if (target == null) {
            throw new RuntimeException("target class is null!");
        }
        Class<?>[] classArray = c1;
        int n = c1.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (DILoadUtils.isSameClass(c, target)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean validateWebJarFile() {
        String[] triggers = new String[]{"javax.servlet.Servlet", "javax.servlet.GenericServlet"};
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        int i = 0;
        while (i < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(triggers[i]);
            }
            catch (Throwable t) {
                clazz = null;
            }
            try {
                if (clazz == null && parent != null) {
                    clazz = parent.loadClass(triggers[i]);
                }
            }
            catch (Throwable t) {
                clazz = null;
            }
            if (clazz != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean validateTomcat() {
        String[] triggers = new String[]{"org.apache.catalina.loader.StandardClassLoader"};
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        int i = 0;
        while (i < triggers.length) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(triggers[i]);
            }
            catch (Throwable t) {
                clazz = null;
            }
            try {
                if (clazz == null && parent != null) {
                    clazz = parent.loadClass(triggers[i]);
                }
            }
            catch (Throwable t) {
                clazz = null;
            }
            if (clazz != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Class getServletClass() throws IOException {
        String[] triggers = new String[]{"javax.servlet.GenericServlet"};
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        Class<?> clazz = null;
        int i = 0;
        while (i < triggers.length) {
            try {
                clazz = Class.forName(triggers[i]);
            }
            catch (Throwable t) {
                clazz = null;
            }
            try {
                if (clazz == null && parent != null) {
                    clazz = parent.loadClass(triggers[i]);
                }
            }
            catch (Throwable t) {
                clazz = null;
            }
            ++i;
        }
        return clazz;
    }

    public static <T> T getCreateProxy(Class<T> proxyClass, Object proxyObject) {
        InvocationHandlerImpl handler = new InvocationHandlerImpl(proxyObject);
        Class[] interfaces = new Class[]{proxyClass};
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return (T)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    public static void crearStaticReference(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        try {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                int mods = field.getModifiers();
                if (!field.getType().isPrimitive() && field.getName().indexOf("$") == -1 && Modifier.isStatic(mods)) {
                    try {
                        field.setAccessible(true);
                        if (Modifier.isFinal(mods) && !field.getType().getName().startsWith("java.") && !field.getType().getName().startsWith("javax.")) {
                            field.set(null, null);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String native2ascii(String str) {
        StringBuilder sb = new StringBuilder();
        if (str == null) {
            return null;
        }
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                sb.append(c);
            } else {
                sb.append("\\u");
                String hexStr = Integer.toHexString(c);
                int zeroCount = 4 - hexStr.length();
                int j = 0;
                while (j < zeroCount) {
                    sb.append('0');
                    ++j;
                }
                sb.append(hexStr);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String ascii2native(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int maxlength = str.length();
        int i = 0;
        while (i < maxlength) {
            if (str.charAt(i) == '\\') {
                if (i < maxlength - 5 && (str.charAt(i + 1) == 'u' || str.charAt(i + 1) == 'U')) {
                    try {
                        sb.append((char)Integer.parseInt(str.substring(i + 2, i + 6), 16));
                        i += 5;
                    }
                    catch (NumberFormatException e) {
                        sb.append(str.charAt(i));
                    }
                } else {
                    sb.append(str.charAt(i));
                }
            } else {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static int getJavaVersion() {
        String javaversion = System.getProperty("java.runtime.version");
        if (javaversion.startsWith("1.1")) {
            return 1;
        }
        if (javaversion.startsWith("1.2")) {
            return 2;
        }
        if (javaversion.startsWith("1.3")) {
            return 3;
        }
        if (javaversion.startsWith("1.4")) {
            return 4;
        }
        if (javaversion.startsWith("1.5")) {
            return 5;
        }
        if (javaversion.startsWith("1.6")) {
            return 6;
        }
        if (javaversion.startsWith("1.7")) {
            return 7;
        }
        return 4;
    }

    public static String combinePath(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static Logger createLogger(Class<?> c) {
        String className = c.getName();
        return Logger.getLogger(className);
    }
}

