/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import ikdnet.diload.utils.DILoadUtils;
import ikdnet.diload.utils.tools.editor.JTextPaneArea;
import ikdnet.diload.utils.tools.editor.JarFileResource;
import ikdnet.diload.utils.tools.editor.JarReader;
import ikdnet.diload.utils.tools.editor.JarResources;
import ikdnet.diload.utils.tools.editor.JarWriter;
import ikdnet.diload.utils.tools.editor.LineNumber;
import ikdnet.diload.utils.tools.editor.Messages;
import ikdnet.diload.utils.tools.editor.PropertiesTokenReader;
import ikdnet.diload.utils.tools.editor.PropertiesType;
import ikdnet.diload.utils.tools.editor.StringToken;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import java.util.jar.JarEntry;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class Editor
extends JFrame {
    private static final long serialVersionUID = 287657562685976204L;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem saveMenuItem = null;
    private JMenuItem exitMenuItem = null;
    private JMenu editMenu = null;
    private UndoManager undoManager = new UndoManager();
    private JMenuItem undoMenuItem = null;
    private JMenuItem redoMenuItem = null;
    private JMenuItem cutMenuItem = null;
    private JMenuItem copyMenuItem = null;
    private JMenuItem pasteMenuItem = null;
    private JMenuItem deleteMenuItem = null;
    private JMenuItem goToMenuItem = null;
    private JMenuItem selectAllMenuItem = null;
    private JMenu displayMenu = null;
    private JCheckBoxMenuItem statusBarCheckBoxMenuItem = null;
    private JMenu helpMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JTextPaneArea jTextArea = null;
    private JScrollPane jScrollPane = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private static Editor frame = null;
    private static String jarFilePath = "";
    private static final String APP_NAME = Messages.getString("Editor.1");
    private static final String VERSION = Messages.getString("Editor.2");
    private static final int MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String FILE_ID = Messages.getString("Editor.3");
    public static final String FILE_NAME = String.valueOf(FILE_ID) + Messages.getString("Editor.4");
    public static final String DEFAULT_FILE_NAME = "default" + FILE_ID + Messages.getString("Editor.4");
    private static final Font DEFAULT_FONT = new Font(Messages.getString("Editor.5"), 0, 14);
    private boolean hasChanged = false;
    private JPopupMenu pop;
    private Action[] action;

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getEditMenu());
            this.jJMenuBar.add(this.getDisplayMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setName(Messages.getString("Editor.6"));
            this.fileMenu.setText(Messages.getString("Editor.7"));
            this.fileMenu.setMnemonic(70);
            this.fileMenu.setActionCommand(Messages.getString("Editor.8"));
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText(Messages.getString("Editor.9"));
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, MASK));
            this.saveMenuItem.setMnemonic(83);
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.saveFile();
                }
            });
        }
        return this.saveMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText(Messages.getString("Editor.10"));
            this.exitMenuItem.setMnemonic(88);
            this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, MASK));
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.exit();
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu();
            this.editMenu.setText(Messages.getString("Editor.11"));
            this.editMenu.setMnemonic(69);
            this.editMenu.add(this.getUndoMenuItem());
            this.editMenu.add(this.getRedoMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getCutMenuItem());
            this.editMenu.add(this.getCopyMenuItem());
            this.editMenu.add(this.getPasteMenuItem());
            this.editMenu.add(this.getDeleteMenuItem());
            this.editMenu.add(this.getGoToMenuItem());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getSelectAllMenuItem());
            this.editMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    boolean hasSelectedText = Editor.this.jTextArea.getSelectedText() != null;
                    Editor.this.cutMenuItem.setEnabled(hasSelectedText);
                    Editor.this.copyMenuItem.setEnabled(hasSelectedText);
                    Editor.this.deleteMenuItem.setEnabled(hasSelectedText);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    Editor.this.cutMenuItem.setEnabled(true);
                    Editor.this.copyMenuItem.setEnabled(true);
                    Editor.this.deleteMenuItem.setEnabled(true);
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
        return this.editMenu;
    }

    private JMenuItem getUndoMenuItem() {
        if (this.undoMenuItem == null) {
            this.undoMenuItem = new JMenuItem();
            this.undoMenuItem.setText(Messages.getString("Editor.12"));
            this.undoMenuItem.setMnemonic(85);
            this.undoMenuItem.setActionCommand(Messages.getString("Editor.13"));
            this.undoMenuItem.setEnabled(false);
            this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, MASK));
            this.undoMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Editor.this.undoManager.undo();
                    }
                    catch (CannotUndoException cue) {
                        JOptionPane.showMessageDialog(Editor.this.jContentPane, Messages.getString("Editor.14"), cue.toString(), 0);
                    }
                    Editor.this.update();
                }
            });
        }
        return this.undoMenuItem;
    }

    private JMenuItem getRedoMenuItem() {
        if (this.redoMenuItem == null) {
            this.redoMenuItem = new JMenuItem();
            this.redoMenuItem.setText(Messages.getString("Editor.15"));
            this.redoMenuItem.setMnemonic(82);
            this.redoMenuItem.setActionCommand(Messages.getString("Editor.16"));
            this.redoMenuItem.setEnabled(false);
            this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, MASK));
            this.redoMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Editor.this.undoManager.redo();
                    }
                    catch (CannotRedoException cre) {
                        JOptionPane.showMessageDialog(Editor.this.jContentPane, Messages.getString("Editor.17"), cre.toString(), 0);
                    }
                    Editor.this.update();
                }
            });
        }
        return this.redoMenuItem;
    }

    private JMenuItem getCutMenuItem() {
        if (this.cutMenuItem == null) {
            this.cutMenuItem = new JMenuItem();
            this.cutMenuItem.setText(Messages.getString("Editor.18"));
            this.cutMenuItem.setMnemonic(84);
            this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, MASK));
            this.cutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.jTextArea.cut();
                }
            });
        }
        return this.cutMenuItem;
    }

    private JMenuItem getCopyMenuItem() {
        if (this.copyMenuItem == null) {
            this.copyMenuItem = new JMenuItem();
            this.copyMenuItem.setText(Messages.getString("Editor.19"));
            this.copyMenuItem.setMnemonic(67);
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, MASK));
            this.copyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.jTextArea.copy();
                }
            });
        }
        return this.copyMenuItem;
    }

    private JMenuItem getPasteMenuItem() {
        if (this.pasteMenuItem == null) {
            this.pasteMenuItem = new JMenuItem();
            this.pasteMenuItem.setText(Messages.getString("Editor.20"));
            this.pasteMenuItem.setMnemonic(80);
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, MASK));
            this.pasteMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.jTextArea.paste();
                }
            });
        }
        return this.pasteMenuItem;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.setText(Messages.getString("Editor.21"));
            this.deleteMenuItem.setMnemonic(68);
            this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.deleteMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.jTextArea.replaceSelection(null);
                }
            });
        }
        return this.deleteMenuItem;
    }

    private JMenuItem getGoToMenuItem() {
        if (this.goToMenuItem == null) {
            this.goToMenuItem = new JMenuItem();
            this.goToMenuItem.setText(Messages.getString("Editor.22"));
            this.goToMenuItem.setMnemonic(71);
            this.goToMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, MASK));
            this.goToMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    while (true) {
                        try {
                            String ans = JOptionPane.showInputDialog(Editor.this.jContentPane, Messages.getString("Editor.23"), Messages.getString("Editor.24"), 3);
                            if (ans == null) {
                                return;
                            }
                            int rowNum = Integer.valueOf(ans) - 1;
                            Editor.this.jTextArea.setCaretPosition(Editor.this.jTextArea.getLineStartOffset(rowNum));
                            return;
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(Editor.this.jContentPane, Messages.getString("Editor.25"), nfe.toString(), 0);
                            continue;
                        }
                        catch (BadLocationException ble) {
                            JOptionPane.showMessageDialog(Editor.this.jContentPane, Messages.getString("Editor.26"), ble.toString(), 0);
                            continue;
                        }
                        break;
                    }
                }
            });
        }
        return this.goToMenuItem;
    }

    private JMenuItem getSelectAllMenuItem() {
        if (this.selectAllMenuItem == null) {
            this.selectAllMenuItem = new JMenuItem();
            this.selectAllMenuItem.setText(Messages.getString("Editor.27"));
            this.selectAllMenuItem.setMnemonic(65);
            this.selectAllMenuItem.setActionCommand(Messages.getString("Editor.28"));
            this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, MASK));
            this.selectAllMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.jTextArea.selectAll();
                }
            });
        }
        return this.selectAllMenuItem;
    }

    private JMenu getDisplayMenu() {
        if (this.displayMenu == null) {
            this.displayMenu = new JMenu();
            this.displayMenu.setText(Messages.getString("Editor.29"));
            this.displayMenu.setMnemonic(86);
            this.displayMenu.add(this.getStatusBarCheckBoxMenuItem());
        }
        return this.displayMenu;
    }

    private JCheckBoxMenuItem getStatusBarCheckBoxMenuItem() {
        if (this.statusBarCheckBoxMenuItem == null) {
            this.statusBarCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.statusBarCheckBoxMenuItem.setSelected(true);
            this.statusBarCheckBoxMenuItem.setText(Messages.getString("Editor.30"));
            this.statusBarCheckBoxMenuItem.setMnemonic(83);
            this.statusBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (Editor.this.statusBarCheckBoxMenuItem.isSelected()) {
                        Editor.this.jLabel.setVisible(true);
                        Editor.this.jLabel1.setVisible(true);
                    } else {
                        Editor.this.jLabel.setVisible(false);
                        Editor.this.jLabel1.setVisible(false);
                    }
                }
            });
        }
        return this.statusBarCheckBoxMenuItem;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(Messages.getString("Editor.31"));
            this.helpMenu.setMnemonic(72);
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText(String.valueOf(APP_NAME) + Messages.getString("Editor.32"));
            this.aboutMenuItem.setMnemonic(65);
            this.aboutMenuItem.setName(String.valueOf(APP_NAME) + Messages.getString("Editor.33"));
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(Editor.this.jContentPane, String.valueOf(Messages.getString("Editor.34")) + Messages.getString("Editor.35") + VERSION + " \n " + Messages.getString("Editor.37") + Messages.getString("Editor.38"), Messages.getString("Editor.39"), 1);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JTextPaneArea getJTextArea() {
        if (this.jTextArea == null) {
            if (this.jTextArea == null) {
                this.jTextArea = new JTextPaneArea();
                this.jTextArea.setFont(DEFAULT_FONT);
            }
            InputMap inputMap = this.jTextArea.getInputMap();
            ActionMap actionMap = this.jTextArea.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(73, MASK), Messages.getString("Editor.40"));
            actionMap.put(Messages.getString("Editor.41"), new DefaultEditorKit.InsertTabAction());
            inputMap.put(KeyStroke.getKeyStroke(74, MASK), Messages.getString("Editor.42"));
            inputMap.put(KeyStroke.getKeyStroke(77, MASK), Messages.getString("Editor.43"));
            actionMap.put(Messages.getString("Editor.44"), new DefaultEditorKit.InsertBreakAction());
            this.jTextArea.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    try {
                        int caretPosition = Editor.this.jTextArea.getCaretPosition();
                        int lineNum = Editor.this.jTextArea.getLineOfOffset(caretPosition);
                        Editor.this.setJLabel1Text(lineNum + 1, caretPosition - Editor.this.jTextArea.getLineStartOffset(lineNum) + 1);
                    }
                    catch (BadLocationException ble) {
                        JOptionPane.showMessageDialog(Editor.this.jContentPane, Messages.getString("Editor.45"), ble.toString(), 0);
                    }
                }
            });
            Document document = this.jTextArea.getDocument();
            document.addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Editor.this.setChanged();
                    Editor.this.invokeSetHighlight();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    Editor.this.setChanged();
                    Editor.this.invokeSetHighlight();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            document.addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    Editor.this.undoManager.addEdit(e.getEdit());
                    Editor.this.update();
                }
            });
            this.jTextArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        Editor.this.showJPopupMenu(Editor.this.jTextArea, e);
                    }
                }
            });
        }
        return this.jTextArea;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            LineNumber lineNumber = new LineNumber(this.getJTextArea());
            lineNumber.setPreferredSize(999);
            LineBorder border = new LineBorder(Color.LIGHT_GRAY, 1, true);
            lineNumber.setBorder(border);
            this.jScrollPane.setRowHeaderView(lineNumber);
            this.jScrollPane.setViewportView(this.getJTextArea());
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setEnabled(true);
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJLabel(), "Center");
            this.jPanel.add((Component)this.getJLabel1(), "East");
        }
        return this.jPanel;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.setJLabelText();
            this.jLabel.setName(Messages.getString("Editor.46"));
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.setJLabel1Text();
            this.jLabel1.setName(Messages.getString("Editor.47"));
        }
        return this.jLabel1;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.exit(0);
        }
        try {
            if (args.length > 0) {
                jarFilePath = args[0];
            }
            frame = new Editor();
            frame.initialize();
            frame.openFile();
            frame.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), e.toString(), 0);
        }
    }

    private void initialize() {
        this.setSize(600, 500);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.jContentPane, Messages.getString("Editor.48"), e.toString(), 0);
        }
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getJJMenuBar());
        this.setDefaultCloseOperation(0);
        this.setThisTitle();
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Editor.this.exit();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private void showJPopupMenu(final JTextPaneArea jTextArea, MouseEvent me) {
        if (this.pop == null) {
            this.pop = new JPopupMenu();
            this.action = new Action[5];
            this.action[0] = new DefaultEditorKit.CutAction();
            this.action[0].putValue("Name", Messages.getString("Editor.49"));
            this.action[1] = new DefaultEditorKit.CopyAction();
            this.action[1].putValue("Name", Messages.getString("Editor.50"));
            this.action[2] = new DefaultEditorKit.PasteAction();
            this.action[2].putValue("Name", Messages.getString("Editor.51"));
            this.action[3] = new AbstractAction(Messages.getString("Editor.52")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jTextArea.replaceSelection(null);
                }
            };
            this.action[4] = new AbstractAction(Messages.getString("Editor.53")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    jTextArea.selectAll();
                }
            };
            int i = 0;
            while (i < 5) {
                this.pop.add(this.action[i]);
                if (i == 3) {
                    this.pop.addSeparator();
                }
                ++i;
            }
        }
        boolean flg = jTextArea.getSelectedText() != null;
        int i = 0;
        while (i < 4) {
            if (i != 2) {
                this.action[i].setEnabled(flg);
            }
            ++i;
        }
        this.action[4].setEnabled(!jTextArea.getText().equals(""));
        this.pop.show(jTextArea, me.getX(), me.getY());
    }

    private void openFile() {
        try {
            int tabSize = this.jTextArea.getTabSize();
            InputStream is = this.getClass().getResourceAsStream(FILE_NAME);
            if (is == null && (is = this.getClass().getResourceAsStream("/" + FILE_NAME)) == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String data = "";
            String line = "";
            while ((line = reader.readLine()) != null) {
                data = String.valueOf(data) + DILoadUtils.ascii2native(line) + "\n";
            }
            if (data.replace("\n", "").trim().equals("")) {
                is = this.getClass().getResourceAsStream(DEFAULT_FILE_NAME);
                if (is == null && (is = this.getClass().getResourceAsStream("/" + DEFAULT_FILE_NAME)) == null) {
                    return;
                }
                reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    data = String.valueOf(data) + DILoadUtils.ascii2native(line) + "\n";
                }
            }
            StringReader sr = new StringReader(data);
            this.jTextArea.read(sr, (Object)this.jTextArea.getDocument());
            reader.close();
            sr.close();
            this.jTextArea.setTabSize(tabSize);
            this.reset();
            this.setHighlight();
        }
        catch (IOException ie) {
            JOptionPane.showMessageDialog(this.jContentPane, Messages.getString("Editor.59"), ie.toString(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), e.toString(), 0);
        }
    }

    private void saveFile() {
        if (jarFilePath != null && !"".equals(jarFilePath)) {
            try {
                File f = new File(String.valueOf(jarFilePath) + "diload.jar");
                JarResources jr = JarReader.read(f);
                JarEntry entry = new JarEntry(FILE_NAME);
                JarFileResource fr = new JarFileResource();
                String str = this.jTextArea.getText();
                str = DILoadUtils.native2ascii(str);
                fr.setData(str.getBytes());
                fr.setJarentry(entry);
                fr.setIsdirectory(false);
                jr.getFileresources().put(entry.getName(), fr);
                JarWriter.write(f, jr);
                this.setThisTitle();
                this.hasChanged = false;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, String.valueOf(e.getMessage()) + jarFilePath, e.toString(), 0);
            }
        }
    }

    private boolean closeFile() {
        if (this.hasChanged) {
            String str = this.getTitle();
            int ans = JOptionPane.showConfirmDialog(this.jContentPane, String.valueOf(str) + Messages.getString("Editor.61"));
            if (ans == 0) {
                this.saveFile();
            } else if (ans == 2 || ans == -1) {
                return false;
            }
        }
        return true;
    }

    private void exit() {
        boolean closed = this.closeFile();
        if (closed) {
            this.setVisible(false);
            this.setThisTitle();
            System.exit(0);
        }
    }

    private void update() {
        this.undoMenuItem.setEnabled(this.undoManager.canUndo());
        this.redoMenuItem.setEnabled(this.undoManager.canRedo());
    }

    private void reset() {
        this.setJLabel1Text();
        this.hasChanged = false;
        this.undoManager = new UndoManager();
        Document document = this.jTextArea.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Editor.this.setChanged();
                Editor.this.invokeSetHighlight();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Editor.this.setChanged();
                Editor.this.invokeSetHighlight();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                Editor.this.undoManager.addEdit(e.getEdit());
                Editor.this.update();
            }
        });
        this.update();
    }

    private void setChanged() {
        if (!this.hasChanged) {
            this.hasChanged = true;
            this.setTitle(String.valueOf(Messages.getString("Editor.62")) + this.getTitle());
        }
    }

    private void setThisTitle() {
        this.setThisTitle(Messages.getString("Editor.63"));
    }

    private void setThisTitle(String text) {
        this.setTitle(String.valueOf(text) + Messages.getString("Editor.64") + APP_NAME);
    }

    private void setJLabelText() {
        this.jLabel.setText(Messages.getString("Editor.65"));
    }

    private void setJLabel1Text() {
        this.setJLabel1Text(1, 1);
    }

    private void setJLabel1Text(int row, int column) {
        StringBuffer sb = new StringBuffer();
        sb.append(row);
        sb.append(Messages.getString("Editor.66"));
        sb.append(column);
        sb.append(Messages.getString("Editor.67"));
        this.jLabel1.setText(sb.toString());
    }

    private void setHighlight() {
        String text = this.jTextArea.getText();
        StyledDocument doc = (StyledDocument)this.jTextArea.getDocument();
        SimpleAttributeSet plane = new SimpleAttributeSet();
        doc.setCharacterAttributes(0, text.length(), plane, true);
        SimpleAttributeSet attr = new SimpleAttributeSet();
        SimpleAttributeSet comment = new SimpleAttributeSet();
        StyleConstants.setForeground(attr, Color.BLUE);
        StyleConstants.setForeground(comment, new Color(0, 102, 51));
        List<StringToken> l = PropertiesTokenReader.read(text);
        for (StringToken t : l) {
            if (t.getPropertiestype() == PropertiesType.VALUE) {
                if (t.getValue() == null || "".equals(t.getValue())) continue;
                doc.setCharacterAttributes(t.getStartIndex(), t.getValue().length(), attr, true);
                continue;
            }
            if (t.getPropertiestype() != PropertiesType.COMMENT || t.getValue() == null || "".equals(t.getValue())) continue;
            doc.setCharacterAttributes(t.getStartIndex(), t.getValue().length(), comment, true);
        }
    }

    private void invokeSetHighlight() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor.this.setHighlight();
            }
        });
    }
}

