/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import ikdnet.diload.utils.tools.editor.Editor;
import ikdnet.diload.utils.tools.editor.JarFileResource;
import ikdnet.diload.utils.tools.editor.JarResources;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarReader {
    public static JarResources read(File f) throws IOException {
        JarInputStream jarInStream = new JarInputStream(new BufferedInputStream(new FileInputStream(f)));
        JarResources jr = new JarResources();
        HashMap<String, JarFileResource> m = new HashMap<String, JarFileResource>();
        try {
            JarEntry entry;
            Manifest manifest = jarInStream.getManifest();
            jr.setManifest(manifest);
            while ((entry = jarInStream.getNextJarEntry()) != null) {
                if (entry.isDirectory()) {
                    JarFileResource fr = new JarFileResource();
                    fr.setJarentry(entry);
                    fr.setIsdirectory(true);
                    m.put(entry.getName(), fr);
                } else {
                    int iRead;
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    while ((iRead = jarInStream.read()) >= 0) {
                        outStream.write(iRead);
                    }
                    outStream.flush();
                    outStream.close();
                    JarFileResource fr = new JarFileResource();
                    if (!entry.getName().equals(Editor.FILE_NAME)) {
                        fr.setJarentry(entry);
                        fr.setIsdirectory(false);
                        fr.setData(outStream.toByteArray());
                        m.put(entry.getName(), fr);
                    }
                }
                jarInStream.closeEntry();
            }
        }
        finally {
            if (jarInStream != null) {
                jarInStream.close();
            }
        }
        jr.setFileresources(m);
        return jr;
    }
}

