/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import ikdnet.diload.utils.tools.editor.PropertiesType;
import ikdnet.diload.utils.tools.editor.StringToken;
import java.util.ArrayList;
import java.util.List;

public class PropertiesTokenReader {
    public static List<StringToken> read(String text) {
        text = text.replace("\r\n", "\n");
        return PropertiesTokenReader.getToken(PropertiesTokenReader.splitLineFeed(text));
    }

    private static List<ReturnToken> splitLineFeed(String text) {
        char[] buf = text.toCharArray();
        ArrayList<ReturnToken> rts = new ArrayList<ReturnToken>();
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == '\n') {
                if (sb.length() > 0) {
                    PropertiesTokenReader propertiesTokenReader = new PropertiesTokenReader();
                    propertiesTokenReader.getClass();
                    rts.add(propertiesTokenReader.new ReturnToken(index, sb.toString().length(), sb.toString()));
                    sb.delete(0, sb.length());
                }
                index = i + 1;
            } else {
                sb.append(buf[i]);
                if (i == buf.length - 1) {
                    PropertiesTokenReader propertiesTokenReader = new PropertiesTokenReader();
                    propertiesTokenReader.getClass();
                    rts.add(propertiesTokenReader.new ReturnToken(index, sb.toString().length(), sb.toString()));
                    index = i;
                }
            }
            ++i;
        }
        return rts;
    }

    private static List<StringToken> getToken(List<ReturnToken> list) {
        ArrayList<StringToken> l = new ArrayList<StringToken>();
        int i = 0;
        while (i < list.size()) {
            String key;
            ReturnToken rt = list.get(i);
            String text = rt.getToken();
            int index = text.indexOf("=");
            if (index > 0) {
                if (text.trim().startsWith("#")) {
                    StringToken t = new StringToken();
                    t.setStartIndex(rt.startindex);
                    t.setLength(text.length());
                    t.setValue(text);
                    t.setPropertiestype(PropertiesType.COMMENT);
                    l.add(t);
                } else {
                    key = text.substring(0, index);
                    String value = text.substring(index + 1);
                    StringToken t = new StringToken();
                    t.setStartIndex(rt.startindex);
                    t.setLength(key.length());
                    t.setValue(key);
                    t.setPropertiestype(PropertiesType.KEY);
                    l.add(t);
                    t = new StringToken();
                    t.setStartIndex(rt.startindex + key.length() + 1);
                    t.setLength(value.length());
                    t.setValue(value);
                    t.setPropertiestype(PropertiesType.VALUE);
                    l.add(t);
                }
            } else {
                key = text;
                StringToken t = new StringToken();
                t.setStartIndex(rt.startindex);
                t.setLength(key.length());
                t.setValue(key);
                if (key.trim().startsWith("#")) {
                    t.setPropertiestype(PropertiesType.COMMENT);
                } else {
                    t.setPropertiestype(PropertiesType.KEY);
                }
                l.add(t);
            }
            ++i;
        }
        return l;
    }

    class ReturnToken {
        private int startindex;
        private int length;
        private String token;

        ReturnToken(int startindex, int length, String token) {
            this.startindex = startindex;
            this.length = length;
            this.token = token;
        }

        public int getStartindex() {
            return this.startindex;
        }

        public void setStartindex(int startindex) {
            this.startindex = startindex;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }
}

