//--------------------------------------------------------------------------------
//	Փ˕wb_[
//@KF_Body.h
//	Author : Xu Wenjie
//	Date   : 2016-07-25
//--------------------------------------------------------------------------------
//  Update : 
//	
//--------------------------------------------------------------------------------
#ifndef _KF_BODY_H_
#define _KF_BODY_H_

//--------------------------------------------------------------------------------
//  CN[ht@C
//--------------------------------------------------------------------------------
#include <Windows.h>
#include <stdio.h>
#include <d3dx9.h>
#define DIRECTINPUT_VERSION (0x0800)
#include <dinput.h>

#pragma comment (lib,"d3d9.lib")
#pragma comment (lib,"d3dx9.lib")
#pragma comment (lib,"dxguid.lib")
//#include "main.h"
#include "KF_Precision.h"
#include "KF_Math.h"

//--------------------------------------------------------------------------------
//  萔`
//--------------------------------------------------------------------------------
//#define DAMPING_MAX ((float)0.0)//őR
//#define DAMPING_MIN ((float)0.995)//ŏR

//--------------------------------------------------------------------------------
//  NX`
//--------------------------------------------------------------------------------
//class CBody
//{
//public:
//	typedef struct {
//		D3DXVECTOR3 vVertexPos;
//		D3DXVECTOR3 vLengthToCenter;
//		D3DXVECTOR3 vDirection;
//	}KF_VERTEX;
//
//	CBody();//RXgN^
//
//	//z֐
//	virtual ~CBody();//fXgN^
//	virtual void Init(void);
//	virtual void Update(void);
//	virtual void Uninit(void);
//
//	//o[ϐ
//	void SetPosCenter(D3DXVECTOR3 vSetPosCenter);
//	D3DXVECTOR3 GetPosCenter(void);
//	void SetGravityCenter(D3DXVECTOR3 vGravityCenter);
//	D3DXVECTOR3 GetGravityCenter(void);
//	void SetVelocity(D3DXVECTOR3 vSetVelocity);
//	D3DXVECTOR3 GetVelocity(void);
//	void SetAcceleration(D3DXVECTOR3 vSetAcceleration);
//	D3DXVECTOR3 GetAcceleration(void);
//	void SetMass(float fMass);
//	float GetMass(void);
//	void SetGravity(D3DXVECTOR3 vSetGravity);
//	void SetDrag(float fSetK1, float fSetK2);
//	void ClearAccumulator(void);//t[p͂NA
//	void AddForce(D3DXVECTOR3 vForce);//p͂𑝉
//
//	//p͌vZ
//	void UpdateGravity(void);
//	void UpdateDrag(void);
//private:
//	D3DXVECTOR3 m_vPositionCenter;//Sʒu
//	D3DXVECTOR3 m_vGravityCenter;//dSʒu
//	D3DXVECTOR3 m_vVelocity;//x
//	D3DXVECTOR3 m_vAcceleration;//q̉x
//	D3DXVECTOR3 m_vGravity;//d
//	D3DXVECTOR3 m_vForceAccum;//킹p
//	float m_fInverseMass;//ʂ̋t
//	float m_fK1;//R͌W(x)
//	float m_fK2;//R͌W(x)
//};

class CBody
{
public:
	CBody();//RXgN^
	~CBody();//fXgN^
	void Init(void);
	void Update(void);
	void Uninit(void);

	//o[ϐ
	void SetPosCenter(D3DXVECTOR3 vSetPosCenter);
	D3DXVECTOR3 GetPosCenter(void);
	void SetGravityCenter(D3DXVECTOR3 vGravityCenter);
	D3DXVECTOR3 GetGravityCenter(void);
	void SetVelocity(D3DXVECTOR3 vSetVelocity);
	D3DXVECTOR3 GetVelocity(void);
	void SetMovement(D3DXVECTOR3 vSetMovement);
	D3DXVECTOR3 GetMovement(void);
	void SetAcceleration(D3DXVECTOR3 vSetAcceleration);
	D3DXVECTOR3 GetAcceleration(void);
	void SetMass(float fMass);
	float GetMass(void);
	void SetInverseMass(float fInverseMass);
	float GetInverseMass(void);
	void SetGravity(D3DXVECTOR3 vSetGravity);
	void SetDamping(float fSetDamping);
	void SetRotation(float fSetRotation);
	float GetRotation(void);
	//void SetDrag(float fSetK1, float fSetK2);
	void ClearAccumulator(void);//t[p͂NA
	void AddForce(D3DXVECTOR3 vForce);//p͂𑝉

	//p͌vZ
	void UpdateGravity(void);
	//void UpdateDrag(void);
private:
	D3DXVECTOR3 m_vPositionCenter;//Sʒu
	D3DXVECTOR3 m_vGravityCenter;//dSʒu
	D3DXVECTOR3 m_vVelocity;//x
	D3DXVECTOR3 m_vMovement;//1franëړ
	D3DXVECTOR3 m_vAcceleration;//q̉x
	D3DXVECTOR3 m_vGravity;//d
	D3DXVECTOR3 m_vForceAccum;//킹p
	float m_fInverseMass;//ʂ̋t
	float m_fRotation;
	float m_fDamping;
	//float m_fK1;//R͌W(x)
	//float m_fK2;//R͌W(x)
};

class CBodyCicle
{
public:
	CBodyCicle();//RXgN^
	~CBodyCicle();//fXgN^

	void Init(void);
	void Update(void);
	void Uninit(void);

	void SetRadius(float fSetRadius);
	float GetRadius(void);

	CBody cBody;
private:
	float m_fRadius;
};

class CBodyBox
{
public:
	CBodyBox();//RXgN^
	~CBodyBox();//fXgN^

	void Init(void);
	void Update(void);
	void Uninit(void);

	void SetHalfSize(D3DXVECTOR2 vSetHalfSize);
	D3DXVECTOR2 GetHalfSize(void);
	D3DXVECTOR3 GetVertex(int nNumVertex);
	D3DXVECTOR3 GetSide(int nNumSide);
	void SetAngle(float fAngle);
	float GetAngle(void);
	float GetLength(void);

	CBody cBody;
private:
	D3DXVECTOR2 m_vHalfSize;//
	D3DXVECTOR3 m_aVertex[4];
	D3DXVECTOR3 m_aSide[4];
	float m_fAngle;
	float m_fLength;

	void InitVertex(void);
	void UpdateVertex(void);
	void UpdateSide(void);
};

//class CBodyFrame
//{
//public:
//	CBodyFrame();//RXgN^
//	~CBodyFrame();//fXgN^
//
//	void Init(void);
//	void Update(void);
//	void Uninit(void);
//	void SetDistance(float fSetDistance);
//	float GetDistance(void);
//
//	CBodyBox cBodyBox;
//	FRAME m_frame;
//private:
//
//	float m_fDistanceToPosCenter;
//};

//class CBodyCicle : public CBody
//{
//public:
//	CBodyCicle();//RXgN^
//	~CBodyCicle();//fXgN^
//
//	void Init(void);
//	void Update(void);
//	void Uninit(void);
//
//	void SetRadius(float fSetRadius);
//	float GetRadius(void);
//private:
//	float m_fRadius;
//};
//
//class CBodyBox : public CBody
//{
//public:
//	CBodyBox();//RXgN^
//	~CBodyBox();//fXgN^
//
//	void Init(void);
//	void Update(void);
//	void Uninit(void);
//
//	void SetHalfSize(D3DXVECTOR2 vSetHalfSize);
//	D3DXVECTOR2 GetHalfSize(void);
//	void SetRotation(float fSetRotation);
//	float GetRotation(void);
//private:
//	D3DXVECTOR2 m_vHalfSize;//
//	float m_fRotation;
//	KF_VERTEX m_aVertex[4];
//
//	void InitVertex(void);
//	void UpdateVertex(void);
//};

//class CBodyTriangle : public CBody
//{
//public:
//	CBodyTriangle();//RXgN^
//	~CBodyTriangle();//fXgN^
//
//	void Init(void);
//	void Update(void);
//	void Uninit(void);
//
//	void SetHalfSize(D3DXVECTOR2 vSetHalfSize);
//
//private:
//	D3DXVECTOR2 vHalfSize;//
//	float fAngle;
//	KF_VERTEX aVertex[3];
//};

//--------------------------------------------------------------------------------
//  vg^Cv錾
//--------------------------------------------------------------------------------
#endif