/***************************************************************/
//
//
//		DirectX	[fade.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/08
/*---------------------------------------------------------------
Update : 2016/07/09
			tF[hCtF[hAEg̏̊

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "fade.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define FADE_TEXTURENAME "data/TEXTURE/fade000.png"	//eNX`l[
//#define FADE_TEXTURENAME "data/TEXTURE/screen_amx50100.jpg"	//eNX`l[

#define FADE_RATE(s) ( 1.0f /(60 * s) )				//tF[h[g
#define FADE_SECONDS ( 0.8f )						//tF[h:P(b/s)

#define FADE_POS_X ( 0 )							//|S̕\ʒuX
#define FADE_POS_Y ( 0 )							//|S̕\ʒuY
#define FADE_WIDTH (SCREEN_WIDTH)					//|S̕
#define FADE_HEIGHT (SCREEN_HEIGHT)					//|S̍

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexFade(LPDIRECT3DDEVICE9 pDevice);	//_̍쐬

void SetColorFade ( VERTEX_2D *pVtx );				//̕ύX

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureFade = nullptr;		//eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferFade = nullptr;	//_obt@C^[tF[Xւ̃|C^
													
D3DXCOLOR g_colorFade;								//tF[hF
FADE g_fade;
SCENE g_sceneNext = SCENE_TITLE;

// tF[h̏
void InitFade( void )
{


	LPDIRECT3DDEVICE9 g_pPD3DDevice=nullptr;		//foCX󂯎p֐
	g_pPD3DDevice = GetDevice( );

	MakeVertexFade(g_pPD3DDevice);

	// 
	g_colorFade = D3DXCOLOR( 0.0f, 0.0f, 0.0f, 1.0f );
	//g_colorFade = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f );
	g_fade = FADE_IN ;
	
	// eNX`̓ǂݍ
	HRESULT herror = D3DXCreateTextureFromFile(g_pPD3DDevice,FADE_TEXTURENAME,&g_pTextureFade);	//FAILED}Nł̃G[`FbNKv(g_pTextureFade)

	if(FAILED( herror ))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}

}

// tF[h̏I
void UninitFade( void ){

	//eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureFade)

	//_obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferFade)


}

// tF[h̍XV
void UpdateFade( void )
{

	VERTEX_2D *pVtx;									//zAhX


	if( g_fade == FADE_NONE ){
		return;
	}
	
	// tF[hC
	if( g_fade == FADE_IN ){
		
		g_colorFade.a -= FADE_RATE( FADE_SECONDS );
	
		if( g_colorFade.a < 0.0f ){

			g_colorFade.a = 0.0f;
			g_fade = FADE_NONE;

		}
	}

	// tF[hAEg
	else if( g_fade == FADE_OUT ){
	
  		g_colorFade.a += FADE_RATE( FADE_SECONDS );

		if( g_colorFade.a > 1.0f ){

			g_colorFade.a = 1.0f;
			g_fade = FADE_IN;
			//SetMode( g_modeNext );
			ChangeScene( g_sceneNext );

		}
	}

	//obt@bNzAhX擾
	g_pVtxBufferFade -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN


	// _J[̐ݒ
	SetColorFade( pVtx );

	//obt@̃AbN
	g_pVtxBufferFade->Unlock();

}

// tF[h̕`
void DrawFade( void )
{

	LPDIRECT3DDEVICE9 g_pPD3DDevice=nullptr;		//foCX󂯎p֐


	//foCX̎󂯎菈
	g_pPD3DDevice=GetDevice( );

	//Xg[
	g_pPD3DDevice->SetStreamSource(0,				//MS
	g_pVtxBufferFade,								//ǂ̒_obt@\ƌԂ...
	0,												//f[^̃ItZbg
	sizeof(VERTEX_2D));								//XgChl(oCg)

	//_tH[}bg̐ݒ
	g_pPD3DDevice->SetFVF(FVF_VERTEX_2D);

	//eNX`̐ݒ
	g_pPD3DDevice->SetTexture(0,g_pTextureFade);		//_UVf[^Zbg
	
	//|S̕`
	g_pPD3DDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,NUM_FADE);


}

// tF[h̐FύX֐
void SetColorFade ( VERTEX_2D *pVtx )
{

	//static int i;

	pVtx[0].color=D3DXCOLOR( g_colorFade.r, g_colorFade.g, g_colorFade.b, g_colorFade.a);
	pVtx[1].color=D3DXCOLOR( g_colorFade.r, g_colorFade.g, g_colorFade.b, g_colorFade.a);
	pVtx[2].color=D3DXCOLOR( g_colorFade.r, g_colorFade.g, g_colorFade.b, g_colorFade.a);
	pVtx[3].color=D3DXCOLOR( g_colorFade.r, g_colorFade.g, g_colorFade.b, g_colorFade.a);

	/*
	pVtx[0].color=D3DCOLOR(255-i,255,255, g_colorFade.a);
	pVtx[1].color=D3DCOLOR_RGBA(255,255-i,255, g_colorFade.a);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255-i, g_colorFade.a);
	pVtx[3].color=D3DCOLOR_RGBA(255-i,255-i,255-i, g_colorFade.a);
	*/

	//i--;

}

// tF[h̏Ԑݒ
void SetFade( FADE fade, SCENE sceneNext )
{
	g_fade = fade;
	g_sceneNext = sceneNext;
}

// tF[h̐FԎ擾
FADE GetFade( void )
{
	return g_fade;
}

// _̍쐬
HRESULT MakeVertexFade( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,				//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferFade,							//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	//obt@bNzAhX擾
	g_pVtxBufferFade -> Lock(0,0,(void**)&pVtx,0);	//GPUVRAMւ̑bN


	//_W̐ݒ

	pVtx[0].pos=D3DXVECTOR3( FADE_POS_X, FADE_POS_Y, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( FADE_WIDTH, FADE_POS_Y, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( FADE_POS_X, FADE_HEIGHT,0.0f);
	pVtx[3].pos=D3DXVECTOR3( FADE_WIDTH, FADE_HEIGHT,0.0f);

	/*
	//Q{
	pVtx[0].pos=D3DXVECTOR3( Fade_POS_X*2, Fade_POS_Y*2, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( Fade_WIDTH*2, Fade_POS_Y*2, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( Fade_POS_X*2, Fade_HEIGHT*2,0.0f);
	pVtx[3].pos=D3DXVECTOR3( Fade_WIDTH*2, Fade_HEIGHT*2,0.0f);
	*/

	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);

	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );

	//Zp`
	/*
	pVtx[0].pos=D3DXVECTOR3(100.0f,100.0f,0.0f);
	pVtx[1].pos=D3DXVECTOR3(300.0f,50.0f,0.0f);
	pVtx[2].pos=D3DXVECTOR3(100.0f,300.0f,0.0f);
	pVtx[3].pos=D3DXVECTOR3(500.0f,100.0f,0.0f);
	pVtx[4].pos=D3DXVECTOR3(300.0f,350.0f,0.0f);
	pVtx[5].pos=D3DXVECTOR3(500.0f,300.0f,0.0f);


	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;
	pVtx[4].rhw=1.0f;
	pVtx[5].rhw=1.0f;


	pVtx[0].color=D3DCOLOR_RGBA(255,0,0,255);
	pVtx[1].color=D3DCOLOR_RGBA(0,255,0,255);
	pVtx[2].color=D3DCOLOR_RGBA(0,0,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,0,0,255);
	pVtx[4].color=D3DCOLOR_RGBA(0,255,0,255);
	pVtx[5].color=D3DCOLOR_RGBA(0,0,255,255);
	*/

	//obt@̃AbN
	g_pVtxBufferFade->Unlock();

	return S_OK;

}
