/***************************************************************/
//
//
//		DirectX	[game.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/08
/*---------------------------------------------------------------
Update : 2016/06/16

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"

#include "game_background.h"
#include "frame.h"
#include "player.h"
#include "enemy.h"
#include "timer_logo.h"
//#include "timer.h"
#include "score.h"
#include "score_logo.h"
#include "goal.h"
#include "particle.h"
#include "explosion.h"
#include "sound.h"
#include "stage.h"
#include "stage_effect.h"
#include "emitter.h"
#include "timer.h"
#include "locus.h"

#include "KF_BodyContact.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define NUM_VERTEX (4)

#define GAME_BGM (1)

#define GAME_TEXTURENAME "data/TEXTURE/bg005.jpg"

#define GAME_POS_X (0)						//wi̕\ʒuX
#define GAME_POS_Y (0)						//wi̕\ʒuY
#define GAME_WIDTH (SCREEN_WIDTH)			//wi̕
#define GAME_HEIGHT (SCREEN_HEIGHT)			//wi̍

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
void InitTexGame( void );					//Q[peNX`̏ 
void UninitTexGame( void );					//Q[peNX`̏I
void UpdateTexGame( void );					//Q[peNX`̍XV
void DrawTexGame( void );					//Q[peNX`̕`
HRESULT MakeVertexGame( LPDIRECT3DDEVICE9 pDevice );
											//Q[peNX`̒_
/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureGame=nullptr;	//eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferGame=nullptr;
											//_obt@C^[tF[Xւ̃|C^

EMITTER g_emitter;


// 
void InitGame( void )
{

	// e֐̏
	//InitGameBackground( );
	InitStage( );
	InitStageEffect( );
	InitFrame( );
	InitPlayer( );
	InitExplosion();
	InitEnemy( );
	InitBodyContact( );
	InitTimerLogo( );
	InitScoreLogo( );
	InitScore( );
	InitTimer( );  
	InitGoal();
	InitParticle( );
	InitLocus( );

	PlaySound( GAME_BGM , true );

	g_emitter.nLife = 0;
	g_emitter.Pos.x = 400;
	g_emitter.Pos.y = 300;
	g_emitter.Speed.x = 10;
	g_emitter.Speed.y = 10;
	g_emitter.Acceleration.x = 0.95f;
	g_emitter.Acceleration.y = 0.95f;
	g_emitter.nNum = 30;				// 

}

// I
void UninitGame(void)
{

	// e֐̉
	//UninitGameBackground( );
	UninitStage( );
	UninitStageEffect( );
	UninitFrame( );
	UninitPlayer( );
	UninitExplosion();
	UninitEnemy( );
	UninitBodyContact( );
	UninitTimerLogo( );
	UninitScoreLogo( );
	UninitScore( );
	UninitTimer( );  
	UninitGoal();
	UninitParticle( );
	UninitLocus( );

	StopSound( GAME_BGM );

}

// XV
void UpdateGame( void )
{

	// e֐̍XV
	//UpdateGameBackground( );
	UpdateStage( );
	UpdateStageEffect( );
	UpdateFrame( );
	UpdatePlayer( );
	UpdateExplosion();
	UpdateEnemy( );
	UpdateBodyContact( );
	UpdateTimerLogo( );
	UpdateScoreLogo( );
	UpdateScore( );
	UpdateTimer( );  
	UpdateLocus( );
	UpdateGoal();


	// effectXV
	if (g_emitter.nTime > 0)
	{
		g_emitter.nTime--;
	}
	
	if (g_emitter.nTime != 0)
	{
		EmitParticle(&g_emitter, GetParticle());
	}
	

	UpdateParticle( );


	// {[̕ύX
	ControlVolume( GAME_BGM );

}

// `揈
void DrawGame ( void )
{

	// e֐̕`
	//DrawGameBackground( );
	DrawStage( );
	DrawLocus( );
	DrawPlayer( );
	DrawExplosion();
	DrawEnemy( );
	DrawStageEffect( );
	DrawFrame( );
	DrawTimerLogo( );
	DrawScoreLogo( );
	DrawScore( );
	DrawTimer( );  
	DrawGoal();

	DrawParticle( );

}

// wȉ
void InitTexGame( void )
{

	LPDIRECT3DDEVICE9 g_pPD3DDevice = nullptr;		//foCX󂯎p֐

	// foCX̎󂯎
	g_pPD3DDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexGame(g_pPD3DDevice);

	// eNX`̓ǂݍ
	if(FAILED(D3DXCreateTextureFromFile(g_pPD3DDevice,GAME_TEXTURENAME,&g_pTextureGame)))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}

}

// wȉI
void UninitTexGame( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureGame)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferGame)


}

// wi̍XV
void UpdateTexGame( void ){

	
}

// wi̕`
void DrawTexGame( void )
{

	LPDIRECT3DDEVICE9 g_pPD3DDevice=nullptr;			//foCX󂯎p֐


	// foCX̎󂯎菈
	g_pPD3DDevice=GetDevice( );

	// Xg[
	g_pPD3DDevice->SetStreamSource(0,					//MS
	g_pVtxBufferGame,									//ǂ̒_obt@\ƌԂ...
	0,													//f[^̃ItZbg
	sizeof(VERTEX_2D));									//XgChl(oCg)

	// _tH[}bg̐ݒ
	g_pPD3DDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	g_pPD3DDevice->SetTexture(0,g_pTextureGame);			//_UVf[^Zbg
	
	// |S̕`
	g_pPD3DDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,NUM_VERTEX);


}

// _̍쐬
HRESULT MakeVertexGame( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,				//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferGame,							//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	// obt@bNzAhX擾
	g_pVtxBufferGame -> Lock(0,0,(void**)&pVtx,0);			//GPUVRAMւ̑bN



	// _W̐ݒ

	pVtx[0].pos=D3DXVECTOR3( GAME_POS_X, GAME_POS_Y, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( GAME_WIDTH, GAME_POS_Y, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( GAME_POS_X, GAME_HEIGHT,0.0f);
	pVtx[3].pos=D3DXVECTOR3( GAME_WIDTH, GAME_HEIGHT,0.0f);

	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);

	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );


	// obt@̃AbN
	g_pVtxBufferGame->Unlock();

	return S_OK;

}

void SetEmitter(D3DXVECTOR3 vPos)
{
	g_emitter.nTime = 3;
	g_emitter.nLife = 10;
	g_emitter.Pos.x = vPos.x;
	g_emitter.Pos.y = vPos.y;
	g_emitter.Speed.x = 10;
	g_emitter.Speed.y = 10;
	g_emitter.Acceleration.x = 0.95f;
	g_emitter.Acceleration.y = 0.95f;
	g_emitter.nNum = 30;
}
