/***************************************************************/
//
//
//		DirectX	[gamepad.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/12
/*---------------------------------------------------------------
Update : 2016/07/12
			gamepad.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "input.h"
#include "gamepad.h"
#include "main.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`

---------------------------------------------------------------*/
#define	NUM_KEY_MAX			( 128 )	// L[̍ő吔
#define	LIMIT_COUNT_REPEAT	( 5 )	// s[gJEg~b^[
#define PAD_START_POINT		(32767)

/*---------------------------------------------------------------
	O[oϐ
---------------------------------------------------------------*/

LPDIRECTINPUTDEVICE8	g_pDevGamepad = NULL;			// ̓foCX(Q[pbh)ւ̃|C^
BYTE					g_dijsTrigger[NUM_KEY_MAX];		// Q[pbh̃gK[񃏁[N
BYTE					g_dijsRelease[NUM_KEY_MAX];		// Q[pbh̃[X񃏁[N
BYTE					g_dijsRepeat[NUM_KEY_MAX];		// Q[pbh̃s[g񃏁[N
int						g_dijsRepeatCnt[NUM_KEY_MAX];	// Q[pbh̃s[gJE^

DIJOYSTATE2				g_dijs;							// Q[pbh̏
bool					gamepadUseEnable = false;		// Q[pbhgp\Ȃtrue


// Q[pbh̏
HRESULT InitGamepad(HINSTANCE hInstance, HWND hWnd)
{
	// ͏̏
	if(FAILED(InitInput(hInstance, hWnd)))
	{
		//MessageBox(hWnd, "DirectInputIuWFNg˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// foCX̍쐬
	LPDIRECTINPUT8 g_pInput = GetInputDevice( );
	if(FAILED(g_pInput->CreateDevice(GUID_Joystick, &g_pDevGamepad, NULL)))
	{
		//MessageBox(hWnd, "Q[pbh˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// f[^tH[}bgݒ
	if(FAILED(g_pDevGamepad->SetDataFormat(&c_dfDIJoystick2)))
	{
		//MessageBox(hWnd, "Q[pbh̃f[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// [hݒitHAOEhr[hj
	if(FAILED(g_pDevGamepad->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE))))
	{
		//MessageBox(hWnd, "Q[pbh̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// Q[pbhւ̃ANZXl(͐Jn)
	if( FAILED( g_pDevGamepad ->Poll() ) )
	{
		g_pDevGamepad->Acquire();

	}

	// Q[pbhgp\ɐݒ
	gamepadUseEnable = true;

	return S_OK;
}

// Q[pbh̏I
void UninitGamepad(void)
{
	if(g_pDevGamepad != NULL)
	{// ̓foCX(Q[pbh)̊J
		// Q[pbhւ̃ANZXJ(͐I)
		g_pDevGamepad->Unacquire();

		g_pDevGamepad->Release();
		g_pDevGamepad = NULL;
	}

	// ͏̏I
	UninitInput();
}

// Q[pbh̍XV
void UpdateGamepad(void)
{

	DIJOYSTATE2 dijs;


	// Q[pbhgp\ǂf
	if( gamepadUseEnable ){

		// foCXf[^擾
		if(SUCCEEDED(g_pDevGamepad->GetDeviceState(sizeof(DIJOYSTATE2), &dijs )))
		{

			for(int nCnKey = 0; nCnKey < NUM_KEY_MAX; nCnKey++)
			{
			
				//L[gK[[X̍쐬
				g_dijsTrigger[nCnKey]=(g_dijs.rgbButtons[nCnKey] ^ dijs.rgbButtons[nCnKey]) & dijs.rgbButtons[nCnKey];

				g_dijsRelease[nCnKey]=(g_dijs.rgbButtons[nCnKey] ^ dijs.rgbButtons[nCnKey]) & g_dijs.rgbButtons[nCnKey];

				//L[s[g̐
				if( dijs.rgbButtons[nCnKey] & 0x80 ){			//sNꍇ, if( dijs.rgbButtons[nCnKey] & 0x80 )
					if(g_dijsRepeatCnt[nCnKey] < LIMIT_COUNT_REPEAT){
						g_dijsRepeatCnt[nCnKey]++;
						if( g_dijsRepeatCnt[nCnKey]==1){
						//if( g_dijsRepeatCnt[nCnKey]==1 || g_dijsRepeatCnt[nCnKey]>=LIMIT_COUNT_REPEAT ){

							g_dijsRepeat[nCnKey]=dijs.rgbButtons[nCnKey];
					
						}
						else{
						
							g_dijsRepeat[nCnKey] = 0 ;

						}
					}
				}
				else{
			
					g_dijsRepeat[nCnKey]=0;
					g_dijsRepeatCnt[nCnKey]=0;

				}

				// L[vXۑ
				//g_dijs.rgbButtons[nCnKey] = dijs.rgbButtons[nCnKey];

			}

			// L[vXۑ
			g_dijs = dijs;

		}
		else{
			// Q[pbhւ̃ANZX擾
			g_pDevGamepad->Acquire();
		}
	}
}

// Q[pbh̃vXԂ擾
bool GetGamepadPress(int nKey)
{
	//return (g_dijs[nKey] & 0x80) ? true: false;
	return (g_dijs.rgbButtons[nKey] & 0x80) ? true: false;
}

// Q[pbh̃gK[Ԃ擾
bool GetGamepadTrigger(int nKey)
{
	return (g_dijsTrigger[nKey] & 0x80) ? true: false;
}

// Q[pbh̃s[gԂ擾
bool GetGamepadRepeat(int nKey)
{
	return (g_dijsRepeat[nKey] & 0x80) ? true: false;
}

// Q[pbh̃|XԂ擾
bool GetGamepadRelease(int nKey)
{
	return (g_dijsRelease[nKey] & 0x80) ? true: false;
}

// Q[pbh{^̎擾
bool GetGamepadUp( void )
{
	return ( g_dijs.lY < PAD_START_POINT ) ? true: false; 
}

// Q[pbh{^̎擾
bool GetGamepadDown( void )
{
	return ( g_dijs.lY > PAD_START_POINT ) ? true: false; 
}

// Q[pbh{^̎擾
bool GetGamepadLeft( void )
{
	return ( g_dijs.lX < PAD_START_POINT ) ? true: false; 
}

// Q[pbh{^̎擾
bool GetGamepadRight( void )
{
	return ( g_dijs.lX > PAD_START_POINT ) ? true: false; 
}

