//--------------------------------------------------------------------------------
//
//@EChE\vO
//	Author : Xu Wenjie
//	Date   : 2016-04-26
//--------------------------------------------------------------------------------
//  Update : 
//	
//--------------------------------------------------------------------------------
#include "goal.h"

//--------------------------------------------------------------------------------
//  萔`
//--------------------------------------------------------------------------------
#define NUM_POLYGON ( 2 )
#define NUM_VERTEX  ( 4 )

#define GOAL_WIDTH (60.0f)//|S̕
#define GOAL_HEIGHT (60.0f)//|S̍
#define GOAL_TEXTURENAME_RED "data/TEXTURE/circle_r.png"//t@C
#define GOAL_TEXTURENAME_GREEN "data/TEXTURE/circle_g.png"//t@C
#define GOAL_TEXTURENAME_BLUE "data/TEXTURE/circle_b.png"//t@C
#define GOAL_TEXTURENAME_YELLOW "data/TEXTURE/circle_y.png"//t@C
#define GOAL_POS_LEFT (D3DXVECTOR3(69.0f, 325.0f, 0.0f))
#define GOAL_POS_TOP (D3DXVECTOR3(640.0f, 106.0f, 0.0f))
#define GOAL_POS_RIGHT (D3DXVECTOR3(1219.0f, 325.0f, 0.0f))
#define GOAL_POS_BOTTOM (D3DXVECTOR3(640.0f, 555.0f, 0.0f))

//--------------------------------------------------------------------------------
//  \̒`
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//  vg^Cv錾
//--------------------------------------------------------------------------------
HRESULT MakeVerTexGoal(LPDIRECT3DDEVICE9 pDevice);

//--------------------------------------------------------------------------------
//  O[oϐ
//--------------------------------------------------------------------------------
LPDIRECT3DTEXTURE9 g_pTextureGoal[4];//textureC^[tF[X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferGoal = NULL;//_obt@ǗC^[tF[X|C^
D3DXVECTOR3 g_aGoalPos[NUM_GOAL];

//--------------------------------------------------------------------------------
//  
//--------------------------------------------------------------------------------
void InitGoal(void)
{
	LPDIRECT3DDEVICE9 pDevice = GetDevice();//foCX擾

	int nCnt = 0;
	for (nCnt = 0;nCnt < TYPE_MAX;nCnt++)
	{
		g_pTextureGoal[nCnt] = NULL;
	}

	g_aGoalPos[0] = GOAL_POS_LEFT;//y
	g_aGoalPos[1] = GOAL_POS_TOP;//r
	g_aGoalPos[2] = GOAL_POS_RIGHT;//g
	g_aGoalPos[3] = GOAL_POS_BOTTOM;//b

	if (FAILED(MakeVerTexGoal(pDevice)))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "MakeVerTexPlayer ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}

	//n[hfBXNTexture̓ǂݍ
	//G[`FbNK{
	if (FAILED(D3DXCreateTextureFromFile(pDevice,
		GOAL_TEXTURENAME_YELLOW,
		&g_pTextureGoal[0])))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "D3DXCreateTextureFromFile ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}
	if (FAILED(D3DXCreateTextureFromFile(pDevice,
		GOAL_TEXTURENAME_RED,
		&g_pTextureGoal[1])))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "D3DXCreateTextureFromFile ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}
	if (FAILED(D3DXCreateTextureFromFile(pDevice,
		GOAL_TEXTURENAME_GREEN,
		&g_pTextureGoal[2])))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "D3DXCreateTextureFromFile ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}
	if (FAILED(D3DXCreateTextureFromFile(pDevice,
		GOAL_TEXTURENAME_BLUE,
		&g_pTextureGoal[3])))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "D3DXCreateTextureFromFile ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}
}

//--------------------------------------------------------------------------------
//  I
//--------------------------------------------------------------------------------
void UninitGoal(void)
{
	if (g_pVtxBufferGoal != NULL)
	{
		g_pVtxBufferGoal->Release();
		g_pVtxBufferGoal = NULL;
	}

	for (int nCnt = 0;nCnt < NUM_GOAL;nCnt++)
	{
		if (g_pTextureGoal[nCnt] != NULL)
		{
			g_pTextureGoal[nCnt]->Release();
			g_pTextureGoal[nCnt] = NULL;
		}
	}
}

//--------------------------------------------------------------------------------
//  XV
//--------------------------------------------------------------------------------
void UpdateGoal(void)
{
}

//--------------------------------------------------------------------------------
//  `揈
//--------------------------------------------------------------------------------
void DrawGoal(void)
{
	LPDIRECT3DDEVICE9 pDevice = GetDevice();//foCX擾

	pDevice->SetStreamSource(
		0,//Xg[ԍ
		g_pVtxBufferGoal,
		0,//ItZbgiJnʒuj
		sizeof(VERTEX_2D));//XgCh

						   //_tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	//Texture̐ݒ
	for (int nCnt = 0; nCnt < NUM_GOAL; nCnt++)
	{
		pDevice->SetTexture(0, g_pTextureGoal[nCnt]);

		//v~eBu`
		pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,
			nCnt * 4,//ItZbgi_j
			NUM_POLYGON);
	}
}

//--------------------------------------------------------------------------------
//  _̍쐬
//--------------------------------------------------------------------------------
HRESULT MakeVerTexGoal(LPDIRECT3DDEVICE9 pDevice)
{
	if (FAILED(pDevice->CreateVertexBuffer(
		sizeof(VERTEX_2D) * NUM_VERTEX * NUM_GOAL,//쐬_obt@̃TCY
		D3DUSAGE_WRITEONLY,//_obt@̎gp@
		FVF_VERTEX_2D,//ȂĂv
		D3DPOOL_MANAGED,//Ǘ@(managedFfoCXɂC)
		&g_pVtxBufferGoal,//
		NULL//
	)))
	{
		return E_FAIL;
	}

	//zAhX擾邽߂̃|C^
	VERTEX_2D *pVtx;
	int nCnt = 0;
	float fLength = 0.0f;
	float fRotation = 0.0f;
	D3DXVECTOR3 vGoalPos;

	//_obt@bNāAzAhX擾
	g_pVtxBufferGoal->Lock(
		0,//͈
		0,//͈
		(void**)&pVtx,//AhXꂽ̃AhX
		0);

	for (nCnt = 0; nCnt < NUM_GOAL; nCnt++)
	{
		//_W̐ݒi2DWAEj
		pVtx[nCnt * 4 + 0].pos = D3DXVECTOR3(g_aGoalPos[nCnt].x - GOAL_WIDTH * 0.5f, g_aGoalPos[nCnt].y - GOAL_HEIGHT * 0.5f, 0.0f);
		pVtx[nCnt * 4 + 1].pos = D3DXVECTOR3(g_aGoalPos[nCnt].x + GOAL_WIDTH * 0.5f, g_aGoalPos[nCnt].y - GOAL_HEIGHT * 0.5f, 0.0f);
		pVtx[nCnt * 4 + 2].pos = D3DXVECTOR3(g_aGoalPos[nCnt].x - GOAL_WIDTH * 0.5f, g_aGoalPos[nCnt].y + GOAL_HEIGHT * 0.5f, 0.0f);
		pVtx[nCnt * 4 + 3].pos = D3DXVECTOR3(g_aGoalPos[nCnt].x + GOAL_WIDTH * 0.5f, g_aGoalPos[nCnt].y + GOAL_HEIGHT * 0.5f, 0.0f);

		//rhw̐ݒ(K1.0f)
		pVtx[nCnt * 4 + 0].rhw = 1.0f;
		pVtx[nCnt * 4 + 1].rhw = 1.0f;
		pVtx[nCnt * 4 + 2].rhw = 1.0f;
		pVtx[nCnt * 4 + 3].rhw = 1.0f;

		//_J[̐ݒ(0`255̐l)
		pVtx[nCnt * 4 + 0].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
		pVtx[nCnt * 4 + 1].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
		pVtx[nCnt * 4 + 2].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
		pVtx[nCnt * 4 + 3].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);

		//texture_
		pVtx[nCnt * 4 + 0].tex = D3DXVECTOR2(0.0f, 0.0f);
		pVtx[nCnt * 4 + 1].tex = D3DXVECTOR2(1.0f, 0.0f);
		pVtx[nCnt * 4 + 2].tex = D3DXVECTOR2(0.0f, 1.0f);
		pVtx[nCnt * 4 + 3].tex = D3DXVECTOR2(1.0f, 1.0f);
	}

	//zAhX
	g_pVtxBufferGoal->Unlock();

	return S_OK;
}

//--------------------------------------------------------------------------------
//  GAhX擾
//--------------------------------------------------------------------------------
D3DXVECTOR3 GetGoal(int nType)
{
	return g_aGoalPos[nType];
}