//=============================================================================
//
// ͏ [input.cpp]
// Author : AKIRA TANAKA
//
//=============================================================================
#include "input.h"
#include "main.h"
//*****************************************************************************
// }N`
//*****************************************************************************
#define	NUM_KEY_MAX			(256)	// L[̍ő吔
#define	LIMIT_COUNT_REPEAT	( 5 )	// s[gJEg~b^[

//*****************************************************************************
// vg^Cv錾
//*****************************************************************************
//*****************************************************************************
// O[oϐ
//*****************************************************************************
LPDIRECTINPUT8			g_pInput = NULL;					// DirectInputIuWFNgւ̃|C^
LPDIRECTINPUTDEVICE8	g_pDevKeyboard = NULL;				// ̓foCX(L[{[h)ւ̃|C^
BYTE					g_aKeyState[NUM_KEY_MAX];			// L[{[h̓͏񃏁[N
BYTE					g_aKeyStateTrigger[NUM_KEY_MAX];	// L[{[h̃gK[񃏁[N
BYTE					g_aKeyStateRelease[NUM_KEY_MAX];	// L[{[h̃[X񃏁[N
BYTE					g_aKeyStateRepeat[NUM_KEY_MAX];		// L[{[h̃s[g񃏁[N
int						g_aKeyStateRepeatCnt[NUM_KEY_MAX];	// L[{[h̃s[gJE^

//=============================================================================
// ͏̏
//=============================================================================
HRESULT InitInput(HINSTANCE hInstance, HWND hWnd)
{
	if(g_pInput == NULL)
	{
		// DirectInputIuWFNg̍쐬
		if(FAILED(DirectInput8Create(hInstance, DIRECTINPUT_VERSION,
										IID_IDirectInput8, (void**)&g_pInput, NULL)))
		{
			return E_FAIL;
		}
	}

	return S_OK;
}

//=============================================================================
// ͏̏I
//=============================================================================
void UninitInput(void)
{
	if(g_pInput != NULL)
	{// DirectInputIuWFNg̊J
		g_pInput->Release();
		g_pInput = NULL;
	}
}

//=============================================================================
// ͏̍XV
//=============================================================================
void UpdateInput(void)
{
}

//=============================================================================
// L[{[h̏
//=============================================================================
HRESULT InitKeyboard(HINSTANCE hInstance, HWND hWnd)
{
	// ͏̏
	if(FAILED(InitInput(hInstance, hWnd)))
	{
		MessageBox(hWnd, "DirectInputIuWFNg˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// foCX̍쐬
	if(FAILED(g_pInput->CreateDevice(GUID_SysKeyboard, &g_pDevKeyboard, NULL)))
	{
		MessageBox(hWnd, "}EX˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// f[^tH[}bgݒ
	if(FAILED(g_pDevKeyboard->SetDataFormat(&c_dfDIKeyboard)))
	{
		MessageBox(hWnd, "L[{[h̃f[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// [hݒitHAOEhr[hj
	if(FAILED(g_pDevKeyboard->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE))))
	{
		MessageBox(hWnd, "L[{[h̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// L[{[hւ̃ANZXl(͐Jn)
	g_pDevKeyboard->Acquire();

	return S_OK;
}

//=============================================================================
// L[{[h̏I
//=============================================================================
void UninitKeyboard(void)
{
	if(g_pDevKeyboard != NULL)
	{// ̓foCX(L[{[h)̊J
		// L[{[hւ̃ANZXJ(͐I)
		g_pDevKeyboard->Unacquire();

		g_pDevKeyboard->Release();
		g_pDevKeyboard = NULL;
	}

	// ͏̏I
	UninitInput();
}

//=============================================================================
// L[{[h̍XV
//=============================================================================
void UpdateKeyboard(void)
{
	BYTE aKeyState[NUM_KEY_MAX];

	// foCXf[^擾
	if(SUCCEEDED(g_pDevKeyboard->GetDeviceState(sizeof(aKeyState), aKeyState)))
	{

		for(int nCnKey = 0; nCnKey < NUM_KEY_MAX; nCnKey++)
		{

			//L[gK[[X̍쐬
			g_aKeyStateTrigger[nCnKey]=(g_aKeyState[nCnKey] ^ aKeyState[nCnKey]) & aKeyState[nCnKey];

			g_aKeyStateRelease[nCnKey]=(g_aKeyState[nCnKey] ^ aKeyState[nCnKey]) & g_aKeyState[nCnKey];

			//L[s[g̐
			if( aKeyState[nCnKey] & 0x80 ){			//sNꍇ, if( aKeyState[nCnKey] & 0x80 )
				if(g_aKeyStateRepeatCnt[nCnKey] < LIMIT_COUNT_REPEAT){
					g_aKeyStateRepeatCnt[nCnKey]++;
					if( g_aKeyStateRepeatCnt[nCnKey]==1){
					//if( g_aKeyStateRepeatCnt[nCnKey]==1 || g_aKeyStateRepeatCnt[nCnKey]>=LIMIT_COUNT_REPEAT ){

						g_aKeyStateRepeat[nCnKey]=aKeyState[nCnKey];
					
					}
					else{
						
						g_aKeyStateRepeat[nCnKey] = 0 ;

					}
				}
			}
			else{
			
				g_aKeyStateRepeat[nCnKey]=0;
				g_aKeyStateRepeatCnt[nCnKey]=0;

			}

			// L[vXۑ
			g_aKeyState[nCnKey] = aKeyState[nCnKey];

		}

	}
	else
	{
		// L[{[hւ̃ANZX擾
		g_pDevKeyboard->Acquire();
	}
}

//=============================================================================
// L[{[h̃vXԂ擾
//=============================================================================
bool GetKeyboardPress(int nKey)
{
	return (g_aKeyState[nKey] & 0x80) ? true: false;
}

//=============================================================================
// L[{[h̃gK[Ԃ擾
//=============================================================================
bool GetKeyboardTrigger(int nKey)
{
	return (g_aKeyStateTrigger[nKey] & 0x80) ? true: false;
}

//=============================================================================
// L[{[h̃s[gԂ擾
//=============================================================================
bool GetKeyboardRepeat(int nKey)
{
	return (g_aKeyStateRepeat[nKey] & 0x80) ? true: false;
}

//=============================================================================
// L[{[h̃|XԂ擾
//=============================================================================
bool GetKeyboardRelease(int nKey)
{
	return (g_aKeyStateRelease[nKey] & 0x80) ? true: false;
}

// inputDevice̎擾
LPDIRECTINPUT8 GetInputDevice( void )
{

	return g_pInput;
}

