/***************************************************************/
//
//
//		DirectX	[locus.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/08
/*---------------------------------------------------------------
Update : 2016/0


/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "locus.h"

#include "enemy.h"
#include "game_equation.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define LOCUS_TEXTURENAME "data/TEXTURE/effect000.jpg"
//#define LOCUS_TEXTURENAME "data/TEXTURE/bullet000.jpg"


#define LOCUS_LIFE ( 100 )						// GtFNg̎

#define NUM_NUNBER ( 200 )

#define LOCUS_MAX (255*16)						// GtFNg̍ő吔
#define RELOAD_TIME (20)						// U:P(b/s)

#define LOCUS_RADIUS (30)						// wi̔a

// GtFNg(O)\
typedef struct{

	D3DXVECTOR2 center;							// SW
	float       radius;							// IuWFNga
	D3DXCOLOR   color;							// F
	float radiusValue;							// a̕ω
	float colorValue;							// F̕ω
	unsigned int life;							// 

}LOCUS;


/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexLocus(LPDIRECT3DDEVICE9 pDevice);
												// _̍쐬
void SetVertexLocus( VERTEX_2D *pVtx , const int arrayPos );
												// GtFNg̐ݒu
void SetColorLocus ( VERTEX_2D *pVtx , const int arrayPos );
												// F̐ݒ
/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureLocus=nullptr;	// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferLocus=nullptr;
											// _obt@C^[tF[Xւ̃|C^
LOCUS locuses[ LOCUS_MAX ] = {};			// GtFNg



// GtFNg̏
void InitLocus( void )
{

	LPDIRECT3DDEVICE9 g_pPD3DDevice=nullptr;	//foCX󂯎p֐

	// foCX̎󂯎
	g_pPD3DDevice = GetDevice( );

	// \̂̏
	for( int inc = 0; inc < LOCUS_MAX ; inc++ ){

		locuses[ inc ].radius = LOCUS_RADIUS;

		locuses[ inc ].color.a = 1.0f;
		locuses[ inc ].color.r = 1.0f;
		locuses[ inc ].color.g = 1.0f;
		locuses[ inc ].color.b = 1.0f;

		locuses[ inc ].life = 0;

	}

	// VERTEX_2D̐ݒ
	MakeVertexLocus( g_pPD3DDevice );

	// eNX`̓ǂݍ
	if(FAILED( D3DXCreateTextureFromFile( g_pPD3DDevice, LOCUS_TEXTURENAME, &g_pTextureLocus )))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}

}

// GtFNg̏I
void UninitLocus( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureLocus)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferLocus)


}

// GtFNg̍XV
void UpdateLocus( void )
{

	VERTEX_2D *pVtx;											// zAhX
	D3DXVECTOR2 radius;											// gppa

	// obt@bNzAhX擾
	g_pVtxBufferLocus -> Lock(0,0,(void**)&pVtx,0);				// GPUVRAMւ̑bN


	// GtFNg̍XV
	for( int inc = 0; inc < LOCUS_MAX; inc++ ){

		if( locuses[ inc ].life ){			

			//GtFNg̎̍XV
			locuses[ inc ].life -= 1 ;

			
			// F̐ݒ
			locuses[ inc ].color.a -= locuses[ inc ].colorValue;
			if( locuses[ inc ].color.a < 0.0f ){
				locuses[ inc ].color.a = 0.0f;
			}
				
			// _obt@ɃJ[̏
			SetColorLocus( pVtx , inc );

			// a̍XVƐݒ
			locuses[ inc ].radius -= locuses[ inc ].radiusValue;
			if( locuses[ inc ].radius < 0.0f ){
				locuses[ inc ].radius = 0.0f;
			}

			radius = D3DXVECTOR2( locuses[ inc ].radius, locuses[ inc ].radius);

			// ʊOh~
			if( __ObjectScreenOut( &locuses[ inc ].center, &radius )){
				
				locuses[ inc ].life = 0;
			} 


			// GtFNg̐ݒu
			SetVertexLocus( pVtx , inc );
			
			
		}	//if( locuses[ inc ].life ) -> END
	}	// for -> END

	// obt@̃AbN
	g_pVtxBufferLocus->Unlock();

}

// GtFNg̕`
void DrawLocus( void )
{


	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// Z̐ݒ
	pDevice ->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );			// 
	pDevice ->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		// ̃
	pDevice ->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );			// ̃


	// Xg[
	pDevice ->SetStreamSource( 0,		
	g_pVtxBufferLocus,									// ǂ̒_obt@\ƌԂ...
	0,													// f[^̃ItZbg
	sizeof(VERTEX_2D));									// XgChl(oCg)

	// _tH[}bg̐ݒ
	pDevice ->SetFVF( FVF_VERTEX_2D );

	// eNX`̐ݒ
	pDevice ->SetTexture( 0, g_pTextureLocus );	
	
	// |S̕`
	for( int index = 0; index < LOCUS_MAX ; index++ ){
		if( locuses[ index ].life ){
	
			pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, index*NUM_VERTEX, NUM_LOCUS );
	
		}
	}


	// ̏Ԃɖ߂
	pDevice ->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );			//
	pDevice ->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice ->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );	//̃


}

// _̍쐬
HRESULT MakeVertexLocus( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX * LOCUS_MAX,//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferLocus,						//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}



	// obt@bNzAhX擾
	g_pVtxBufferLocus -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN


	// _W̐ݒ
	for( int inc = 0; inc < LOCUS_MAX ; inc++ ){

		SetVertexLocus( pVtx , inc );

		pVtx[0 + inc*4].rhw=1.0f;
		pVtx[1 + inc*4].rhw=1.0f;
		pVtx[2 + inc*4].rhw=1.0f;
		pVtx[3 + inc*4].rhw=1.0f;

		pVtx[0 + inc*4].color=D3DCOLOR_RGBA(255, 255, 255, 255);
		pVtx[1 + inc*4].color=D3DCOLOR_RGBA(255, 255, 255, 255);
		pVtx[2 + inc*4].color=D3DCOLOR_RGBA(255, 255, 255, 255);
		pVtx[3 + inc*4].color=D3DCOLOR_RGBA(255, 255, 255, 255);

	}
	// obt@̃AbN
	g_pVtxBufferLocus->Unlock();

	return S_OK;

}

// GtFNg̐ݒu
void SetVertexLocus( VERTEX_2D *pVtx , const int arrayPos )
{


	D3DXVECTOR2 start,end;			// n_ƏI_



	// WvZ
	start.x = locuses[ arrayPos ].center.x - locuses[ arrayPos ].radius;
	start.y = locuses[ arrayPos ].center.y - locuses[ arrayPos ].radius;
	end.x = locuses[ arrayPos ].center.x + locuses[ arrayPos ].radius;
	end.y = locuses[ arrayPos ].center.y + locuses[ arrayPos ].radius;


	// _W̐ݒ
	pVtx[0 + (arrayPos * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, start.y, 0.0f);
	pVtx[1 + (arrayPos * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   start.y, 0.0f);
	pVtx[2 + (arrayPos * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, end.y,   0.0f);
	pVtx[3 + (arrayPos * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   end.y,   0.0f);

	pVtx[0 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f , 0.0f );
	pVtx[1 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f , 0.0f );
	pVtx[2 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f , 1.0f );
	pVtx[3 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f , 1.0f );

	/*
	int inc =2;
	int i =0;

	pVtx[0 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f +(inc*0.17f), 0.0f +( i *0.5f ));
	pVtx[1 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.17f+(inc*0.17f), 0.0f +( i *0.5f ));
	pVtx[2 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f+(inc*0.17f), 0.5f +( i *0.5f ));
	pVtx[3 + (arrayPos * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.17f+(inc*0.17f), 0.5f +( i *0.5f ));
	*/

}

// GtFNg̐FύX֐
void SetColorLocus ( VERTEX_2D *pVtx , const int arrayPos )
{

	// ̕ύX
	pVtx[ 0 + (arrayPos * NUM_VERTEX) ].color = locuses[ arrayPos ].color;
	pVtx[ 1 + (arrayPos * NUM_VERTEX) ].color = locuses[ arrayPos ].color;
	pVtx[ 2 + (arrayPos * NUM_VERTEX) ].color = locuses[ arrayPos ].color;
	pVtx[ 3 + (arrayPos * NUM_VERTEX) ].color = locuses[ arrayPos ].color;

}

// GtFNg̔
void SetLocus( const LPD3DXVECTOR2 pos, const float* radius, unsigned int life, D3DXCOLOR color )
{

	// GtFNg̐ݒu
	for( int index = 0; index < LOCUS_MAX; index++ ){

		if( !locuses[ index ].life ){


			{ // effect eݒ


				// GtFNg̔ˈʒu
				locuses[ index ].center = (*pos);

				// GtFNg̔a
				locuses[ index ].radius = (*radius);

				// GtFNg̐F
				locuses[ index ].color = color;

				// GtFNg̎̐ݒ
				locuses[ index ].life = life;

				// GtFNg萔̐ݒ
				locuses[ index ].colorValue = locuses[ index ].color.a / locuses[ index ].life;
				locuses[ index ].radiusValue = locuses[ index ].radius / locuses[ index ].life;


			} // -> Setting End 

			break;
		}
	}

}

// GtFNg̔( VECTOR3p )
void SetLocus( const LPD3DXVECTOR3 pos, const float radius, unsigned int life, D3DXCOLOR color )
{

	// GtFNg̐ݒu
	for( int index = 0; index < LOCUS_MAX; index++ ){

		if( !locuses[ index ].life ){


			{ // effect eݒ


				// GtFNg̔ˈʒu
				locuses[ index ].center.x = (pos->x);
				locuses[ index ].center.y = (pos->y);

				// GtFNg̔a
				locuses[ index ].radius = radius;

				// GtFNg̐F
				locuses[ index ].color = color;

				// GtFNg̎̐ݒ
				locuses[ index ].life = life;

				// GtFNg萔̐ݒ
				locuses[ index ].colorValue = locuses[ index ].color.a / locuses[ index ].life;
				locuses[ index ].radiusValue = locuses[ index ].radius / locuses[ index ].life;


			} // -> Setting End 

			break;
		}
	}

}


