/***************************************************************/
//
//
//		torikuro	[main.cpp]
//
//									Author	kazuki tanaka
//									Date	2016 07/01
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

Update : 2016/06/15
			FPS̕\

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "select_input_device.h"
#include "input.h"
#include "mouse.h"
#include "gamepad.h"
#include "sound.h"

#include "title.h"
#include "tutorial.h"
#include "game.h"
#include "result.h"
#include "ending.h"

#include "fade.h"									// V[[vɕKv

#include "backbuffer.h"


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

// ֐|C^̌^
typedef void (*MadeFunc)( void );

//#define _MODE_WIREFRAME_							// C[t[[hŋN
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define CLASS_NAME "LEAD"							// EBhENX̖O
const char WINDOW_NAME[] = { "LEAD ver1.03" };		// EBhE̖O

#define TIMER_INTERVAL (1000/60)					// Ԋu601b

//#define WIN_STYLE (WS_OVERLAPPEDWINDOW ^ WS_THICKFRAME ^ WS_MINIMIZEBOX ^ WS_MAXIMIZEBOX )
#define WIN_STYLE (WS_OVERLAPPEDWINDOW ^ WS_THICKFRAME ^ WS_MINIMIZEBOX )
													// Window̃}N


// AhX
MadeFunc pInitFunc[] ={
	InitTitle,
	InitTutorial,
	InitGame,
	InitResult,
};

// IAhX
MadeFunc pUninitFunc[] ={
	UninitTitle,
	UninitTutorial,
	UninitGame,
	UninitResult,
};

// XVAhX
MadeFunc pUpdateFunc[] ={
	UpdateTitle,
	UpdateTutorial,
	UpdateGame,
	UpdateResult,
};

// `AhX
MadeFunc pDrawFunc[] ={
	DrawTitle,
	DrawTutorial,
	DrawGame,
	DrawResult,
};

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

LRESULT CALLBACK WndProc(HWND hWnd,					// EBhEvV[W֐
	UINT uMsg,
	WPARAM wParam,
	LPARAM lParam);

HRESULT Init(										// DirectX9̏ݒ
	HINSTANCE hInstance,
	HWND hWnd,
	BOOL bWindow);

void UnInit(void);									// I
void Update( void );								// XV
void Draw ( void );									// ʂ̕`

#ifdef _DEBUG
void DrawFPS( void );								// FPS\p
#endif

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3D9 g_pD3D=NULL;							// foCX쐬p

LPDIRECT3DDEVICE9 g_pD3DDevice=nullptr;				// Direct3DfoCXC^[tF[X̎擾

#ifdef _DEBUG
LPD3DXFONT g_pFont = nullptr;						// FPSEBhEɏނ߂̃C^[tF[X
#endif

SCENE sceneSelect = SCENE_TITLE;					// V[̑IE

int g_nCountFPS = 0;								// FPSJEgp


// Win32AvP[V
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPravInstance,LPSTR IpCmdLine, int nCmdShow)
{

	UNREFERENCED_PARAMETER(hPravInstance);
	UNREFERENCED_PARAMETER(IpCmdLine);

	RECT cr = {0,0,SCREEN_WIDTH,SCREEN_HEIGHT};


	WNDCLASSEX wcex={
		sizeof(WNDCLASSEX),							//WNDCALSSEX̃TCYw
		CS_CLASSDC,									//\EBhẼX^Cݒ
		WndProc,									//  EBhEvV[W̃AhX(֐)w
		0,											//ʏ͎gpȂ̂"0"w
		0,											//ʏ͎gpȂ̂"0"wx
		hInstance,									//  WinMaiñp[^̃CX^Xnhݒ
		LoadIcon(hInstance, TEXT("KITTY")),			//gpACRw(WindowĂACRg)
		LoadCursor(NULL, IDC_CROSS),				//}EXJ[\w
		(HBRUSH)(COLOR_WINDOW + 1),					//EBhẼNCAg̈̔wiFݒ
		NULL,										//Windowsɂ郁j[ݒ
		CLASS_NAME,									//  EBhENX̖O
		NULL										//ACRݒ肳ꂽꍇ̏Lq
	};


	// EBhENX̓o^
	RegisterClassEx(&wcex);

	HWND hWnd;										//EBhEnh
	MSG msg;										//EBhEbZ[W

	AdjustWindowRect(&cr,WIN_STYLE,FALSE);

	int windowWidth = cr.right-cr.left;
	int windowHeight = cr.bottom-cr.top;

	RECT dr;

	GetWindowRect(GetDesktopWindow(),&dr);

	int dw = dr.right-dr.left;
	int dh = dr.bottom-dr.top;

	int windowX = windowWidth>dw ? 0:(dw-windowWidth)/2;
	int windowY = windowHeight>dh ? 0:(dh-windowHeight)/2;


	// EBhE쐬
	hWnd = CreateWindowEx(0,						//gEBhEX^C
	CLASS_NAME,										//EBhENX̖O
	WINDOW_NAME,									//EBhE̖O
	WIN_STYLE,										//EBhEX^C
	windowX,										//EBhE̍XW
	windowY,										//EBhE̍YW
	windowWidth,									//EBhE̕
	windowHeight,									//EBhE̍
	NULL,											//eEBhẼnh
	NULL,											//j[nh܂͎qEBhEID
	hInstance,										//CX^Xnh
	NULL);											//EBhE쐬f[^


	// EBhE̕\

	// EBhEnh
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// \̐ݒ
	timeBeginPeriod( 1 );

	// eJE^[̏
	DWORD dwFrameCount = 0;
	DWORD dwCurrentTime = 0;
	DWORD dwExecLastTime = timeGetTime();			//݂̎~bPʂŎ擾
	DWORD dwFPSLastTime = dwExecLastTime;			//Ԃ𓯊

	// ֐
	Init(hInstance,hWnd,true);

	// bZ\W[v
	for(;;){
	
		if(PeekMessage(&msg,NULL,0,0,PM_REMOVE)!=0){

			// Windows̏
			if(msg.message==WM_QUIT){
				break;
			}
			else{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else{

			dwCurrentTime = timeGetTime();		//݂̎~bPʂŎ擾
			
			if( (dwCurrentTime-dwFPSLastTime) >= 500 ){

				g_nCountFPS=(dwFrameCount*1000)/(dwCurrentTime-dwFPSLastTime);
				dwFPSLastTime = dwCurrentTime;
				dwFrameCount=0;
			
			}
			if( (dwCurrentTime - dwExecLastTime) >= ( TIMER_INTERVAL ) ){

				// DirectX̏
				dwExecLastTime=dwCurrentTime;	//Ԃۑ
				Update();						//XV
				Draw();							//`
				dwFrameCount++;

			}
		}
	}

	// I
	UnInit();

	// ȑOɃZbgꂽŏ^C}\NA
	timeEndPeriod( 1 );

	return (int)msg.wParam;						//֐0Ԃ

}

// EBhEvV[W
LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{

	// Window Message
	switch( uMsg ){

		case WM_CLOSE:
			
			// WindowI
			if( MessageBox(NULL,"I܂H",WINDOW_NAME, MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2) == IDNO ){
				uMsg = NULL;
			}
			break;

		case WM_DESTROY:

			PostQuitMessage(0);
			break;

		case WM_KEYDOWN:

			// ESCI
			if( wParam == VK_ESCAPE ) {					
				if( MessageBox(NULL,"I܂H",WINDOW_NAME, MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2) == IDYES ){
					DestroyWindow(hWnd);
				}
			}
			
			/*
			// 펞p̃foCXĐݒ
			if( wParam == VK_CONTROL && VK_SHIFT )	{
				MessageBox(NULL," foCX̍Đݒ܂B ", " DEVICE_RESET !! " , MB_OK | MB_ICONWARNING );
				SetInputDevice( DEVICE_STANDARD );
			}
			break;
			*/

		default:
			break;
	}

	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

// DirectX̏֐
HRESULT Init(HINSTANCE hInstance,HWND hWnd,BOOL bWindow)
{

	/* DirectX9̐ݒ()					*/
	/* IDirect3DDevice9C^[tF[X̎擾	*/


	D3DPRESENT_PARAMETERS d3dpp={0};			//foCX̓ݒ肷\
	D3DDISPLAYMODE d3ddm;						//fBXvC̐ݒ

	g_pD3D = Direct3DCreate9(D3D_SDK_VERSION);	//D3D9C^[tF[X̎擾
	if( g_pD3D==NULL ){
		return E_FAIL;
	}

	// ݂̃foCX[h̎擾
	if(FAILED(g_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&d3ddm))){
		return E_FAIL;
	}

	// foCX̃v[e[Vp[^[̐ݒ
	ZeroMemory(&d3dpp,sizeof(d3dpp));

	d3dpp.BackBufferWidth=SCREEN_WIDTH;			//backbuffer̃TCY()
	d3dpp.BackBufferHeight=SCREEN_HEIGHT;		//backbuffer̃TCY(c)
	d3dpp.BackBufferFormat=d3ddm.Format;		//FULLSCREEN̂Ƃ͂̌ł͂ȂAWINDOWMODE͕
	d3dpp.BackBufferCount=1;					//backBuffer̐
	d3dpp.SwapEffect=D3DSWAPEFFECT_DISCARD;		//doubleBuffer̐؂ւ
	d3dpp.EnableAutoDepthStencil=TRUE;			//dv ;DepthStencil̎gp
	d3dpp.AutoDepthStencilFormat=D3DFMT_D16;	//D3DtH[}bg̐ݒ
	d3dpp.Windowed=bWindow;						//WindowMode trueŃEBhE falseFullScreen(WindoWIN_STYLEpopup)
	d3dpp.FullScreen_RefreshRateInHz
	=D3DPRESENT_RATE_DEFAULT;					//Xs[h(fullscreen̂Ƃ̂ݐݒ\)
	d3dpp.PresentationInterval
	=D3DPRESENT_INTERVAL_DEFAULT;				//fullscreen̎̂ 邩ǂ


	// Direct3DfoCX̐ݒ
	if(FAILED( g_pD3D->CreateDevice(
	D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
	D3DDEVTYPE_HAL,								//`揈type̎w(n[hł邩\tgł邩)HAL=n[h
	hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
	D3DCREATE_HARDWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓n[hEFAŒ_)
	&d3dpp,										//̑ݒ
	&g_pD3DDevice)))							//foCX̃|C^̃|C^
	//sNULLԂ
	{

		MessageBox(hWnd,"x܂","",MB_OK);
		if(FAILED( g_pD3D->CreateDevice(
		D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
		D3DDEVTYPE_HAL,								//`揈type̎w(n[hł邩\tgł邩)HAL=n[h
		hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
		D3DCREATE_SOFTWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓\tgEFAŒ_)
		&d3dpp,										//̑ݒ
		&g_pD3DDevice)))							//foCX̃|C^̃|C^
		{	

			if(FAILED( g_pD3D->CreateDevice(
			D3DADAPTER_DEFAULT,							//ftHg̃A_v^[擾
			D3DDEVTYPE_REF,								//`揈type̎w(n[hł邩\tgł邩)
			hWnd,										//ǂ̃EBhȄɍ쐬邩(tH[JXEBhE)
			D3DCREATE_SOFTWARE_VERTEXPROCESSING,		//foCX쐬IvVtO(̓\tgEFAŒ_)
			&d3dpp,										//̑ݒ
			&g_pD3DDevice)))							//foCX̃|C^̃|C^
			{
				return E_FAIL;
			}
		}
	}

	// _\Xe[g̐ݒ
	//g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CW);				//v𗠖ʂƂ
	g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);				//v𗠖ʂƂ
	//g_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);			//ʂ`悷

	#ifndef _MODE_WIREFRAME_
	g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_SOLID);				//|Sŕ`
	#else
	g_pD3DDevice->SetRenderState(D3DRS_FILLMODE,D3DFILL_WIREFRAME);			//|SC[t[ŕ`
	#endif //_MODE_WIREFRAME_

	// ݉ʂɕ`ĂԂɂč`悷e
	g_pD3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );			//
	g_pD3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	g_pD3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );	//̃(INV͋ẗӖ,ł̓l̋t)

	// Tv[Xe[g̐ݒ(stagesteat texturestate)
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR);
	g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);
	//g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
	//g_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);
	
	// eNX`Xe[g̐ݒ( ߏݒ )
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );

	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
	g_pD3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
	

	// obNobt@T[tFX|C^̎擾
	SetBackbuf( );

	// ̓foCX̏
	InitInputDevice( hWnd, hInstance );

	// TEh̐ݒ
	InitWaveSound(hWnd);

	// e֐̏
	InitFade( );
	pInitFunc[ sceneSelect ]( );

	#ifdef _DEBUG
	D3DXCreateFont( g_pD3DDevice,18,0,0,0,FALSE,
	SHIFTJIS_CHARSET,
	OUT_DEFAULT_PRECIS,
	DEFAULT_QUALITY,
	DEFAULT_PITCH,
	"terminal",&g_pFont );
	#endif	//_DEBUG

	//
	return S_OK;
	
}

// I
void UnInit(void)
{


	// ̓foCX̉
	UninitInputDevice( );
	
	// I
	UninitFade( );
	pUninitFunc[ sceneSelect ]( );

	// TEhfoCX
	UninitSound();


	// obNobt@T[tFX|C^̉
	ReleaseBackbuf( );

	// Direct3DDeviceƃAhX̉
	SAFE_RELEASE(g_pD3DDevice)

	// Direect3DC^[tF[X̉
	SAFE_RELEASE(g_pD3D)

	// tHg\p̃C^[tF[X̊J
	#ifdef _DEBUG
	SAFE_RELEASE(g_pFont)
	#endif //_DEBUG

}

// XV
void Update( void )
{
	
	static unsigned int frame;		//Q[𐔂t[
	

	// ̓foCX̍XV
	UpdateInputDevice( );

	// [h̑I
	pUpdateFunc[ sceneSelect ]( );

	/*
	if( GetKeyboardTrigger( DIK_RETURN ) ){

		switch( sceneSelect )
		{
			case SCENE_TITLE:
				//ChangeMode( MODE_GAME );
				ChangeScene( SCENE_TUTORIAL );
				break;

			case SCENE_TUTORIAL:

				SetFade( FADE_OUT, SCENE_GAME );
				break;

			case SCENE_GAME:
				//ChangeMode( MODE_RESULT );
				SetFade( FADE_OUT, SCENE_RESULT );
				break;

			case SCENE_RESULT:
				//ChangeMode( MODE_TITLE );
				SetFade( FADE_OUT, SCENE_TITLE );
				break;

		}
	}*/

	UpdateFade( );

	frame++;

	// t[̃Zbg
	FRAME_RESET(frame,60)	

}

// `揈
void Draw ( void )
{

	// obNobt@Zobt@̃NA
	g_pD3DDevice->Clear(0,NULL,
	D3DCLEAR_TARGET								//F
	| D3DCLEAR_ZBUFFER,							//[x
	D3DCOLOR_RGBA(0,0,0,0),						//NAF
	1.0f,										//NA[xl
	0);											//XeVl

	// `̊Jn
	if(SUCCEEDED( g_pD3DDevice->BeginScene() ))
	{

		// [h̑I
		pDrawFunc[ sceneSelect ]( );

		// tF[h`
		if( GetFade() ){
			DrawFade( );
		}

		#ifdef _DEBUG
		DrawFPS();
		#endif	//_DEBUG
		
		// `I
		g_pD3DDevice->EndScene();

	}
	g_pD3DDevice->Present(NULL,NULL,NULL,NULL);

}

// FPS̕\
#ifdef _DEBUG
void DrawFPS( void )
{

	// FPS̕`O
	RECT rect={ 0,0,SCREEN_WIDTH,SCREEN_HEIGHT };

	char aStr[ 256 ];
	char str1[ 256 ];
	char str2[ 256 ];
	long x,y,z;

	sprintf(&aStr[0]," FPS : %d ",g_nCountFPS);

	// }EX̍W擾
	x = GetMouseX( );
	y = GetMouseY( );
	z = GetMouseZ( );


	//sprintf( &str1[0], "\n MouseX : %d \n MouseY : %d \n MouseZ : %d ", x, y, z );

	//sprintf( &str1[0], "\n MouseX : %d \n MouseY : %d \n MouseZ : %d ", point.x, point.y, z );
	sprintf( &str1[0], "\n MouseX : %d \n MouseY : %d \n MouseZ : %d ", GetMouseX(), GetMouseY(), z );


	// G̍W擾


	// FPS̕`揈
	g_pFont->DrawText(NULL,&aStr[0],-1,&rect,DT_LEFT,D3DCOLOR_RGBA(0,255,0,255));
	g_pFont->DrawText(NULL,&str1[0],-1,&rect,DT_LEFT,D3DCOLOR_RGBA(0,255,0,255));
	//g_pFont->DrawText(NULL,&str2[0],-1,&rect,DT_LEFT,D3DCOLOR_RGBA(0,255,0,255));


}
#endif	//_DEBUG

// foCX̎擾
LPDIRECT3DDEVICE9 GetDevice(void)
{

	return g_pD3DDevice;

}

// V[̎擾
void ChangeScene( SCENE scene )
{

	// ݂̊֐I
	pUninitFunc[ sceneSelect ]( );

	// V[`FW
	sceneSelect = scene;
	//SetFade( FADE_OUT, mode );
	

	// N郂[h̏
	pInitFunc[ sceneSelect ]( );


}

// -> END