//*************************************************************************************************
// obg (bullet.cpp)
// Author : YUHEI KAN
//*************************************************************************************************

//*************************************************************************************************
// wb_
//*************************************************************************************************
#include "main.h"
#include "particle.h"

//*************************************************************************************************
// 萔`
//*************************************************************************************************
#define PARTICLE_TEXTURE_MAX ( 2 )                //ǂݍރeNX`̖

#define NUM_POLYGON ( 2 )
#define NUM_VERTEX  ( 4 )


//*************************************************************************************************
// \
//*************************************************************************************************

//*************************************************************************************************
// O[oϐ
//*************************************************************************************************
LPDIRECT3DTEXTURE9 g_pTextureParticle[PARTICLE_TEXTURE_MAX]; //eNX`C^[tF[X|C^
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferParticle;               //_obt@ǗC^[tF[X|C^
PARTICLE g_aParticle[PARTICLE_MAX];                   //e
int nCntFPSParticle;                              //FPSJE^

//*************************************************************************************************
// vg^Cv錾
//*************************************************************************************************
HRESULT MakeVertexParticle ( LPDIRECT3DDEVICE9 pDevice );
void SetVertexParticle ( VERTEX_2D* pVtx, int nTexNum );

//*************************************************************************************************
// obg
//*************************************************************************************************
void InitParticle ( void )
{
    //ϐ
    nCntFPSParticle = 0;                           //FPSJE^

    //Direct3DfoCX̎擾
    LPDIRECT3DDEVICE9 pDevice = GetDevice ( );

    //Direct3DfoCXNULL`FbN
    if ( pDevice != NULL )
    {
        //_̍쐬
        if ( FAILED ( MakeVertexParticle ( pDevice ) ) )
        {
            MessageBox ( NULL, "_̍쐬Ɏs܂", "IbZ[W", MB_OK );
        }

        //eNX`̓ǂݍ
        if ( FAILED ( D3DXCreateTextureFromFile ( pDevice, "data/TEXTURE/effect000.jpg", &g_pTextureParticle[0] ) )
            || FAILED ( D3DXCreateTextureFromFile ( pDevice, "data/TEXTURE/effect000.jpg", &g_pTextureParticle[1] ) ) )
        {
            MessageBox ( NULL, "eNX`̓ǂݍ݂Ɏs܂", "IbZ[W", MB_OK );
        }
    }

    //obg
    for ( int nCntParticle = 0; nCntParticle < PARTICLE_MAX; nCntParticle++ )
    {
        g_aParticle[nCntParticle].bUse = false;
    }
}

//*************************************************************************************************
// obgXV
//*************************************************************************************************
void UpdateParticle ( void )
{
     //_̐ݒ
     VERTEX_2D* pVtx;                                //zAhXp|C^

    //_obt@bNāAzAhX擾
    g_pVtxBufferParticle->Lock ( 0, 0, (void**)&pVtx, 0 );

    for ( int nCntParticle = 0; nCntParticle < PARTICLE_MAX; nCntParticle++ )
    {
        if ( !g_aParticle[nCntParticle].bUse )
        {
            continue;
        }
        //g_aParticle[nCntParticle].Pos += g_aParticle[nCntParticle].Speed;

        //̍XV
        g_aParticle[nCntParticle].nLife--;
        if ( g_aParticle[nCntParticle].nLife <= 0 )
        {
            g_aParticle[nCntParticle].bUse = false;
        }
        else
        {
            //x̉Z
            g_aParticle[nCntParticle].Speed.x *= g_aParticle[nCntParticle].Acceleration.x;
            g_aParticle[nCntParticle].Speed.y *= g_aParticle[nCntParticle].Acceleration.y;

            //ʒu̍XV
            g_aParticle[nCntParticle].Pos.x += g_aParticle[nCntParticle].Speed.x;
            g_aParticle[nCntParticle].Pos.y += g_aParticle[nCntParticle].Speed.y;
        }
        if ( g_aParticle[nCntParticle].bUse == true )
        {
            SetVertexParticle ( pVtx, nCntParticle );
        }
    }

    //_obt@̃bN
    g_pVtxBufferParticle->Unlock ( );
}

//*************************************************************************************************
// obg`揈
//*************************************************************************************************
void DrawParticle ( void )
{
    //Direct3DfoCX̎擾
    LPDIRECT3DDEVICE9 pDevice = GetDevice ( );

    //Direct3DfoCXNULL`FbN
    if ( pDevice != NULL )
    {
        //_obt@ݒ(Xg[)
        pDevice->SetStreamSource ( 0, g_pVtxBufferParticle, 0, sizeof ( VERTEX_2D ) );

        //_tH[}bg̐ݒ
        pDevice->SetFVF ( FVF_VERTEX_2D );


        //Z
        pDevice->SetRenderState ( D3DRS_BLENDOP, D3DBLENDOP_ADD );      //At@uh
        pDevice->SetRenderState ( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );     //eNX`
        pDevice->SetRenderState ( D3DRS_DESTBLEND, D3DBLEND_ONE );         //wi

        //eNX`̐ݒ
        pDevice->SetTexture ( 0, g_pTextureParticle[0] );

        for ( int nCntParticle = 0; nCntParticle < PARTICLE_MAX; nCntParticle++ )
        {
            if ( g_aParticle[nCntParticle].bUse == true )
            {
                //v~eBu̕`
                pDevice->DrawPrimitive ( D3DPT_TRIANGLESTRIP,           //vb~eBu̎
                    0 + nCntParticle * 4,                                 //ItZbg(_)
                    NUM_POLYGON );                                      //v~eBu
            }
        }

        pDevice->SetRenderState ( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA ); //wi
    }
}

//*************************************************************************************************
// obgI
//*************************************************************************************************
void UninitParticle ( void )
{
    //eNX`C^[tF[X̉
    if ( g_pTextureParticle != NULL )
    {
        for ( int nCntRelease = 0; nCntRelease < PARTICLE_TEXTURE_MAX; nCntRelease++ )
        {
            g_pTextureParticle[nCntRelease]->Release();
            g_pTextureParticle[nCntRelease] = NULL;
        }
    }

    //_obt@ǗC^[tF[X̉
    if ( g_pVtxBufferParticle != NULL )
    {
        g_pVtxBufferParticle->Release();
        g_pVtxBufferParticle= NULL;
    }
}

//*************************************************************************************************
// _̍쐬
//*************************************************************************************************
HRESULT MakeVertexParticle ( LPDIRECT3DDEVICE9 pDevice )
{
    if ( FAILED (pDevice->CreateVertexBuffer ( 
        sizeof ( VERTEX_2D ) * NUM_VERTEX * PARTICLE_MAX,  //쐬_obt@̃TCY
        D3DUSAGE_WRITEONLY,                          //VertexBuffer̎gw
        FVF_VERTEX_2D,                               //
        D3DPOOL_MANAGED,                             //ǗiNǗ邩j
        &g_pVtxBufferParticle,                          //
        NULL ) ) )
    {
        return E_FAIL;
    }
    else
    {
    }

    return S_OK;
}

//*************************************************************************************************
// _̐ݒ
//*************************************************************************************************
void SetVertexParticle ( VERTEX_2D* pVtx, int nTexNum )
{
    //_W̐ݒ(2DW)
    pVtx[ 0 + nTexNum * 4 ].pos = D3DXVECTOR3 ( g_aParticle[nTexNum].Pos.x, g_aParticle[nTexNum].Pos.y, 0.0f );
    pVtx[ 1 + nTexNum * 4 ].pos = D3DXVECTOR3 ( g_aParticle[nTexNum].Pos.x + 50.0f, g_aParticle[nTexNum].Pos.y, 0.0f );
    pVtx[ 2 + nTexNum * 4 ].pos = D3DXVECTOR3 ( g_aParticle[nTexNum].Pos.x, g_aParticle[nTexNum].Pos.y + 50.0f, 0.0f );
    pVtx[ 3 + nTexNum * 4 ].pos = D3DXVECTOR3 ( g_aParticle[nTexNum].Pos.x + 50.0f, g_aParticle[nTexNum].Pos.y + 50.0f, 0.0f );

    //rhw̐ݒ(K1.0f)
    pVtx[ 0 + nTexNum * 4 ].rhw = 
    pVtx[ 1 + nTexNum * 4 ].rhw = 
    pVtx[ 2 + nTexNum * 4 ].rhw = 
    pVtx[ 3 + nTexNum * 4 ].rhw = 1.0f;

    //_J[(0`255̐l)
    pVtx[ 0 + nTexNum * 4 ].color = D3DXCOLOR( g_aParticle[nTexNum].Color.r, g_aParticle[nTexNum].Color.g, g_aParticle[nTexNum].Color.b, g_aParticle[nTexNum].Color.a );
    pVtx[ 1 + nTexNum * 4 ].color = D3DXCOLOR( g_aParticle[nTexNum].Color.r, g_aParticle[nTexNum].Color.g, g_aParticle[nTexNum].Color.b, g_aParticle[nTexNum].Color.a );
    pVtx[ 2 + nTexNum * 4 ].color = D3DXCOLOR( g_aParticle[nTexNum].Color.r, g_aParticle[nTexNum].Color.g, g_aParticle[nTexNum].Color.b, g_aParticle[nTexNum].Color.a );
    pVtx[ 3 + nTexNum * 4 ].color = D3DXCOLOR( g_aParticle[nTexNum].Color.r, g_aParticle[nTexNum].Color.g, g_aParticle[nTexNum].Color.b, g_aParticle[nTexNum].Color.a );

    //eNX`W̐ݒ
    pVtx[ 0 + nTexNum * 4 ].tex = D3DXVECTOR2 ( 0.0f, 0.0f );
    pVtx[ 1 + nTexNum * 4 ].tex = D3DXVECTOR2 ( 1.0f, 0.0f );
    pVtx[ 2 + nTexNum * 4 ].tex = D3DXVECTOR2 ( 0.0f, 1.0f );
    pVtx[ 3 + nTexNum * 4 ].tex = D3DXVECTOR2 ( 1.0f, 1.0f );
}

//*************************************************************************************************
// e̐ݒ
//*************************************************************************************************
void SetParticle ( float Pos_x, float Pos_y, float Speed_x, float Speed_y, int nLife, float Color_r, float Color_g, float Color_b, float Color_a )
{
    for ( int nCntParticle = 0; nCntParticle < PARTICLE_MAX; nCntParticle++ )
    {
        if ( g_aParticle[nCntParticle].bUse == false )
        {
            g_aParticle[nCntParticle].Pos.x = Pos_x;
            g_aParticle[nCntParticle].Pos.y = Pos_y;
            g_aParticle[nCntParticle].Speed.x = Speed_x;
            g_aParticle[nCntParticle].Speed.y = Speed_y;
            g_aParticle[nCntParticle].nLife = nLife;
            g_aParticle[nCntParticle].Color.r = 0.5;
            g_aParticle[nCntParticle].Color.g = 0.5;
            g_aParticle[nCntParticle].Color.b = 0.5;
            g_aParticle[nCntParticle].Color.a = 0.5;
            g_aParticle[nCntParticle].bUse = true;
            break;
        }
    }
}

//*************************************************************************************************
// p[eBN̎擾
//*************************************************************************************************
PARTICLE *GetParticle ( void )
{
    return &g_aParticle[0];
}