//--------------------------------------------------------------------------------
//
//@EChE\vO
//	Author : Xu Wenjie
//	Date   : 2016-04-26
//--------------------------------------------------------------------------------
//  Update : 
//	
//--------------------------------------------------------------------------------
#include "input.h"
#include "player.h"
#include "enemy.h"
#include "explosion.h"
//#include "effect.h"
#include "KF_Precision.h"
#include "KF_Body.h"
#include "KF_BodyContact.h"

#include "sound.h"
#include "frame.h"

//--------------------------------------------------------------------------------
//  萔`
//--------------------------------------------------------------------------------
#define NUM_POLYGON ( 2 )
#define NUM_VERTEX  ( 4 )

#define PLAYER_WIDTH (50.0f)//|S̕
#define PLAYER_HEIGHT (50.0f)//|S̍
#define PLAYER_TEXTURENAME "data/TEXTURE/frame.png"//t@C
#define PLAYER_POS_X (640.0f)//|S̕\ʒuX
#define PLAYER_POS_Y (320.0f)//|S̕\ʒuY
#define MOVE_SPEED_X (D3DXVECTOR3(10.0f,0.0f,0.0f))//lړx
#define MOVE_SPEED_Y (D3DXVECTOR3(0.0f,10.0f,0.0f))//lړx
#define ROTATION_SPEED (D3DX_PI * 0.5f)//]x

//--------------------------------------------------------------------------------
//  \̒`
//--------------------------------------------------------------------------------
typedef struct {
	LPDIRECT3DTEXTURE9 pTexture;//textureC^[tF[X
	LPDIRECT3DVERTEXBUFFER9 pVtxBuffer;//_obt@ǗC^[tF[X|C^
	CBodyBox *pPlayerBody;
	D3DXVECTOR3 vPosCenter;
	int nframe;
	bool bCheck;
	float fScrollU;//u
	float fScrollV;//v
}PLAYER;

//--------------------------------------------------------------------------------
//  vg^Cv錾
//--------------------------------------------------------------------------------
HRESULT MakeVerTexPlayer(LPDIRECT3DDEVICE9 pDevice);

//--------------------------------------------------------------------------------
//  O[oϐ
//--------------------------------------------------------------------------------
PLAYER g_player;

//--------------------------------------------------------------------------------
//  
//--------------------------------------------------------------------------------
void InitPlayer(void)
{
	LPDIRECT3DDEVICE9 pDevice = GetDevice();//foCX擾

	g_player.fScrollU = 0.0f;
	g_player.fScrollV = 0.0f;
	g_player.nframe = 0;
	g_player.vPosCenter = D3DXVECTOR3(PLAYER_POS_X, PLAYER_POS_Y, 0.0f);
	g_player.pTexture = NULL;
	g_player.pVtxBuffer = NULL;
	g_player.bCheck = true;

	g_player.pPlayerBody = new CBodyBox;
	g_player.pPlayerBody->Init();
	g_player.pPlayerBody->cBody.SetPosCenter(D3DXVECTOR3(PLAYER_POS_X, PLAYER_POS_Y, 0.0f));
	g_player.pPlayerBody->cBody.SetGravityCenter(D3DXVECTOR3(PLAYER_POS_X, PLAYER_POS_Y, 0.0f));
	g_player.pPlayerBody->cBody.SetMass(100000000000000.0f);
	g_player.pPlayerBody->cBody.SetGravity(GRAVITY);
	g_player.pPlayerBody->cBody.SetRotation(D3DX_PI * -0.75f);
	g_player.pPlayerBody->SetHalfSize(D3DXVECTOR2( 5.0f, 25.0f));
	g_player.pPlayerBody->SetAngle(atan2(PLAYER_HEIGHT, PLAYER_WIDTH));

	if (FAILED(MakeVerTexPlayer(pDevice)))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "MakeVerTexPlayer ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}

	//n[hfBXNTexture̓ǂݍ
	//G[`FbNK{
	if (FAILED(D3DXCreateTextureFromFile(pDevice,
		PLAYER_TEXTURENAME,
		&g_player.pTexture)))//texture|C^ւ̃|C^
	{
		MessageBox(NULL, "D3DXCreateTextureFromFile ERROR!!", "G[", MB_OK | MB_ICONWARNING);
	}
}

//--------------------------------------------------------------------------------
//  I
//--------------------------------------------------------------------------------
void UninitPlayer(void)
{
	if (g_player.pPlayerBody != NULL)
	{
		g_player.pPlayerBody->Uninit();//I
		delete g_player.pPlayerBody;//g폜
		g_player.pPlayerBody = NULL;//AhXɂ
	}
	
	if (g_player.pVtxBuffer != NULL)
	{
		g_player.pVtxBuffer->Release();
		g_player.pVtxBuffer = NULL;
	}

	if (g_player.pTexture != NULL)
	{
		g_player.pTexture->Release();
		g_player.pTexture = NULL;
	}
}

//--------------------------------------------------------------------------------
//  XV
//--------------------------------------------------------------------------------
void UpdatePlayer(void)
{
	VERTEX_2D *pVtx = NULL;

	D3DXVECTOR3 vPlayerPos = g_player.pPlayerBody->cBody.GetPosCenter();
	float fRotation = g_player.pPlayerBody->cBody.GetRotation();
	float fLength = g_player.pPlayerBody->GetLength();
	float fAngle = g_player.pPlayerBody->GetAngle();

	g_player.pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	//texture
	pVtx[0].tex = D3DXVECTOR2(g_player.nframe * 0.2f, 0.0f);
	pVtx[1].tex = D3DXVECTOR2(g_player.nframe * 0.2f + 0.2f, 0.0f);
	pVtx[2].tex = D3DXVECTOR2(g_player.nframe * 0.2f, 1.0f);
	pVtx[3].tex = D3DXVECTOR2(g_player.nframe * 0.2f + 0.2f, 1.0f);

	g_player.pVtxBuffer->Unlock();

	//jO
	//g_player.nCntScrollU = (g_player.nCntScrollU + 1) % (NUM_MOTION_X * (int)g_player.fSpeed);
	//g_player.nCntScrollV = (g_player.nCntScrollV + 1) % (NUM_MOTION_X * NUM_MOTION_Y * (int)g_player.fSpeed);
	//g_player.fScrollU = (float)(g_player.nCntScrollU / (int)g_player.fSpeed) / (float)NUM_MOTION_X;
	//g_player.fScrollV = (float)(g_player.nCntScrollV / (int)g_player.fSpeed / NUM_MOTION_X) / (float)NUM_MOTION_Y;

	//key
	//if (GetKeyboardPress(DIK_W))//WL[Ă
	//{
	//	g_player.pPlayerBody->cBody.SetPosCenter(g_player.pPlayerBody->cBody.GetPosCenter() - MOVE_SPEED_Y);
	//}

	//if (GetKeyboardPress(DIK_S))//SL[Ă
	//{
	//	g_player.pPlayerBody->cBody.SetPosCenter(g_player.pPlayerBody->cBody.GetPosCenter() + MOVE_SPEED_Y);
	//}

	//if (GetKeyboardPress(DIK_A))//AL[Ă
	//{
	//	g_player.pPlayerBody->cBody.SetPosCenter(g_player.pPlayerBody->cBody.GetPosCenter() - MOVE_SPEED_X);
	//}

	//if (GetKeyboardPress(DIK_D))//DL[Ă
	//{
	//	g_player.pPlayerBody->cBody.SetPosCenter(g_player.pPlayerBody->cBody.GetPosCenter() + MOVE_SPEED_X);
	//}

	if (GetKeyboardTrigger(DIK_LEFT))//]
	{
		g_player.nframe--;
		g_player.nframe = g_player.nframe == -1 ? 4 : g_player.nframe;
	}

	if (GetKeyboardTrigger(DIK_RIGHT))//E]
	{
		g_player.nframe = (g_player.nframe + 1) % 5;
	}

	g_player.bCheck = g_player.nframe == 4 ? false : true;

	//position
	if (g_player.bCheck)
	{
		//rotation
		if (g_player.nframe == 0)
		{
			g_player.pPlayerBody->cBody.SetRotation(D3DX_PI * -0.75f);
		}
		if (g_player.nframe == 3)
		{
			g_player.pPlayerBody->cBody.SetRotation(D3DX_PI * -0.25f);
		}
		if (g_player.nframe == 2)
		{
			g_player.pPlayerBody->cBody.SetRotation(D3DX_PI * 0.25f);
		}
		if (g_player.nframe == 1)
		{
			g_player.pPlayerBody->cBody.SetRotation(D3DX_PI * 0.75f);
		}

		switch (g_player.nframe)
		{
		case 0:
			g_player.pPlayerBody->cBody.SetPosCenter(D3DXVECTOR3(g_player.vPosCenter.x + PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y + PLAYER_HEIGHT * 0.5f, 0.0f));
			break;
		case 3:
			g_player.pPlayerBody->cBody.SetPosCenter(D3DXVECTOR3(g_player.vPosCenter.x - PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y + PLAYER_HEIGHT * 0.5f, 0.0f));
			break;
		case 2:
			g_player.pPlayerBody->cBody.SetPosCenter(D3DXVECTOR3(g_player.vPosCenter.x - PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y - PLAYER_HEIGHT * 0.5f, 0.0f));
			break;
		case 1:
			g_player.pPlayerBody->cBody.SetPosCenter(D3DXVECTOR3(g_player.vPosCenter.x + PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y - PLAYER_HEIGHT * 0.5f, 0.0f));
			break;
		}
	}

	g_player.pPlayerBody->Update();

	//check contact
	if (g_player.bCheck)
	{
		int nCnt = 0;
		ENEMY *pEnemy = NULL;

		for (nCnt = 0; nCnt < NUM_ENEMY; nCnt++)
		{
			pEnemy = GetEnemy(nCnt);
			if (pEnemy->bUsed)
			{
				pEnemy->bUsed = CheckContactCTB(pEnemy->pEnemyBody, g_player.pPlayerBody);
				if (!pEnemy->bUsed)
				{
					SetVerTexExplosion(pEnemy);
					PlayOneShotSoundEffect( 1 );
				}
				pEnemy = NULL;
			}
		}
	}

	g_player.nframe = (int)GetFrame();
	
}

//--------------------------------------------------------------------------------
//  `揈
//--------------------------------------------------------------------------------
void DrawPlayer(void)
{
	LPDIRECT3DDEVICE9 pDevice = GetDevice();//foCX擾

	//player
	pDevice->SetStreamSource(
		0,//Xg[ԍ
		g_player.pVtxBuffer,
		0,//ItZbgiJnʒuj
		sizeof(VERTEX_2D));//XgCh

	//_tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	//Texture̐ݒ
	pDevice->SetTexture(0, g_player.pTexture);

	//v~eBu`
	pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,
		0,//ItZbgi_j
		NUM_POLYGON);


	// Z̐ݒ
	pDevice -> SetRenderState( D3DRS_BLENDOP , D3DBLENDOP_ADD );
	pDevice -> SetRenderState( D3DRS_SRCBLEND , D3DBLEND_SRCALPHA );
	pDevice -> SetRenderState( D3DRS_DESTBLEND , D3DBLEND_ONE );

	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );

	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );

	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );


	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃



}

//--------------------------------------------------------------------------------
//  _̍쐬
//--------------------------------------------------------------------------------
HRESULT MakeVerTexPlayer(LPDIRECT3DDEVICE9 pDevice)
{
	//player
	if (FAILED(pDevice->CreateVertexBuffer(
		sizeof(VERTEX_2D) * NUM_VERTEX,//쐬_obt@̃TCY
		D3DUSAGE_WRITEONLY,//_obt@̎gp@
		FVF_VERTEX_2D,//ȂĂv
		D3DPOOL_MANAGED,//Ǘ@(managedFfoCXɂC)
		&g_player.pVtxBuffer,//
		NULL//
	)))
	{
		return E_FAIL;
	}

	//zAhX擾邽߂̃|C^
	VERTEX_2D *pVtx;

	//_obt@bNāAzAhX擾
	g_player.pVtxBuffer->Lock(
		0,//͈
		0,//͈
		(void**)&pVtx,//AhXꂽ̃AhX
		0);

	//_W̐ݒi2DWAEj
	//pVtx[0].pos = D3DXVECTOR3(vPlayerPos.x + cosf(fRotation + D3DX_PI + fAngle) * fLength, vPlayerPos.y + sin(fRotation + D3DX_PI + fAngle) * fLength, 0.0f);
	//pVtx[1].pos = D3DXVECTOR3(vPlayerPos.x + cosf(fRotation - fAngle) * fLength, vPlayerPos.y + sinf(fRotation - fAngle) * fLength, 0.0f);
	//pVtx[2].pos = D3DXVECTOR3(vPlayerPos.x + cosf(fRotation - D3DX_PI - fAngle) * fLength, vPlayerPos.y + sinf(fRotation - D3DX_PI - fAngle) * fLength, 0.0f);
	//pVtx[3].pos = D3DXVECTOR3(vPlayerPos.x + cosf(fRotation + fAngle) * fLength, vPlayerPos.y + sinf(fRotation + fAngle) * fLength, 0.0f);

	pVtx[0].pos = D3DXVECTOR3(g_player.vPosCenter.x - PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y - PLAYER_HEIGHT * 0.5f, 0.0f);
	pVtx[1].pos = D3DXVECTOR3(g_player.vPosCenter.x + PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y - PLAYER_HEIGHT * 0.5f, 0.0f);
	pVtx[2].pos = D3DXVECTOR3(g_player.vPosCenter.x - PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y + PLAYER_HEIGHT * 0.5f, 0.0f);
	pVtx[3].pos = D3DXVECTOR3(g_player.vPosCenter.x + PLAYER_WIDTH * 0.5f, g_player.vPosCenter.y + PLAYER_HEIGHT * 0.5f, 0.0f);
	
	//rhw̐ݒ(K1.0f)
	pVtx[0].rhw = 1.0f;
	pVtx[1].rhw = 1.0f;
	pVtx[2].rhw = 1.0f;
	pVtx[3].rhw = 1.0f;

	//_J[̐ݒ(0`255̐l)
	pVtx[0].color = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f);
	pVtx[1].color = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f);
	pVtx[2].color = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f);
	pVtx[3].color = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f);

	//texture_
	pVtx[0].tex = D3DXVECTOR2(0.0f, 0.0f);
	pVtx[1].tex = D3DXVECTOR2(0.2f, 0.0f);
	pVtx[2].tex = D3DXVECTOR2(0.0f, 1.0f);
	pVtx[3].tex = D3DXVECTOR2(0.2f, 1.0f);

	//zAhX
	g_player.pVtxBuffer->Unlock();

	return S_OK;
}