//---------------------------------------------------
//iscore.cppj
//Author : SYUNTA MAKINO
//쐬 : 2016/05/31
//---------------------------------------------------


/*wb_t@C*/
#include "main.h"
#include "score.h"
#include "mouse.h"

/*}N`*/
#define NUM_POLYGON ( 2 )
#define NUM_VERTEX  ( 4 )

#define TEXTURE_NAME "data/TEXTURE/degifont.png"

#define SCORE_DIGIT ( 5 )   //XRǍ
#define SCORE_INIT_POS_X ( 500.0f )   //E[̃XRAXW
#define SCORE_POS_Y ( 5.0f )   //XRAYW
#define SCORE_WIDTH ( 20.0f )   //XRA̕
#define SCORE_HEIGHT ( 45.0f )   //XRA̍
#define SCORE_TX_WIDTH ( 0.2f )   //XRAeNX`̕
#define SCORE_TX_HEIGHT ( 0.5f )   //XRANX`̍

#define BONUS ( 100 )   //{[iX


/*O[oϐ*/
LPDIRECT3DTEXTURE9 g_pTextureScore = nullptr;			//eNX`C^[tF[Xւ̃|C^
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferScore = NULL;		//_obt@ǗC^tF[Xւ̃|C^
int g_nCntScore;   //݂̃XRA\܂ł̃JEg
int g_nCurrentScore;   //݂̃XRA

/*vg^Cv錾*/
void MakeVertexScore( LPDIRECT3DDEVICE9 pDevice );
void SetVertexScore( void );
void ScoreAdd( void );   //XRAZ


//----------------------------
//InitScore֐
//XRȀ
//----------------------------
void InitScore( void )
{
	/*foCX̏擾*/
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	/*eNX`̓ǂݍ*/
	if( FAILED( D3DXCreateTextureFromFile( pDevice , TEXTURE_NAME , &g_pTextureScore ) ) )
	{
		MessageBox( NULL , "eNX`ǂݍ߂܂ł" , "G[" , MB_OK );
	}

	/*XRA̒_̍쐬*/
	MakeVertexScore( pDevice );

	g_nCntScore = 0;
	g_nCurrentScore = 0;   //݂̃XRAIIII
}


//----------------------------
//UninitScore֐
//XRȀI
//----------------------------
void UninitScore( void )
{
	/*g_pTextureScorẻ*/
	SAFE_RELEASE( g_pTextureScore );

	/*g_pVtxBufferScorẻ*/
	SAFE_RELEASE( g_pVtxBufferScore );
}


//----------------------------
//UpdateScore֐
//XRA̍XV
//----------------------------
void UpdateScore( void )
{
	/*XRAZ*/
	ScoreAdd( );

	/*XRA̒_̍XV*/
	SetVertexScore( );
}	


//----------------------------
//DrawScore֐
//XRA̕`
//----------------------------
void DrawScore( void )
{
	int nLoop = 0;   //[vp̕ϐ

	/*foCX̏擾*/
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	/*pCvCq*/
	pDevice -> SetStreamSource( 0 , g_pVtxBufferScore , 0 , sizeof( VERTEX_2D ) );

	//_tH[}bgݒ
	pDevice -> SetFVF( FVF_VERTEX_2D );

	/*XRA̒l̕`*/
	/*eNX`[̓\t*/
	pDevice -> SetTexture( 0 , g_pTextureScore );

	for( nLoop = 0; nLoop < SCORE_DIGIT ; nLoop++ )
	{
		//v~eBu̕`
		pDevice -> DrawPrimitive( D3DPT_TRIANGLESTRIP ,   //v~eBu̎
								  nLoop * 4 ,   //ItZbgi_j
								  NUM_POLYGON );   //v~eBu
	}

}


//----------------------------
//MakeVertexScore֐
//XRA̒_̍쐬
//----------------------------
void MakeVertexScore( LPDIRECT3DDEVICE9 pDevice )
{
	int nLoop = 0;
	int nLoop2 = 0;
	float g_fScorePosXTmp = SCORE_INIT_POS_X;

	VERTEX_2D *pVtx = NULL;   //zAhX擾邽߂̃|C^

	if( FAILED( pDevice -> CreateVertexBuffer( sizeof( VERTEX_2D ) * NUM_VERTEX * SCORE_DIGIT ,   //쐬_obt@̃TCY
											   D3DUSAGE_WRITEONLY ,
											   FVF_VERTEX_2D ,
											   D3DPOOL_MANAGED ,   //Ǘ@ifoCXɂCj
											   &g_pVtxBufferScore ,
											   NULL ) ) )
	{
		/*usvƂԂ*/
	//	return E_FAIL;
	}

	//_obt@bNāAzAhX擾
	g_pVtxBufferScore->Lock( 0 , 0 , ( void **)&pVtx , 0 );

	/*ʂ̃XRA̐ݒ*/
	for( nLoop = 0; nLoop < NUM_VERTEX * SCORE_DIGIT ; nLoop += NUM_VERTEX , nLoop2++ )
	{
		//_W̐ݒ(2DWEE)
		pVtx[ nLoop ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + g_fScorePosXTmp , SCORE_POS_Y , 0.0f );
		pVtx[ nLoop + 1 ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + SCORE_WIDTH + g_fScorePosXTmp , SCORE_POS_Y , 0.0f );
		pVtx[ nLoop + 2 ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + g_fScorePosXTmp , SCORE_POS_Y + SCORE_HEIGHT , 0.0f );
		pVtx[ nLoop + 3 ].pos = D3DXVECTOR3( SCORE_INIT_POS_X + SCORE_WIDTH + g_fScorePosXTmp , SCORE_POS_Y + SCORE_HEIGHT , 0.0f );

		//rhw̐ݒiK1.0fj
		pVtx[ nLoop ].rhw = 1.0f;
		pVtx[ nLoop + 1 ].rhw = 1.0f;
		pVtx[ nLoop + 2 ].rhw = 1.0f;
		pVtx[ nLoop + 3 ].rhw = 1.0f;

		//_J[̐ݒ
		pVtx[ nLoop ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 1 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 2 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );
		pVtx[ nLoop + 3 ].color = D3DCOLOR_RGBA( 255 , 255 , 255 , 255 );

		/*eNX`W̐ݒ*/
		pVtx[ nLoop ].tex =  D3DXVECTOR2( 0.0f , 0.0f );
		pVtx[ nLoop + 1 ].tex =  D3DXVECTOR2( 1.0f , 0.0f );
		pVtx[ nLoop + 2 ].tex =  D3DXVECTOR2( 0.0f , 1.0f );
		pVtx[ nLoop + 3 ].tex =  D3DXVECTOR2( 1.0f , 1.0f );

		/*XWi߂*/
		g_fScorePosXTmp -= SCORE_WIDTH;
	}

	//_obt@̃bN
	g_pVtxBufferScore->Unlock( );
}


//----------------------------
//SetVertexScore֐
//XRA̒_̍쐬
//----------------------------
void SetVertexScore( void )
{
	int nLoop = 0;
	int nValue = 0;
	int nTmp = g_nCntScore;
	D3DXVECTOR2 ScoreTxPos;   //LÕeNX`W
	VERTEX_2D *pVtx = NULL;   //zAhX擾邽߂̃|C^

	//_obt@bNāAzAhX擾
	g_pVtxBufferScore->Lock( 0 , 0 , ( void **)&pVtx , 0 );

	/*_̍XV*/
	for( nLoop = 0; nLoop < NUM_VERTEX * SCORE_DIGIT; nLoop += NUM_VERTEX )
	{
		/*eNX`W̍XV*/
		nValue = nTmp % 10;
		nTmp /= 10;
		ScoreTxPos.x = ( nValue % 5 ) * SCORE_TX_WIDTH;
		ScoreTxPos.y = ( nValue / 5 ) * SCORE_TX_HEIGHT;
		pVtx[ nLoop ].tex = D3DXVECTOR2( ScoreTxPos.x , ScoreTxPos.y );
		pVtx[ nLoop + 1 ].tex = D3DXVECTOR2( ScoreTxPos.x + SCORE_TX_WIDTH , ScoreTxPos.y );
		pVtx[ nLoop + 2 ].tex = D3DXVECTOR2( ScoreTxPos.x , ScoreTxPos.y + SCORE_TX_HEIGHT );
		pVtx[ nLoop + 3 ].tex = D3DXVECTOR2( ScoreTxPos.x + SCORE_TX_WIDTH , ScoreTxPos.y + SCORE_TX_HEIGHT );
	}

	//_obt@̃bN
	g_pVtxBufferScore->Unlock( );
}

//----------------------------
//ScoreAdd֐
//XRAZ
//----------------------------
void ScoreAdd( void )
{

	DIMOUSESTATE2 *Dims = NULL;   //}EXւ̃|C^

	if( g_nCntScore < g_nCurrentScore )
	{
		g_nCntScore+=2;
	}

}

// XRAl̎擾
void SetScore( int point )
{

	// XRAl̉Z
	g_nCurrentScore += point;

}

// XRAl̎擾
int GetScore( void )
{

	return g_nCntScore;

}


