/***************************************************************/
//
//
//		DirectX	[select_input_device.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 08/15
/*---------------------------------------------------------------
Update : 2016/08/15
			select_input_device.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"

#include "select_input_device.h"
#include "input.h"
#include "gamepad.h"
#include "mouse.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	^`
---------------------------------------------------------------*/

// ֐|C^̌^
typedef HRESULT (*pCreateDevice)( HINSTANCE hInstance, HWND hWnd );
typedef void (*MadeFunc)( void );

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

HRESULT InitStandardDevice( HINSTANCE hInstance, HWND hWnd );
void UninitStandardDevice( void );
void UpdateStandardDevice( void );

/*---------------------------------------------------------------
	O[oϐ
---------------------------------------------------------------*/

// AhX
pCreateDevice pInitDevice[] ={
	InitStandardDevice,
	InitGamepad,
};

// IAhX
MadeFunc pUninitDevice[] ={
	UninitStandardDevice,
	UninitGamepad,
};

// XVAhX
MadeFunc pUpdateDevice[] ={
	UpdateStandardDevice,
	UpdateGamepad,
};


DEVICE_SELECTION device = DEVICE_GAMEPAD;			// gpĂfoCX


// foCX̏
void InitInputDevice( HWND hWnd, HINSTANCE hInstance )
{

	// Q[pbh̏
	if( SUCCEEDED( pInitDevice[ DEVICE_GAMEPAD ]( hInstance, hWnd ) ) )
	{	
		//MessageBox( NULL, "Q[pbhŋN܂!" , " INFORMATION " , MB_OK );
		device = DEVICE_GAMEPAD;
		return;
	}

	// X^_[hfoCX̏
	if( SUCCEEDED( pInitDevice[ DEVICE_STANDARD ]( hInstance, hWnd ) ) )
	{	
		//MessageBox( NULL, "X^_[hfoCXŋN܂!" , " INFORMATION " , MB_OK );
		device = DEVICE_STANDARD;
		return;
	}


}

// foCX̏I
void UninitInputDevice( void )
{

	// ݂̃foCX̏I
	pUninitDevice[ device ]( );

}

// foCX̍XV
void UpdateInputDevice( void )
{

	// ݂̃foCX̍XV
	pUpdateDevice[ device ]( );

}

// foCX̃Zbg
HRESULT SetInputDevice( DEVICE_SELECTION deviceNext )
{


	HWND hWnd;					// znh
	HINSTANCE hInstance;		// zCX^X
	POINT point;				// ݂̃nh̍Wł΂悢


	// ݂̃EBhẼ|WVł΂ǂł悢
	point.x = SCREEN_WIDTH/2;
	point.y = SCREEN_HEIGHT/2;


	// nh̎擾		
	hWnd = WindowFromPoint( point );

	// CX^X̎擾
	hInstance =(HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );

	// XṼfoCX
	HRESULT hResult = pInitDevice[ deviceNext ]( hInstance, hWnd );

	if( FAILED( hResult ) ){

		MessageBox( NULL, " foCX܂!!\nxmFĂ蒼Ă " , " DEVICE ERROR !! " , MB_OK | MB_ICONWARNING );
		return E_FAIL;
	}

	// ݂̃foCX̏I
	pUninitDevice[ device ]( );

	// foCX̃`FW
	device = deviceNext;

	return S_OK;

}

// ݎgp̃foCX̎擾
DEVICE_SELECTION GetCurrentDevice( void )
{

	return device;

}

// L[{[h&}EX̏
HRESULT InitStandardDevice( HINSTANCE hInstance, HWND hWnd )
{

	HRESULT hResult;

	// 
	hResult = InitKeyboard( hInstance, hWnd );

	if( FAILED( hResult ) )	{

		return E_FAIL;
	}

	hResult = InitMouse( hInstance, hWnd  );

	if( FAILED( hResult ) ){

		return E_FAIL;
	}

	return S_OK;

}

// L[{[h&}EX̏I
void UninitStandardDevice( void )
{

	// I
	UninitKeyboard( );
	UninitMouse( );

}

// L[{[h&}EX̍XV
void UpdateStandardDevice( void )
{

	// XV
	UpdateKeyboard( );
	UpdateMouse( );

}

