/***************************************************************/
//
//
//		DirectX	[ selectmenu.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 8/24
/*---------------------------------------------------------------
Update : 2016/8/24
			selectmenu.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "select_menu.h"

#include "input.h"
#include "mouse.h"

#include "game_equation.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NUMBER ( 2 )							// eNX`pX

#define NUM_VERTEX  ( 4 )								// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )								// `悷|S

#define START_COORD_X (570)								// \WSX
#define START_COORD_Y (450)								// \ʒuSY
#define END_COORD_X   (720)								// \WEX
#define END_COORD_Y   (500)								// \WEX

typedef int CURENT_TEXTURE;

typedef enum {

	START_GAME = 0,
	OPTION,
	SELECT_MAX

}SELECT_MODE;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

HRESULT MakeVertexSelectMenu( LPDIRECT3DDEVICE9 pDevice );		// _̍쐬
void SetVertexSelectMenuCoord( VERTEX_2D* pVtx, int index );	// _W̐ݒ
void SetVertexSelectMenuSpriteUV( VERTEX_2D* pVtx, int index );	// _UVl̐ݒ
void SetVertexSelectMenuColor( VERTEX_2D* pVtx, int index );	// _F̐ݒ

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureSelectMenu[ TEXTURE_NUMBER ] = { };// eNX`-C^[tF-X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferSelectMenu = nullptr;		// _obt@C^[tF[Xւ̃|C^
CURENT_TEXTURE g_select = START_GAME;							// [h̑I


// SELECTMENȔ
void InitSelectMenu( void )
{

	// t@Cl[萔
	const char* FILE_NAME[ TEXTURE_NUMBER ] = {

		"data/TEXTURE/game_start.png",
		"data/TEXTURE/ranking_logo.png"
	};

	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexSelectMenu( pDevice );

	
	for( int index = 0; index < TEXTURE_NUMBER ; index++ ){

		// eNX`̓ǂݍ 
		if( FAILED( D3DXCreateTextureFromFile( pDevice, FILE_NAME[ index ], &g_pTextureSelectMenu[ index ] )))
		{
			#ifdef _DEBUG
			MessageBox( NULL, "SELECTMENUeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
			#endif	// _DEBUG
		}
	
	}


}

// SELECTMENȔI
void UninitSelectMenu( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE( g_pTextureSelectMenu[0] )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( g_pVtxBufferSelectMenu )

}

// SELECTMENU̍XV
void UpdateSelectMenu( void )
{

	VERTEX_2D *pVtx;										// zAhX

	D3DXVECTOR2 point = D3DXVECTOR2( GetMouseX(),   GetMouseY()   );
	D3DXVECTOR2 obj_start = D3DXVECTOR2( START_COORD_X, START_COORD_Y );
	D3DXVECTOR2 obj_end   = D3DXVECTOR2( END_COORD_X,   END_COORD_Y   );
	D3DXVECTOR2 obj_start2 = D3DXVECTOR2( START_COORD_X + 70 , START_COORD_Y + 70 );
	D3DXVECTOR2 obj_end2   = D3DXVECTOR2( END_COORD_X + 70   , END_COORD_Y + 70   );


	// [hXV
	if( __ObjectTouchSquare( &obj_start, &obj_end, &point ) ){
	
		g_select--;
		g_select = LIMIT_MIM( g_select, 0 );

	}
	else if(  __ObjectTouchSquare( &obj_start2, &obj_end2, &point ) ){
	
		g_select++;
		g_select = LIMIT_MAX( g_select, SELECT_MAX-1 );

	}


	// obt@bNzAhX擾
	g_pVtxBufferSelectMenu -> Lock( 0, 0, (void**)&pVtx, 0 );

	
	// _obt@̐ݒ
	for( int index = 0; index < TEXTURE_NUMBER; index++ ){

		// _W̐ݒ
		//SetVertexSelectMenuCoord( pVtx );

		// _UVl̐ݒ
		//SetVertexSelectMenuSpriteUV( pVtx );

		// _F̐ݒ
		SetVertexSelectMenuColor( pVtx, index );

		// rhw̐ݒ
		//pVtx[0].rhw = 1.0f;
		//pVtx[1].rhw = 1.0f;
		//pVtx[2].rhw = 1.0f;
		//pVtx[3].rhw = 1.0f;


	}// SetVertex -> END 
	

	g_pVtxBufferSelectMenu ->Unlock( );


}

// SELECTMENU̕`
void DrawSelectMenu( void )
{


	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferSelectMenu,							// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_2D ));							// ̃XgChl(oCgP)


	// _tH[}bg̐ݒ
	pDevice ->SetFVF( FVF_VERTEX_2D );


	for( int index = 0; index < TEXTURE_NUMBER ; index++ ){

		// eNX`̐ݒ
		pDevice ->SetTexture( 0, g_pTextureSelectMenu[ index ] );


		// |S̕`
		pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, ( index * NUM_VERTEX ), NUM_POLYGON );

		if( index == g_select ){
		

			// Z̐ݒ
			pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );			//
			pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
			pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );			//̃

			pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, ( index * NUM_VERTEX ), NUM_POLYGON );

			// ̏Ԃɖ߂
			pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
			pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
			pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃


		}

	}


}

// _̍쐬
HRESULT MakeVertexSelectMenu( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;											// zAhX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_2D ) * NUM_VERTEX * TEXTURE_NUMBER,	// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,									// gp@
			FVF_VERTEX_2D,										// gp钸_tH[}bg
			D3DPOOL_MANAGED,									// obt@̊Ǘ@
			&g_pVtxBufferSelectMenu,							// i[|C^
			NULL )))
	{

		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " SELECTMENU VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return E_FAIL;

	}


	// zAhX̎擾
	g_pVtxBufferSelectMenu -> Lock( 0, 0, (void**)&pVtx, 0 );


	// _obt@̐ݒ
	for( int index = 0; index < TEXTURE_NUMBER ; index++ ){


		// _W̐ݒ
		SetVertexSelectMenuCoord( pVtx, index );


		// _UVl̐ݒ
		SetVertexSelectMenuSpriteUV( pVtx, index );


		// _F̐ݒ
		SetVertexSelectMenuColor( pVtx, index );

		// rhw̐ݒ
		pVtx[ 0 + ( NUM_VERTEX * index ) ].rhw = 1.0f;
		pVtx[ 1 + ( NUM_VERTEX * index ) ].rhw = 1.0f;
		pVtx[ 2 + ( NUM_VERTEX * index ) ].rhw = 1.0f;
		pVtx[ 3 + ( NUM_VERTEX * index ) ].rhw = 1.0f;

	}


	// obt@̃AbN
	g_pVtxBufferSelectMenu ->Unlock( );

	return S_OK;


}

// _W̐ݒ
void SetVertexSelectMenuCoord( VERTEX_2D* pVtx, int index )
{


	D3DXVECTOR2 start,end;				// n_ƏI_	
	const int TEXTURE_PADDING = 70;		// eNX`Ԋu

	
	// W̐ݒ
	start.x = START_COORD_X;
	start.y = START_COORD_Y + ( TEXTURE_PADDING * index );
	end.x   = END_COORD_X;
	end.y   = END_COORD_Y + ( TEXTURE_PADDING * index );


	// W̏
	pVtx[ 0 + ( NUM_VERTEX * index ) ].pos=D3DXVECTOR3( start.x, start.y, 0.0f );
	pVtx[ 1 + ( NUM_VERTEX * index ) ].pos=D3DXVECTOR3( end.x  , start.y, 0.0f );
	pVtx[ 2 + ( NUM_VERTEX * index ) ].pos=D3DXVECTOR3( start.x, end.y  , 0.0f );
	pVtx[ 3 + ( NUM_VERTEX * index ) ].pos=D3DXVECTOR3( end.x  , end.y  , 0.0f );
	

}

// _UVl̐ݒ
void SetVertexSelectMenuSpriteUV( VERTEX_2D* pVtx, int index )
{


	const unsigned int TEXTURE_SHEETS_U = 1;		// eNX`Aj[V
	const unsigned int TEXTURE_SHEETS_V = 1;		// eNX`cAj[V
	const unsigned int FPS = 1 ;					// t[p[ZJh(҂)
	const float TEXTURE_U = 1.0f / TEXTURE_SHEETS_U;// eNX` U l萔
	const float TEXTURE_V = 1.0f / TEXTURE_SHEETS_V;// eNX` V l萔
	float TexU = 0,TexV = 0;						// eNX`UVľvZɎgp
	static unsigned int animationFrame;				// Aj[Vt[



	// UVľvZ
	TexU = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_U ) * TEXTURE_U;
	TexV = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_V ) * TEXTURE_V;


	// _UVl̏
	pVtx[ 0 + ( NUM_VERTEX * index ) ].tex = D3DXVECTOR2( TexU            , TexV );
	pVtx[ 1 + ( NUM_VERTEX * index ) ].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV );
	pVtx[ 2 + ( NUM_VERTEX * index ) ].tex = D3DXVECTOR2( TexU            , TexV + TEXTURE_V );
	pVtx[ 3 + ( NUM_VERTEX * index ) ].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV + TEXTURE_V );


	// Aj[Vt[̍XV
	animationFrame ++;


}

// _F̐ݒ
void SetVertexSelectMenuColor( VERTEX_2D* pVtx, int index )
{


	static D3DXCOLOR vertexColor = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f );	// _F

	static float transitionColor = 0.5f;
	static bool frag = true;


	// _F̍XV
	vertexColor.r = transitionColor; 
	vertexColor.g = transitionColor; 
	vertexColor.b = transitionColor; 
	//vertexColor.a -= 0.1f; 
	


	// _F̏
	pVtx[ 0 + ( NUM_VERTEX * index ) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 1 + ( NUM_VERTEX * index ) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 2 + ( NUM_VERTEX * index ) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 3 + ( NUM_VERTEX * index ) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );


	if( transitionColor >= 1.0f ){
	
		frag = false;
	}

	if( frag ){
		
		transitionColor += 0.005f;
	}
	else{
	
		transitionColor -= 0.005f;

		if( transitionColor <= 0.3f ){
	
			frag = true;
		}

	}

}

// ݑIĂ郂[h
int GetSelect( void )
{

	return g_select;

}

