/***************************************************************/
//
//
//		DirectX	[sound.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 06/15
/*---------------------------------------------------------------
Update : 2016/06/15
			sound.cpp̍쐬

Update : 2016/06/16
			TEhfoCXȉ
			TEh̐ݒ
			TEh̋zo
			ǉ

Update : 2016/08/07
            {[̕ύX
			Play,Stop֐̎

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "sound.h"

#include "input.h"
#include "game_equation.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

/*
// Audio_number ̒`
typedef enum{

	AUDIO_TITLE = 0,

	MAX_AUDIO,

}AUDIO_NUMBER;

// SoundEffect_number ̒`
typedef enum{

	SE_TITLE = 0,

	MAX_AUDIO,

}SE_NUMBER;
*/

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define AUDIO_MAX ( 3 )			// őbgm
#define SE_MAX ( 6 )			// őSE

#define START_VOLUME ( -1000 )	// {[l

// bgmt@Cl[萔
const char* AUDIO_FILE_NAME [ AUDIO_MAX ] = {

	// TITLE 
	"data\\AUDIO\\bgm\\title.wav",
	// GAME
	"data\\AUDIO\\bgm\\game.wav",
	// RESULT
	"data\\AUDIO\\bgm\\result.wav",

};

//  soundeffectt@Cl[萔
const char* SE_FILE_NAME [ SE_MAX ] = {

	// TITLE
	"data\\AUDIO\\sound_effect\\enter.wav",
	// GAME
	"data\\AUDIO\\sound_effect\\delet.wav",
	"data\\AUDIO\\sound_effect\\frameenter.wav",
	"data\\AUDIO\\sound_effect\\goal.wav",
	// RESULT
	"data\\AUDIO\\sound_effect\\seremony.wav",
	"data\\AUDIO\\sound_effect\\failed.wav",

};

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

HRESULT CreatePrimaryBuffer( void );			// vC}obt@̍쐬
HRESULT CreateSoundBuffer(						// ZJ_obt@̍쐬
	LPDIRECTSOUNDBUFFER *dsb,					// >> TEhobt@̃|C^
	const char *file );							// >> t@C( t@Cl[萔 )

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

// O[oϐ
LPDIRECTSOUND8      lpDS      = nullptr;					// DirectSound8̃|C^
LPDIRECTSOUNDBUFFER lpPrimary = nullptr;					// vC}TEhobt@
LPDIRECTSOUNDBUFFER lpSecondary[ AUDIO_MAX ] = { nullptr };	// ZJ_TEhobt@
LPDIRECTSOUNDBUFFER lpSoundEffectBuf[ SE_MAX ] = { nullptr };// ZJ_TEhobt@
LONG volume = START_VOLUME;									// {[l


#if 0

IDirectSound8 *pDS8;							//TEhfoCX̃|C^
DSBUFFERDESC DSBufferDesc;
IDirectSoundBuffer *ptmpBuf = nullptr;
IDirectSoundBuffer8 *pDSBuffer=nullptr;

LPDIRECTSOUNDBUFFER pDsb = NULL;
  HRESULT hr; 

//TEh̏
HRESULT InitSound( HWND hWnd )
{

	char *pData;			//g`f[^i[pobt@

	//TEhfoCX쐬
	DirectSoundCreate8(NULL, &pDS8, NULL);

	//xݒ
	pDS8->SetCooperativeLevel( hWnd, DSSCL_NORMAL );
	  // WAV tH[}bg̍\̂ZbgAbvB

	//WAVEFORMATDISC\
	WAVEFORMATEX wFmt={};

	memset(&wFmt, 0, sizeof(WAVEFORMATEX)); 
	wFmt.wFormatTag = WAVE_FORMAT_PCM;
	wFmt.nChannels = 2;
	wFmt.nSamplesPerSec = 44100;
	wFmt.wBitsPerSample = 16;
	wFmt.nBlockAlign = wFmt.nChannels;
	wFmt.nAvgBytesPerSec = wFmt.nSamplesPerSec * wFmt.nBlockAlign;
	wFmt.cbSize = 0;
 
  // DSBUFFERDESC \̂ZbgAbvB
 
  memset(&DSBufferDesc, 0, sizeof(DSBUFFERDESC)); 
  DSBufferDesc.dwSize = sizeof(DSBUFFERDESC); 
  DSBufferDesc.dwFlags = 
    DSBCAPS_CTRLPAN | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY; 
  DSBufferDesc.dwBufferBytes = 3 * wFmt.nAvgBytesPerSec; 
  DSBufferDesc.lpwfxFormat = &wFmt; 
 
  // obt@쐬B
 
  hr = pDS8->CreateSoundBuffer(&DSBufferDesc, &pDsb, NULL); 
  if (SUCCEEDED(hr)) 
  { 
     hr = pDsb->QueryInterface(IID_IDirectSoundBuffer8, (LPVOID*) ptmpBuf);
     pDsb->Release();
  } 
	//ZJ_obt@̍쐬
	//IDirectSoundBuffer8 *pDSBuffer;
	//pDS8 ->CreateSoundBuffer( &DSBufferDesc, &ptmpBuf, NULL );
	//ptmpBuf ->QueryInterface( IID_IDirectSoundBuffer8 ,(void**)&pDSBuffer);
	//ptmpBuf->Release( );

	//t@CI[v
	HMMIO hMmio = NULL;
	MMIOINFO mmioInfo;

	//wavet@CI[v
	memset( &mmioInfo, 0, sizeof(MMIOINFO) );
	hMmio = mmioOpen( "lastbgm.wav", &mmioInfo, MMIO_READ );
	if( !hMmio ){
		MessageBox( NULL, "WaveFILẼI[vɎs܂!!", "file open ERROR!!", MB_OK );
		return E_FAIL;
	}
	else{
	
		//RIFF`NT[`
		MMRESULT mmRes;
		MMCKINFO riffChunk;

		riffChunk.fccType = mmioFOURCC('W', 'A', 'V', 'E');
		mmRes = mmioDescend( hMmio, &riffChunk, NULL, MMIO_FINDRIFF );
		if( mmRes != MMSYSERR_NOERROR ){

			mmioClose( hMmio, 0 );
			#ifdef _DEBUG
			MessageBox( NULL, "RIFF`ÑT[`Ɏs܂!!", "RIFF`NT[`ERROR", MB_OK );
			#endif
			return E_FAIL;
		}

		//tH[}bg`NT[`
		MMCKINFO formatChunk;
		
		formatChunk.ckid = mmioFOURCC('f', 'm', 't', ' ');
		mmRes = mmioDescend( hMmio, &formatChunk, &riffChunk, MMIO_FINDCHUNK );
		if( mmRes != MMSYSERR_NOERROR ){

			mmioClose( hMmio, 0 );
			#ifdef _DEBUG
			MessageBox( NULL, "tH[}bg`ÑT[`Ɏs܂!!", "fmt`NT[`ERROR", MB_OK );
			#endif
			return E_FAIL;
		}

		//WAVEFORMATEX\̊i[
		DWORD fmsize = formatChunk.cksize;
		DWORD size = mmioRead( hMmio, (HPSTR)&wFmt, fmsize );
		if( size != fmsize ){

			mmioClose( hMmio, 0 );
			#ifdef _DEBUG
			MessageBox( NULL, "tH[}bg`ÑT[`Ɏs܂!!", "fmt`NT[`ERROR", MB_OK );
			#endif
			return E_FAIL;


		}

		//fmt->RIFF`Nֈړ
		mmioAscend( hMmio, &formatChunk, 0 );


		//f[^`NT[`
		MMCKINFO dataChunk;
		dataChunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
		mmRes = mmioDescend( hMmio, &dataChunk, &riffChunk, MMIO_FINDCHUNK );
		if( mmRes != MMSYSERR_NOERROR ){

			mmioClose( hMmio, 0 );
			#ifdef _DEBUG
			MessageBox( NULL, "f[^`ÑT[`Ɏs܂!!", "f[^`NT[`ERROR", MB_OK );
			#endif
			return E_FAIL;
		}
	
		//TEhf[^i[
		pData = new char[ dataChunk.cksize ];
		size = mmioRead( hMmio, (HPSTR)pData, dataChunk.cksize );
		if( size != dataChunk.cksize ){
			
			delete[] pData;
			#ifdef _DEBUG
			MessageBox( NULL, "TEhf[^̊i[Ɏs܂!!", "TEhf[^ERROR", MB_OK );
			#endif
			return E_FAIL;
		}

		//t@CN[Y
		mmioClose( hMmio, 0 );

	}

	/*
	//DSBUFFERDESC\
	DSBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	DSBufferDesc.dwFlags = 0;
	DSBufferDesc.dwBufferBytes =
			wFmt.nSamplesPerSec *
			wFmt.wBitsPerSample *
			wFmt.nChannels *
			m_dwTime;
	DSBufferDesc.dwReserved = 0;
	DSBufferDesc.lpwfxFormat = &wFmt;
	DSBufferDesc.guid3DAlgorithm = GUID_NULL;
	*/

	/* bN */
	//ZJ_obt@Wavef[^
	LPVOID lpvWrite = 0;
	DWORD  dwLength = 0;
	if( DS_OK == ptmpBuf -> Lock( 0, 0, &lpvWrite, &dwLength, NULL, NULL, DSBLOCK_ENTIREBUFFER ) ){
		
		memcpy( lpvWrite, pData, dwLength );
		pDSBuffer ->Unlock( lpvWrite, dwLength, NULL, 0 );
	}


	delete[] pData;

	return S_OK;

}
//TEh̏I
void UninitSound( void )
{

	//TEhfoCX|C^̉
	SAFE_RELEASE( pDS8 )

}

#else

// TEhfoCX̏
HRESULT InitWaveSound( HWND hWnd )
{
    HRESULT ret;

    // COM̏
    CoInitialize( NULL );

    // DirectSound8쐬
    ret = DirectSoundCreate8( NULL,&lpDS,NULL );
    if( FAILED(ret) ) {
        return E_FAIL;
    }

    // [h
    ret = lpDS->SetCooperativeLevel( hWnd, (DSSCL_EXCLUSIVE | DSSCL_PRIORITY) );
    if( FAILED(ret) ) {
        return E_FAIL;
    }


	// vC}obt@̐ݒ
	CreatePrimaryBuffer( );

	// ZJhobt@̍쐬
	for( int index = 0; index < AUDIO_MAX; index++ ){

		CreateSoundBuffer( &lpSecondary[ index ],     AUDIO_FILE_NAME[ index ] );
	}
	
	for( int index = 0; index < SE_MAX ; index++ ){

		CreateSoundBuffer( &lpSoundEffectBuf[ index ], SE_FILE_NAME[ index ] );
	}

	/*
	CreateSoundBuffer( lpSecondary,     AUDIO_FILE_NAME[ 0 ] );
	CreateSoundBuffer( &lpSecondary[ 1 ],     AUDIO_FILE_NAME[ 1 ] );
	CreateSoundBuffer( &lpSecondary[ 2 ],     AUDIO_FILE_NAME[ 2 ] );
	CreateSoundBuffer( &lpSecondary[ 3 ],     AUDIO_FILE_NAME[ 3 ] );
	CreateSoundBuffer( &lpSecondary[ 4 ],     AUDIO_FILE_NAME[ 4 ] );
	CreateSoundBuffer( &lpSecondary[ 5 ],     AUDIO_FILE_NAME[ 5 ] );
	CreateSoundBuffer( &lpSecondary[ 6 ],     AUDIO_FILE_NAME[ 6 ] );
	CreateSoundBuffer( &lpSecondary[ 7 ],     AUDIO_FILE_NAME[ 7 ] );
	*/

	return S_OK;

}

// TEhfoCX̊J
void UninitSound( void )
{

	// -- ZJ_obt@̉ --

	// Audio SecondaryBuffer
	for( int index = 0 ; index < AUDIO_MAX ; index++ ){
		
		SAFE_RELEASE( lpSecondary[ index ] )
	}

	// Sound effect SecondaryBuffer
	for( int index = 0 ; index < SE_MAX ; index++ ){
		
		SAFE_RELEASE( lpSoundEffectBuf[ index ] )
	}

	// vC}obt@̉
	SAFE_RELEASE( lpPrimary )

	// TEhfoCX̉
	SAFE_RELEASE( lpDS )


    // COM̏I
    CoUninitialize( );
}

// vC}TEhobt@̍쐬
HRESULT CreatePrimaryBuffer( void )
{


    HRESULT ret;
    WAVEFORMATEX wf;

    // vC}TEhobt@̍쐬
    DSBUFFERDESC dsdesc;
    ZeroMemory( &dsdesc,sizeof(DSBUFFERDESC) );
    dsdesc.dwSize           = sizeof( DSBUFFERDESC );
    dsdesc.dwFlags          = DSBCAPS_PRIMARYBUFFER | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLPAN;
    dsdesc.dwBufferBytes    = 0;
    dsdesc.lpwfxFormat      = NULL;
    ret = lpDS->CreateSoundBuffer( &dsdesc,&lpPrimary,NULL );
    if( FAILED(ret) ) {
        return E_FAIL;
    }

    // vC}obt@̃Xe[^X
    wf.cbSize = sizeof( WAVEFORMATEX );
    wf.wFormatTag           = WAVE_FORMAT_PCM;
    wf.nChannels            = 2;
    wf.nSamplesPerSec       = 44100;
    wf.wBitsPerSample       = 16;
    wf.nBlockAlign          = wf.nChannels * wf.wBitsPerSample / 8;
    wf.nAvgBytesPerSec      = wf.nSamplesPerSec * wf.nBlockAlign;
    ret = lpPrimary->SetFormat( &wf );
    if( FAILED(ret) ) {
        return E_FAIL;
    }

    return S_OK;
}

// ZJ_obt@̍쐬
HRESULT CreateSoundBuffer( LPDIRECTSOUNDBUFFER *dsb, const char *file )
{

    HRESULT ret;
    MMCKINFO mSrcWaveFile;
    MMCKINFO mSrcWaveFmt;
    MMCKINFO mSrcWaveData;
    LPWAVEFORMATEX wf;


    // WAVt@C[h
    HMMIO hSrc;
    hSrc = mmioOpen( (LPSTR)file,NULL,MMIO_ALLOCBUF|MMIO_READ|MMIO_COMPAT );
    if( !hSrc ) {
		
		MessageBox( NULL, " audio file error!! ", " AUDIO FILE ERROR ", MB_OK );
        return E_FAIL;
    }

    // 'WAVE'`N`FbN
    ZeroMemory( &mSrcWaveFile,sizeof(mSrcWaveFile) );
    ret = mmioDescend( hSrc,&mSrcWaveFile,NULL,MMIO_FINDRIFF );
    if( mSrcWaveFile.fccType!=mmioFOURCC('W','A','V','E') ) {
        mmioClose( hSrc,0 );
        return E_FAIL;
    }

    // 'fmt '`N`FbN
    ZeroMemory( &mSrcWaveFmt,sizeof(mSrcWaveFmt) );
    ret = mmioDescend( hSrc, &mSrcWaveFmt, &mSrcWaveFile, MMIO_FINDCHUNK );
    if( mSrcWaveFmt.ckid!=mmioFOURCC('f','m','t',' ') ) {
        mmioClose( hSrc, 0 );
        return E_FAIL;
    }

    // wb_TCY̌vZ
    int iSrcHeaderSize = mSrcWaveFmt.cksize;
    if( iSrcHeaderSize<sizeof(WAVEFORMATEX) )
        iSrcHeaderSize=sizeof(WAVEFORMATEX);

    // wb_m
    wf = (LPWAVEFORMATEX)malloc( iSrcHeaderSize );
    if( !wf ) {
        mmioClose( hSrc,0 );
        return E_FAIL;
    }
    ZeroMemory( wf, iSrcHeaderSize );

    // WAVEtH[}bg̃[h
    ret = mmioRead( hSrc,(char*)wf, mSrcWaveFmt.cksize );
    if( FAILED(ret) ) {
        free( wf );
        mmioClose( hSrc, 0 );
        return E_FAIL;
    }


    // fmt`Nɖ߂
    mmioAscend( hSrc, &mSrcWaveFmt, 0 );

    // data`NT
    while(1) {

        // 
        ret = mmioDescend( hSrc, &mSrcWaveData, &mSrcWaveFile, 0 );
        if( FAILED(ret) ) {
            free( wf );
            mmioClose( hSrc, 0 );
            return E_FAIL;
        }
        if( mSrcWaveData.ckid==mmioStringToFOURCCA( "data", 0 ) )
            break;
        // ̃`N
        ret = mmioAscend( hSrc, &mSrcWaveData, 0 );

    }


    // TEhobt@̍쐬
    DSBUFFERDESC dsdesc;
    ZeroMemory( &dsdesc,sizeof(DSBUFFERDESC) );
    dsdesc.dwSize = sizeof( DSBUFFERDESC );
    dsdesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_STATIC | DSBCAPS_LOCDEFER | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLPAN;
    dsdesc.dwBufferBytes = mSrcWaveData.cksize;
    dsdesc.lpwfxFormat = wf;
    dsdesc.guid3DAlgorithm = DS3DALG_DEFAULT;
    ret = lpDS->CreateSoundBuffer( &dsdesc, dsb,NULL );
    if( FAILED(ret) ) {
        free( wf );
        mmioClose( hSrc, 0 );
        return E_FAIL;
    }

    // bNJn
    LPVOID pMem1,pMem2;
    DWORD dwSize1,dwSize2;
    ret = (*dsb)->Lock( 0, mSrcWaveData.cksize, &pMem1, &dwSize1, &pMem2, &dwSize2, 0 );
    if( FAILED(ret) ) {
        free( wf );
        mmioClose( hSrc, 0 );
        return E_FAIL;
    }

    // f[^
    mmioRead( hSrc, (char*)pMem1, dwSize1 );
    mmioRead( hSrc, (char*)pMem2, dwSize2 );

    // bN
    (*dsb)->Unlock( pMem1, dwSize1, pMem2, dwSize2 );

    // wb_pJ
    free( wf );

    // WAVE
    mmioClose( hSrc, 0 );

    return S_OK;

}

// TEhobt@̍쐬( Audio )
HRESULT SetAudio( int index )
{

	HRESULT hResult;

	// TEhobt@̍쐬
	hResult = CreateSoundBuffer( &lpSecondary[ index ],     AUDIO_FILE_NAME[ index ] );

	if( FAILED( hResult ) ){

		MessageBox( NULL, "create Audio error!!" , " Sound Error!! " , MB_OK );
		SAFE_RELEASE( lpSecondary[ index ] )
		
		return E_FAIL;
	}

	return S_OK;

}

// TEhobt@̏( Audio )
void DeleteAudio( int index )
{

	SAFE_RELEASE( lpSecondary[ index ] )

}

// TEhobt@̍쐬( Sound effect )
HRESULT SetSoundEffect( int index )
{

	HRESULT hResult;

	// TEhobt@̍쐬
	hResult = CreateSoundBuffer( &lpSoundEffectBuf[ index ],     AUDIO_FILE_NAME[ index ] );

	if( FAILED( hResult ) ){

		MessageBox( NULL, "create SE error!!" , " Sound Error!! " , MB_OK );
		SAFE_RELEASE( lpSoundEffectBuf[ index ] )	
		
		return E_FAIL;
	}

	return S_OK;

}

// TEhobt@̏( Sound effect )
void DeleteSoundEffect( int index )
{

	SAFE_RELEASE( lpSoundEffectBuf[ index ] )

}

// TEh̍Đ
void PlaySound( int bufNumber , bool loopflag )
{

	// ݂̃{[ɐݒ
	SetVolume( bufNumber, 0 );

	// wave̍Đ
	lpSecondary[ bufNumber ] ->Play( 0, 0, loopflag );

}

// TEh̒~
void StopSound( int bufNumber )
{

	// wavet@C̒~
	lpSecondary[ bufNumber ] ->Stop( );

	// Đʒu
	lpSecondary[ bufNumber ] ->SetCurrentPosition( 0 );

}

// TEhGtFNg̍Đ
void PlayOneShotSoundEffect( int bufNumber )
{

	// ݂̃{[ɐݒ
	SetVolume( bufNumber, 0 );

	// SE̍Đ
	lpSoundEffectBuf[ bufNumber ] ->Play( 0, 0, 0 );

}

// TEhGtFNg̒~
void StopOneShotSoundEffect( int bufNumber )
{

	// wavet@C̒~
	lpSoundEffectBuf[ bufNumber ] ->Stop( );

	// Đʒu
	lpSoundEffectBuf[ bufNumber ] ->SetCurrentPosition( 0 );

}

// {[̒
void SetVolume( int bufNumber, LONG value )
{

	// {[̍XV
	volume += value;

	// őŏl̐ݒ
	volume = LIMIT_MAX( volume,    0   );
	volume = LIMIT_MIM( volume, -10000 );

	// {[̃Zbg
	lpSecondary[ bufNumber ] ->SetVolume( volume );

}

// {[̕ύX
void ControlVolume( int bufNumber )
{

	// {[̕ύX
	if( GetKeyboardPress( DIK_UP ) ){
	
		SetVolume( bufNumber, 10 );
	}
	else if( GetKeyboardPress( DIK_DOWN ) ){
	
		SetVolume( bufNumber, -10 );
	}

}



#endif 

