/***************************************************************/
//
//
//		DirectX	[staff_roll.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 08/07
/*---------------------------------------------------------------
Update : 2016/08/07
				staff_roll.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "staff_roll.h"
#include "backbuffer.h"

#include "staff_roll_text.h"					// cppt@CȊOł͓ǂݍ܂Ȃ

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define ENDING_POS_X (0)						// ED ̕\ʒuX
#define ENDING_POS_Y (0)						// ED ̕\ʒuY
#define ENDING_WIDTH (SCREEN_WIDTH)				// ED ̕
#define ENDING_HEIGHT (SCREEN_HEIGHT)			// ED ̍

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexStaffRoll(LPDIRECT3DDEVICE9 pDevice);
												// _̍쐬
void SetVertexStaffRoll( VERTEX_2D *pVtx, int indexNumber );
												// W̐ݒ
void TransitionColor( VERTEX_2D *pVtx, int indexNumber );
												// _F̐ݒ
/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9* g_pTextureStaffRoll = { nullptr };			// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferStaffRoll = nullptr;		// _obt@C^[tF[Xւ̃|C^
														
LPD3DXFONT g_pStaffRollFont = nullptr;							// tHgC^[tF[X̃|C^

int CREATE_TEXTURE_NUMBER = 1;								// 쐬eNX`̐
float scroll;											 	// XN[l


// ED ̏
void InitStaffRoll( void )
{

	LPDIRECT3DDEVICE9 pDevice = nullptr;					// foCX󂯎p֐
	IDirect3DSurface9* pBackbuf = GetBackbuf( );			// obNobt@|C^i[
	RECT rect = { 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT };		// `͈
	const int FONT_HEIGHT = 22;								// tHgy(c)̃TCY
	const int MAX_CHAR = strlen( staff_roll );				// ő啶
	const int line = SCREEN_HEIGHT / FONT_HEIGHT;			// PʃeNX`ɕ`łs̎Zo
	int returnTexture[ 256 ] = {};							// eNX`܂Ԃio[i[{bNX( 256eNX`Α͂ )
	int enterCount = 0;										// s̉񐔂JEg
	IDirect3DSurface9** surfaceStaffRollroll = { nullptr };	// eNX`T[tFX

	// foCX̎󂯎
	pDevice = GetDevice( );


	// s̎ZoƃeNX`܂Ԃio[̊i[
	for( int inc = 0, returnCount = 1 ; inc < MAX_CHAR ; inc++  ){
	
		if( staff_roll[ inc ] == '\n' ){
			enterCount++;

			// eNX`܂Ԃio[i[{bNXւ̃io[i[
			if( ( enterCount % line )== 0 ){
				
				returnTexture[ returnCount ] = inc;
				returnCount++;
			}
		}
	}

	// 쐬eNX`̐
	CREATE_TEXTURE_NUMBER = ( enterCount / line ) + 1 ;


	// 쐬eNX`C^[tF[X쐬
	g_pTextureStaffRoll  = new LPDIRECT3DTEXTURE9[ CREATE_TEXTURE_NUMBER ];
	surfaceStaffRollroll = new IDirect3DSurface9*[ CREATE_TEXTURE_NUMBER ];

	
	// GfBO[eNX`̍쐬
	for( int inc = 0; inc < CREATE_TEXTURE_NUMBER ; inc++ ){

		pDevice->CreateTexture(
			SCREEN_WIDTH, SCREEN_HEIGHT,
			1,
			D3DUSAGE_RENDERTARGET,
			D3DFMT_A8R8G8B8,
			D3DPOOL_DEFAULT,
			&g_pTextureStaffRoll[ inc ],
			NULL
		);	

		g_pTextureStaffRoll[ inc ] ->GetSurfaceLevel( 0, &surfaceStaffRollroll[ inc ] );

	}


	// tHg̍쐬
	D3DXCreateFont( pDevice, FONT_HEIGHT,0,0,0,FALSE,
	SHIFTJIS_CHARSET,
	OUT_DEFAULT_PRECIS,
	DEFAULT_QUALITY,
	DEFAULT_PITCH,
	"terminal", &g_pStaffRollFont );



	// `̊Jn
	if( SUCCEEDED( pDevice->BeginScene() ) )
	{

		// eNX`̐
		for( int inc = 0; inc < CREATE_TEXTURE_NUMBER ; inc++ ){

			// _O^[QbgeNX`ɕύX
			pDevice->SetRenderTarget( 0 , surfaceStaffRollroll[ inc ] );


			// T[tFCX̃NA
			pDevice->Clear(0,								// NA`̈̐
				NULL,										// `̈
				D3DCLEAR_TARGET								// _O^[QbgƐ[xobt@NA 
				| D3DCLEAR_ZBUFFER							// [x
				| D3DCLEAR_STENCIL,							// XeVl̃NA
				D3DCOLOR_RGBA( 0, 0, 0, 0 ),				// Fɓx100%ɃNA
				1.0f,										// Zobt@̃NAl
				0											// XeVobt@̃NAl
			);					

			// GfBO[̕`揈
			g_pStaffRollFont ->DrawText( NULL, &staff_roll[ 0 + ( returnTexture[ inc ] ) ], -1, &rect, DT_CENTER, D3DCOLOR_RGBA( 255, 255, 0, 255) );

		}

		// _O^[QbgobNobt@ɕύX
		pDevice->SetRenderTarget( 0 , pBackbuf );

		// `I
		pDevice->EndScene( );

	}

	// VERTEX_2D̐ݒ
	MakeVertexStaffRoll( pDevice );

	// XN[l̏
	scroll = 0.0f;

	// eNX`T[tFX̊J
	SAFE_RELEASE( surfaceStaffRollroll[ 0 ] )

	// tHg̊J
	SAFE_RELEASE( g_pStaffRollFont )

}

// ED ̏I
void UninitStaffRoll( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE( g_pTextureStaffRoll[ 0 ] )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferStaffRoll)

}

// ED ̍XV
void UpdateStaffRoll( void )
{

	VERTEX_2D *pVtx;									// zAhX


	// obt@bNzAhX擾
	g_pVtxBufferStaffRoll -> Lock(0,0,(void**)&pVtx,0);		// GPUVRAMւ̑bN

	for( int inc = 0; inc < CREATE_TEXTURE_NUMBER ; inc++ ){

		// W̐ݒ
		SetVertexStaffRoll( pVtx, inc );

	}

	/*
	// UVAj[V
	// UVAj[VQlXN[l( 0.001f )
	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f + scroll );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f + scroll );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f + scroll );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f + scroll );

	//pVtx[0].tex=D3DXVECTOR2( 0.25f, 0.0f + scroll );
	//pVtx[1].tex=D3DXVECTOR2( 0.75f, 0.0f + scroll );
	//pVtx[2].tex=D3DXVECTOR2( 0.25f, 0.5f + scroll );
	//pVtx[3].tex=D3DXVECTOR2( 0.75f, 0.5f + scroll );
	*/

	// obt@̃AbN
	g_pVtxBufferStaffRoll->Unlock();

	scroll += 1.0f;

}

// ED ̕`
void DrawStaffRoll( void )
{

	LPDIRECT3DDEVICE9 pDevice = nullptr;				//foCX󂯎p֐


	// foCX̎󂯎菈
	pDevice = GetDevice( );

	// Xg[
	pDevice->SetStreamSource(0,							//MS
	g_pVtxBufferStaffRoll,									//ǂ̒_obt@\ƌԂ...
	0,													//f[^̃ItZbg
	sizeof(VERTEX_2D));									//XgChl(oCg)

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	for ( int inc = 0 ; inc < CREATE_TEXTURE_NUMBER ; inc++  ){
	
		// eNX`̐ݒ
		pDevice->SetTexture(0,g_pTextureStaffRoll[ inc ]);		
	
		// |S̕`
		pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, NUM_VERTEX * inc , NUM_STAFF_ROLL );
		
	}

}

// _̍쐬
HRESULT MakeVertexStaffRoll( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									// zAhX
	D3DXVECTOR2 start,end;								// eNX`ʒu n_ƏI_

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX	 	 		// mۂobt@TCY(_m) P:oCg
			* CREATE_TEXTURE_NUMBER,					// eNX`쐬
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							// obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferStaffRoll,						// i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}


	// obt@bNzAhX擾
	g_pVtxBufferStaffRoll -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN

	start.x = 0.0f;
	end.x = SCREEN_WIDTH;

	// _W̐ݒ
	for( int inc = 0; inc < CREATE_TEXTURE_NUMBER ; inc++ ){

		// W̐ݒ
		start.y = ( float ) SCREEN_HEIGHT + ( SCREEN_HEIGHT * inc );
		end.y = ( float ) SCREEN_HEIGHT + ( SCREEN_HEIGHT * ( inc + 1 ) );

		pVtx[ 0 + ( NUM_VERTEX * inc ) ].pos = D3DXVECTOR3( start.x, start.y, 0.0f ); 
		pVtx[ 1 + ( NUM_VERTEX * inc ) ].pos = D3DXVECTOR3( end.x,   start.y, 0.0f ); 
		pVtx[ 2 + ( NUM_VERTEX * inc ) ].pos = D3DXVECTOR3( start.x, end.y,   0.0f ); 
		pVtx[ 3 + ( NUM_VERTEX * inc ) ].pos = D3DXVECTOR3( end.x,   end.y,   0.0f ); 

		pVtx[ 0 + ( NUM_VERTEX * inc ) ].rhw = 1.0f;
		pVtx[ 1 + ( NUM_VERTEX * inc ) ].rhw = 1.0f;
		pVtx[ 2 + ( NUM_VERTEX * inc ) ].rhw = 1.0f;
		pVtx[ 3 + ( NUM_VERTEX * inc ) ].rhw = 1.0f;

		pVtx[ 0 + ( NUM_VERTEX * inc ) ].color = D3DCOLOR_RGBA( 255, 255, 255, 255 );
		pVtx[ 1 + ( NUM_VERTEX * inc ) ].color = D3DCOLOR_RGBA( 255, 255, 255, 255 );
		pVtx[ 2 + ( NUM_VERTEX * inc ) ].color = D3DCOLOR_RGBA( 255, 255, 255, 255 );
		pVtx[ 3 + ( NUM_VERTEX * inc ) ].color = D3DCOLOR_RGBA( 255, 255, 255, 255 );

		pVtx[ 0 + ( NUM_VERTEX * inc ) ].tex = D3DXVECTOR2( 0.0f, 0.0f );
		pVtx[ 1 + ( NUM_VERTEX * inc ) ].tex = D3DXVECTOR2( 1.0f, 0.0f );
		pVtx[ 2 + ( NUM_VERTEX * inc ) ].tex = D3DXVECTOR2( 0.0f, 1.0f );
		pVtx[ 3 + ( NUM_VERTEX * inc ) ].tex = D3DXVECTOR2( 1.0f, 1.0f );
	
	}

	// obt@̃AbN
	g_pVtxBufferStaffRoll->Unlock();

	return S_OK;

}

// W̐ݒ
void SetVertexStaffRoll( VERTEX_2D *pVtx, int indexNumber )
{

	D3DXVECTOR2 start,end;								// eNX`ʒu n_ƏI_

	// W̐ݒ
	start.x = 0.0f;
	start.y = ( float ) SCREEN_HEIGHT + ( SCREEN_HEIGHT * indexNumber );
	end.x = SCREEN_WIDTH;
	end.y =  ( float ) SCREEN_HEIGHT + ( SCREEN_HEIGHT *  ( indexNumber + 1 ) );

	pVtx[ 0 + ( NUM_VERTEX * indexNumber ) ].pos = D3DXVECTOR3( start.x, start.y - scroll, 0.0f ); 
	pVtx[ 1 + ( NUM_VERTEX * indexNumber ) ].pos = D3DXVECTOR3( end.x,   start.y - scroll, 0.0f ); 
	pVtx[ 2 + ( NUM_VERTEX * indexNumber ) ].pos = D3DXVECTOR3( start.x, end.y - scroll,   0.0f ); 
	pVtx[ 3 + ( NUM_VERTEX * indexNumber ) ].pos = D3DXVECTOR3( end.x,   end.y - scroll,   0.0f ); 


}

// _F̐ݒ
void TransitionColor( VERTEX_2D *pVtx, int indexNumber )
{

	D3DXCOLOR color;						// _F
	static unsigned int transitionColor;	// FJ

	// _F̍XV
	color.r = 0 + transitionColor;
	color.g = 0 + transitionColor;
	color.b = 0 + transitionColor;
	color.a = 255;

	// _F̐ݒ
	pVtx[ 0 + ( NUM_VERTEX * indexNumber ) ].color = D3DCOLOR_RGBA( (int)color.r, (int)color.g, (int)color.b, (int)color.a );
	pVtx[ 1 + ( NUM_VERTEX * indexNumber ) ].color = D3DCOLOR_RGBA( (int)color.r, (int)color.g, (int)color.b, (int)color.a );
	pVtx[ 2 + ( NUM_VERTEX * indexNumber ) ].color = D3DCOLOR_RGBA( (int)color.r, (int)color.g, (int)color.b, (int)color.a );
	pVtx[ 3 + ( NUM_VERTEX * indexNumber ) ].color = D3DCOLOR_RGBA( (int)color.r, (int)color.g, (int)color.b, (int)color.a );

	transitionColor++;

}

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             