/***************************************************************/
//
//
//		DirectX	[ timerlogo.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 8/26
/*---------------------------------------------------------------
Update : 2016/8/26
			timerlogo.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "timer_logo.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NAME "data/TEXTURE/timer_logo.png"		// eNX`pX

#define NUM_VERTEX  ( 4 )								// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )								// `悷|S

#define START_COORD_X (200)								// \WSX
#define START_COORD_Y (20)								// \ʒuSY
#define END_COORD_X   (301)								// \WEX
#define END_COORD_Y   (59)								// \WEX

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexTimerLogo( LPDIRECT3DDEVICE9 pDevice );	// _̍쐬
void SetVertexTimerLogoCoord( VERTEX_2D* pVtx );			// _W̐ݒ
void SetVertexTimerLogoSpriteUV( VERTEX_2D* pVtx );			// _UVl̐ݒ
void SetVertexTimerLogoColor( VERTEX_2D* pVtx );			// _F̐ݒ

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureTimerLogo = nullptr;			// eNX`-C^[tF-X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferTimerLogo = nullptr;	// _obt@C^[tF[Xւ̃|C^


// TIMERLOGȌ
void InitTimerLogo( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexTimerLogo( pDevice );

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME, &g_pTextureTimerLogo )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "TIMERLOGOeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}


}

// TIMERLOGȌI
void UninitTimerLogo( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE( g_pTextureTimerLogo )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( g_pVtxBufferTimerLogo )

}

// TIMERLOGO̍XV
void UpdateTimerLogo( void )
{

	VERTEX_2D *pVtx;										// zAhX


	// obt@bNzAhX擾
	g_pVtxBufferTimerLogo -> Lock( 0, 0, (void**)&pVtx, 0 );

	
	{// _obt@̐ݒ


		// _W̐ݒ
		//SetVertexTimerLogoCoord( pVtx );

		// _UVl̐ݒ
		//SetVertexTimerLogoSpriteUV( pVtx );

		// _F̐ݒ
		SetVertexTimerLogoColor( pVtx );

		// rhw̐ݒ
		//pVtx[0].rhw = 1.0f;
		//pVtx[1].rhw = 1.0f;
		//pVtx[2].rhw = 1.0f;
		//pVtx[3].rhw = 1.0f;


	}// SetVertex -> END 
	

	g_pVtxBufferTimerLogo ->Unlock( );


}

// TIMERLOGO̕`
void DrawTimerLogo( void )
{


	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferTimerLogo,									// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_2D ));							// ̃XgChl(oCgP)


	// _tH[}bg̐ݒ
	pDevice ->SetFVF( FVF_VERTEX_2D );


	// eNX`̐ݒ
	pDevice ->SetTexture( 0, g_pTextureTimerLogo );


	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );

	// Z̐ݒ
	pDevice -> SetRenderState( D3DRS_BLENDOP , D3DBLENDOP_ADD );
	pDevice -> SetRenderState( D3DRS_SRCBLEND , D3DBLEND_SRCALPHA );
	pDevice -> SetRenderState( D3DRS_DESTBLEND , D3DBLEND_ONE );

	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );

	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,TRUE );				//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃



}

// _̍쐬
HRESULT MakeVertexTimerLogo( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;									// zAhX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_2D ) * NUM_VERTEX,			// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&g_pVtxBufferTimerLogo,						// i[|C^
			NULL )))
	{

		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " TIMERLOGO VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return E_FAIL;

	}


	// zAhX̎擾
	g_pVtxBufferTimerLogo -> Lock( 0, 0, (void**)&pVtx, 0 );


	{// _obt@̐ݒ

		// _W̐ݒ
		SetVertexTimerLogoCoord( pVtx );

		// _UVl̐ݒ
		SetVertexTimerLogoSpriteUV( pVtx );

		// _F̐ݒ
		SetVertexTimerLogoColor( pVtx );

		// rhw̐ݒ
		pVtx[0].rhw = 1.0f;
		pVtx[1].rhw = 1.0f;
		pVtx[2].rhw = 1.0f;
		pVtx[3].rhw = 1.0f;

	}// SetVertex -> END 


	// obt@̃AbN
	g_pVtxBufferTimerLogo ->Unlock( );

	return S_OK;


}

// _W̐ݒ
void SetVertexTimerLogoCoord( VERTEX_2D* pVtx )
{


	D3DXVECTOR2 start,end;				// n_ƏI_
	D3DXVECTOR2 center;					// SW
	D3DXVECTOR2 radius;					// XvCga
	D3DXVECTOR2 coord[ NUM_VERTEX ];	// W̌vZli[p
	static float arc;					// ]px
	static float scale = 1.0f;			// gkl



	{ // Wl

		// a̐ݒ
		radius.x = (( END_COORD_X - START_COORD_X ) * 0.5f ); 
		radius.y = (( END_COORD_Y - START_COORD_Y ) * 0.5f ); 

		// SW̐ݒ
		center.x = START_COORD_X + radius.x;
		center.y = START_COORD_Y + radius.y;

	} // -> ݒI



	// XvCggk
	scale += 0.0f;

	{ // XP[

		radius *= scale;

	}

	// XvCg]
	arc -= 360;

	{ // AtBϊ


		coord[ 0 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, -radius.y, arc );
		coord[ 0 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, -radius.y, arc );

		coord[ 1 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, -radius.y, arc );
		coord[ 1 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, -radius.y, arc );

		coord[ 2 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, radius.y, arc );
		coord[ 2 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, radius.y, arc );

		coord[ 3 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, radius.y, arc );
		coord[ 3 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, radius.y, arc );


	} // -> ϊI


	// W̏
	for( int index = 0; index < NUM_VERTEX; index++ )
	{
		pVtx[ index ].pos=D3DXVECTOR3( coord[ index ].x, coord[ index ].y  , 0.0f );
	}
	


	/*
	// W̐ݒ
	start.x = START_COORD_X;
	start.y = START_COORD_Y;
	end.x   = END_COORD_X;
	end.y   = END_COORD_Y;


	// W̏
	pVtx[0].pos=D3DXVECTOR3( start.x, start.y, 0.0f );
	pVtx[1].pos=D3DXVECTOR3( end.x  , start.y, 0.0f );
	pVtx[2].pos=D3DXVECTOR3( start.x, end.y  , 0.0f );
	pVtx[3].pos=D3DXVECTOR3( end.x  , end.y  , 0.0f );
	*/

}

// _UVl̐ݒ
void SetVertexTimerLogoSpriteUV( VERTEX_2D* pVtx )
{


	const unsigned int TEXTURE_SHEETS_U = 1;		// eNX`Aj[V
	const unsigned int TEXTURE_SHEETS_V = 1;		// eNX`cAj[V
	const unsigned int FPS = 1 ;					// t[p[ZJh(҂)
	const float TEXTURE_U = 1.0f / TEXTURE_SHEETS_U;// eNX` U l萔
	const float TEXTURE_V = 1.0f / TEXTURE_SHEETS_V;// eNX` V l萔
	float TexU = 0,TexV = 0;						// eNX`UVľvZɎgp
	static unsigned int animationFrame;				// Aj[Vt[



	// UVľvZ
	TexU = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_U ) * TEXTURE_U;
	TexV = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_V ) * TEXTURE_V;


	// _UVl̏
	pVtx[0].tex = D3DXVECTOR2( TexU            , TexV );
	pVtx[1].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV );
	pVtx[2].tex = D3DXVECTOR2( TexU            , TexV + TEXTURE_V );
	pVtx[3].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV + TEXTURE_V );


	// Aj[Vt[̍XV
	animationFrame ++;


}

// _F̐ݒ
void SetVertexTimerLogoColor( VERTEX_2D* pVtx )
{

	static D3DXCOLOR vertexColor = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f );	// _F

	static float transitionColor = 0.5f;
	static bool frag = true;


	// _F̍XV
	vertexColor.r = transitionColor; 
	vertexColor.g = transitionColor; 
	vertexColor.b = transitionColor; 
	//vertexColor.a -= 0.1f; 
	


	// _F̏
	pVtx[ 0 ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 1 ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 2 ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 3 ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );


	if( transitionColor >= 1.0f ){
	
		frag = false;
	}

	if( frag ){
		
		transitionColor += 0.005f;
	}
	else{
	
		transitionColor -= 0.005f;

		if( transitionColor <= 0.6f ){
	
			frag = true;
		}

	}

}


