'''
Created on 2010/05/02

@author: Katsuhiro Inagaki
'''
from django.conf.urls.defaults import patterns

urlpatterns = patterns('',
    (r'^(?P<item_id>\d+)/feedback/$', 'djanction.rating.views.feedback'),
)

urlpatterns += patterns('djanction.item.views',
    (r'^$', 'item'),
    (r'^form/$', 'form'),
    (r'^(?P<item_id>\d+)/form/$', 'form'),
    (r'^(?P<item_id>\d+)/$', 'info'),
    (r'^(?P<item_id>\d+)/add_qa/$', 'add_qa'),
    (r'^(?P<item_id>\d+)/add_contact_message/$', 'add_contact_message'),
    (r'^(?P<item_id>\d+)/bids/$', 'bids'),
    (r'^(?P<item_id>\d+)/cancel/$', 'cancel'),
    (r'^(?P<item_id>\d+)/close/$', 'close'),
    (r'^(?P<item_id>\d+)/contacts/$', 'contact'),
    (r'^(?P<item_id>\d+)/contacts/(?P<contact_id>\d+)/$', 'contact_detail'),
####default url is item list, keep it as the LAST url pattern
    (r'^(?P<category_name>\S+)/$', 'list'),
)

# patter of generic view
from djanction.item.models import Item
kwargs = dict(
    queryset=Item.objects.all(),
)

urlpatterns += patterns('django.views.generic',
    (r'^(?P<object_id>\d+)/$', 'list_detail.object_detail', kwargs),
)

#------------------------------------------------------------#
#default url is item list, keep it as the LAST url pattern   #
#------------------------------------------------------------#
#urlpatterns += patterns('djanction.item.views',
#   (r'^(?P<category_name>\S+)/$', 'list'),
#)


