'''
Created on 2010/05/01

@author: katsuhiro Inagaki
'''

import os

from django import forms
from django.conf import settings
from django.forms.models import InlineForeignKeyHiddenInput
from django.utils.translation import ugettext_lazy as _

from djanction.appauth.models import User
from djanction.item.models import Item
from djanction.mypage import USER_ICON_BASE_DIR
from djanction.mypage import USER_ICON_BASE_URL
from djanction.mypage import icon_img_type
from djanction.watchlist.models import WatchItem

class UserForm(forms.ModelForm):
    image = forms.ImageField(label=_('image'), required=False)

    class Meta:
        model = User
        exclude = ('username', 'password', 'is_staff', 'is_active', 'is_superuser',
                   'last_login', 'date_joined', 'groups', 'user_permissions',
                   'lank', 'point', 'total_assessment', 'secession_date',
        )

    def icon_path(self):
        if os.path.isfile(os.path.join(USER_ICON_BASE_DIR, str(self.instance.id), 'icon.' + icon_img_type())):
            return USER_ICON_BASE_URL + '/' + str(self.instance.id) + '/icon.' + icon_img_type()
        else:
            # return default icon
            return USER_ICON_BASE_URL + '/icon.' + icon_img_type()


class WatchItemForm(forms.ModelForm):
    selected = forms.BooleanField(required=False)
    item = forms.ModelChoiceField(queryset=Item.objects.all(), widget=InlineForeignKeyHiddenInput)
    user = forms.ModelChoiceField(queryset=User.objects.all(), widget=InlineForeignKeyHiddenInput)

    class Meta:
        model = WatchItem


class WatchItemSearchForm(forms.Form):
    is_complete = forms.BooleanField(required=False, widget=forms.HiddenInput)