#vim:fileencoding=utf8
from django.conf import settings
from django.db.backends.postgresql.creation import *

class DatabaseCreation(DatabaseCreation):

    def create_test_db(self, verbosity=1, autoclobber=False):
        self.isTesting = True
        super(DatabaseCreation, self).create_test_db(verbosity, autoclobber)

    def sql_table_creation_suffix(self):
        assert settings.TEST_DATABASE_COLLATION is None, "PostgreSQL does not support collation setting at database creation time."
        suffix = ''
        if settings.TEST_DATABASE_CHARSET:
            suffix += "WITH ENCODING '%s'" % settings.TEST_DATABASE_CHARSET

        # tablespace
        tablespace = ''
        if getattr(self, 'isTesting', False):
            if getattr(settings, 'TEST_TABLESPACE', None):
                tablespace = settings.TEST_TABLESPACE
            elif settings.DEFAULT_TABLESPACE:
                tablespace = settings.TEST_TABLESPACE
        elif settings.DEFAULT_TABLESPACE:
            tablespace = settings.TEST_TABLESPACE
        if tablespace:
            if suffix:
                suffix += ' '
            suffix += "TABLESPACE %s" % tablespace
            print 'Using tablespace %r' % tablespace
            
        return suffix

