
#ifndef DKUTIL_ARCHIVE_CONVERT_BLOCK_TO_FILE_HPP
#define DKUTIL_ARCHIVE_CONVERT_BLOCK_TO_FILE_HPP

//#include <dkutil/config.hpp>
#include <dkutil/archive/convert_block_to_stream.hpp>

namespace dkutil{


template<class T,class FS_T,class INTERRUPT_T>
class convert_block_to_file_functor : public convert_block_to_stream_functor<T,FS_T,INTERRUPT_T>
{
public:
	typedef typename convert_block_to_stream_functor<T,FS_T,INTERRUPT_T> base_type;
	typedef typename base_type::policy_type policy_type;
	///file stream type
	typedef typename base_type::fs_type fs_type;
	typedef typename base_type::interrupt_type interrupt_type;
	typedef typename base_type::reader reader;
	typedef typename convert_block_to_file_functor<T,FS_T,INTERRUPT_T> self_type;
	typedef typename base_type::null_interrupt_functor null_interrupt_functor;
	typedef typename base_type::convert_functor convert_functor;
private:

public:
	convert_block_to_file_functor(){
	}
	~convert_block_to_file_functor(){}

	bool operator()(fs_type *dest,path_string_ref src,
		policy_type *policy,
		void *user_ptr = NULL,
		interrupt_type it=interrupt_type(),
		size_t inner_buffer_size = DKUTIL_DEFAULT_INNER_BUFFER_SIZE,
		size_t buffer_limit = DKUTIL_DEFAULT_INNER_BUFFER_SIZE * 4)
	{
		if(dest->is_write_mode()==false) return false;
		fs_type fs;
		DKUTIL_RETURN_FALSE(fs.reset(src,read_mode | binary_mode));
		DKUTIL_RETURN_FALSE(fs.open());
		
		
		return base_type::operator()(
			dest,&fs,fs.filesize(),policy,user_ptr,it,inner_buffer_size,
			buffer_limit);

	}
		bool operator()(
		const PasswordOption &pass,uint32 signature,
		fs_type *dest,path_string_ref src,
		void *user_ptr = NULL,
		interrupt_type it=interrupt_type(),
		size_t inner_buffer_size = DKUTIL_DEFAULT_INNER_BUFFER_SIZE)
	{
		policy_type p(pass,signature,inner_buffer_size);
		return operator()(dest,src,&p,user_ptr,it,inner_buffer_size);
	}
};

/**
@param pass[in] pX[h
@param signature[in] ʒliRɐݒ肵Ă悵j
@param dest[in][out] Xg[IuWFNgւ̃|C^
@param srcfile[in] t@Cւ̃pX
@param user_ptr[in] interrupt_Ŏg|C^
@param interrupt_[in] 荞ݏpt@N^[
@param inner_buffer_size[in] ̃e|obt@̃TCY
*/
template<class STREAM_T,class INTERRUPT_T>
inline bool ArcfourDecodeStreamConvertBlockToFile(
	const PasswordOption &pass,uint32 signature,
	STREAM_T *dest,path_string_ref srcfile,
	void *user_ptr = NULL,
	INTERRUPT_T interrupt_ = INTERRUPT_T(),
	size_t inner_buffer_size = DKUTIL_PROPER_TEMPORARY_BUFFER_SIZE())
{
	convert_block_to_file_functor<CArcfourConvertStream,STREAM_T,INTERRUPT_T> a;
	DKUTIL_RETURN_FALSE(
		a(
			pass,signature,dest,srcfile,user_ptr,interrupt_,inner_buffer_size
		)
	);
	return true;
}



template<class STREAM_T,class INTERRUPT_T>
inline bool HC256DecodeStreamConvertBlockToFile(
	const PasswordOption &pass,uint32 signature,
	STREAM_T *dest,path_string_ref srcfile,
	void *user_ptr = NULL,
	INTERRUPT_T interrupt_ = INTERRUPT_T(),
	size_t inner_buffer_size = DKUTIL_PROPER_TEMPORARY_BUFFER_SIZE())
{
	convert_block_to_file_functor<CHC256ConvertStream,STREAM_T,INTERRUPT_T> a;
	DKUTIL_RETURN_FALSE(
		a(
			pass,signature,dest,srcfile,user_ptr,interrupt_,inner_buffer_size
		)
	);
	return true;
}

/**
#define ArcfourDecodeFileToStream ArcfourEncodeFileToStream
template<class STREAM_T,class INTERRUPT_T>
inline bool ArcfourDecodeFileToStream(
	const PasswordOption &pass,uint32 signature,
	STREAM_T *dest,path_string_ref srcfile,
	void *user_ptr = NULL,
	INTERRUPT_T interrupt_ = INTERRUPT_T(),
	size_t inner_buffer_size = DKUTIL_PROPER_TEMPORARY_BUFFER_SIZE())
{
	
	file_to_stream_convert_functor<CArcfourConvertStream,STREAM_T,INTERRUPT_T> a;
	DKUTIL_RETURN_FALSE(
		a(
			pass,signature,dest,srcfile,user_ptr,interrupt_,inner_buffer_size
		)
	);
	return true;
}

template<class STREAM_T,class INTERRUPT_T>
inline bool HC256DecodeFileToFile(
	const PasswordOption &pass,
	path_string_ref destfile,path_string_ref srcfile,
	bool overwrite = false,std::ostream *pos = NULL,size_t inner_buffer_size = 1024 * 512)
{
	file_to_stream_convert_functor<CHC256DecodeStream> a;
	a.set_ostream(pos);
	return a.convert(pass,destfile,srcfile,overwrite,inner_buffer_size);
}
*/
}//end of dkutil namespace





#endif