/**
@filename extract.hpp
@brief A[JCu𓀂鎞Ɏg@\

*/
#ifndef DKUTIL_ARCHIVE_EXTRACT_HPP
#define DKUTIL_ARCHIVE_EXTRACT_HPP

#include <dkutil/archive/interface.hpp>

namespace dkutil{
	///by archive/pack.hpp
	

	class CExtractStream
	{
	public:
		friend IdKingyoArchiveExtract;
		//friend CPackArchiveExtract;
		typedef CExtractStream self_type;
	protected:
		CCirculerMemoryStream mC;
		

		uint64 mArchiveOffsetBegin;
		uint64 mArchiveOffset;
		uint64 mArchiveSize;
		///readTCY
		size_t mReadSize;
		bool inited;

	public:
		CExtractStream(size_t circuler_buffer_size,size_t readsize)
		{
			inited = false;
			mC.reset(circuler_buffer_size);
			set_read_size(readsize);
		}
		void setArchiveOption(uint64 offsetbegin,uint64 offset,uint64 size)
		{
			mArchiveOffsetBegin = offsetbegin;
			mArchiveOffset = offset;
			mArchiveSize = size;
			inited = true;
		}
				
		void setArchiveOffset(uint64 a){
			mArchiveOffset = a;
		}
		void setArchiveSize(uint64 a){
			mArchiveSize = a;
		}

		virtual ~CExtractStream(){}
		bool read(void *p,size_t size,size_t *readsize){
			dkcmNOT_ASSERT(good()==false);
			return mC.read(p,size,readsize);
		}
		///archive object݂̂gpĂ͂܂B(friend  protected:ɉB΂񂾂ǂˁB
		bool write(const void *p,size_t size,size_t *wsize){
			dkcmNOT_ASSERT(good()==false);
			return mC.write(p,size,wsize);
		}
		bool ref(void *p,size_t size,size_t *readsize){
			dkcmNOT_ASSERT(good()==false);
			return mC.ref(p,size,readsize);
		}
		size_t size()const{return mC.size();}
		size_t get_read_size()const{return mReadSize;}
		void set_read_size(size_t s){mReadSize = s;}
		uint64 archive_offset_begin()const{
			return mArchiveOffsetBegin;
		}
		uint64 archive_offset()const{
			return mArchiveOffset;
		}
		uint64 archive_size()const{
			return mArchiveSize;
		}
		uint64 archive_end_size()const{
			return mArchiveSize + mArchiveOffsetBegin;
		}
		bool eof()const{
			return archive_offset() == archive_end_size();
		}
		bool good()const{
			return inited;
		}

	};

}//end of dkutil namespace



#endif