
#ifndef DKUTIL_ARCHIVE_FILE_TO_CONVERT_BLOCK_HPP
#define DKUTIL_ARCHIVE_FILE_TO_CONVERT_BLOCK_HPP

#include <dkutil/archive/stream_to_convert_block.hpp>

namespace dkutil{

/**
@param T cryptograph interface
@param FS_T file stream type
@param INTERRUPT_T stream interrupt functor type
*/
///Xg[ɈÍt@C𖄂ߍ݂܂iwb_tj
template<class T,class FS_T,class INTERRUPT_T>
class file_to_convert_block_functor : public stream_to_convert_block_functor<T,FS_T,INTERRUPT_T>
{
public:
	typedef typename stream_to_convert_block_functor<T,FS_T,INTERRUPT_T> base_type;
	typedef typename base_type::policy_type policy_type;
	///file stream type
	typedef typename base_type::fs_type fs_type;
	typedef typename base_type::converter converter;
	typedef typename base_type::interrupt_type interrupt_type;
	typedef typename file_to_convert_block_functor<T,FS_T,INTERRUPT_T> self_type;
	typedef typename base_type::null_interrupt_functor null_interrupt_functor;
	typedef typename base_type::convert_functor convert_functor;
protected:
	converter mC;
public:

	file_to_convert_block_functor(){}
	~file_to_convert_block_functor(){}

	/**
	@note
	policy͎OɎgԂɂĂĂB
	fs͎Owrite()oԂɂĂĂB
	*/
	bool operator()(fs_type *dest,path_string_ref srcfile,
		policy_type *policy,
		void *user_ptr = NULL,
		interrupt_type it=interrupt_type(),
		size_t inner_buffer_size = DKUTIL_DEFAULT_INNER_BUFFER_SIZE)
	{
		converter c;
		if(dest->is_write_mode()==false){
			return false;
		}
		uint64 filesize;
		DKUTIL_RETURN_FALSE(GetFileSize(srcfile,&filesize));
		fs_type readsrc;
		DKUTIL_RETURN_FALSE(readsrc.reset(srcfile,read_mode | binary_mode));
		DKUTIL_RETURN_FALSE(readsrc.open());

		return base_type::operator()(dest,&readsrc,filesize,policy,user_ptr,it,inner_buffer_size);
	}
	bool operator()(
		const PasswordOption &pass,uint32 signature,
		fs_type *dest,path_string_ref srcfile,
		void *user_ptr = NULL,
		interrupt_type it=interrupt_type(),
		size_t inner_buffer_size = DKUTIL_DEFAULT_INNER_BUFFER_SIZE)
	{
		policy_type p(pass,signature,inner_buffer_size);
		return operator()(dest,srcfile,&p,user_ptr,it,inner_buffer_size);
	}
};

/**
@param pass[in] pX[h
@param signature[in] ʒliRɐݒ肵Ă悵j
@param dest[in][out] Xg[IuWFNgւ̃|C^
@param srcfile[in] t@Cւ̃pX
@param user_ptr[in] interrupt_Ŏg|C^
@param interrupt_[in] 荞ݏpt@N^[
@param inner_buffer_size[in] ̃e|obt@̃TCY
*/
template<class STREAM_T,class INTERRUPT_T>
inline bool ArcfourEncodeFileToStreamConvertBlock(
	const PasswordOption &pass,uint32 signature,
	STREAM_T *dest,path_string_ref srcfile,
	void *user_ptr = NULL,
	INTERRUPT_T interrupt_ = INTERRUPT_T(),
	size_t inner_buffer_size = DKUTIL_PROPER_TEMPORARY_BUFFER_SIZE())
{
	file_to_convert_block_functor<CArcfourConvertStream,STREAM_T,INTERRUPT_T> a;
	DKUTIL_RETURN_FALSE(
		a(
			pass,signature,dest,srcfile,user_ptr,interrupt_,inner_buffer_size
		)
	);
	return true;
}



template<class STREAM_T,class INTERRUPT_T>
inline bool HC256EncodeFileToStreamConvertBlock(
	const PasswordOption &pass,uint32 signature,
	STREAM_T *dest,path_string_ref srcfile,
	void *user_ptr = NULL,
	INTERRUPT_T interrupt_ = INTERRUPT_T(),
	size_t inner_buffer_size = DKUTIL_PROPER_TEMPORARY_BUFFER_SIZE())
{
	file_to_convert_block_functor<CHC256ConvertStream,STREAM_T,INTERRUPT_T> a;
	DKUTIL_RETURN_FALSE(
		a(
			pass,signature,dest,srcfile,user_ptr,interrupt_,inner_buffer_size
		)
	);
	return true;
}




#if 0
/**
@param T cryptograph interface
@param FS_T file stream type
@param INTERRUPT_T stream interrupt functor type
*/
///Xg[ɈÍt@C𖄂ߍ݂܂iwb_tj
template<class T,class FS_T,class INTERRUPT_T>
class file_to_convert_block_functor
{
public:
	typedef typename T policy_type;
	///file stream type
	typedef typename FS_T fs_type;
	typedef typename convert_interface<policy_type,fs_type> converter;
	typedef typename file_to_convert_block_functor<T,FS_T,INTERRUPT_T> self_type;
	typedef typename stream_process_interrupt_functor_base null_interrupt_functor;
	typedef typename INTERRUPT_T interrupt_type;
private:
	converter mC;
	//template<class SELF_T = self_type,class CONVERT_T = converter>
	class convert_functor{
		typedef self_type SELF_T;
		typedef converter CONVERT_T;
		CONVERT_T *mp;
		SELF_T *msp;
		interrupt_type mit;
		stream_process_interrupt_arg mArg;
		fs_type *mpfs;
		void *mUserPtr;
	public:
		convert_functor(SELF_T *selfp,CONVERT_T *p,fs_type *pfs,interrupt_type it,
			uint64 allsize,void *user_ptr) : mArg(allsize)
		{
			mp = p;
			msp = selfp;
			mUserPtr = user_ptr;
			mpfs = pfs;
			mit = it;
			if(pfs->is_read_mode()){
				DKUTIL_THROW_OR_NOTICE(std::runtime_error("convert_functor constructor not write_mode"));
			}
		}
		void operator()(const uint8 *p,size_t size){
			
			stream_process_interrupt_arg arg;
			
		
			mp->convert(p,size);
			mArg.mFinishedSize += size;
			//stack
			arg = mArg;
			arg.mNowFinishedSize = size;
			arg.mStreamData = (const void *)p;

			//interrupt
			mit(&arg,mUserPtr);
			//write
			mpfs->write(p,size);
		}
	};
public:

	file_to_convert_block_functor(){}
	~file_to_convert_block_functor(){}

	/**
	@note
	policy͎OɎgԂɂĂĂB
	fs͎Owrite()oԂɂĂĂB
	*/
	bool operator()(path_string_ref srcfile,
		policy_type *policy,fs_type *fs,
		void *user_ptr = NULL,
		interrupt_type it=interrupt_type(),
		size_t inner_buffer_size = DKUTIL_DEFAULT_INNER_BUFFER_SIZE)
	{
		converter c;
		if(fs->is_write_mode()==false){
			return false;
		}
		
		DKUTIL_RETURN_FALSE(c.reset(policy,fs));
		DKUTIL_RETURN_FALSE(c.begin());
		typedef div_read_each_functor<fs_type,convert_functor> ft;
		
		uint64 filesize;
		DKUTIL_RETURN_FALSE(GetFileSize(srcfile,&filesize));
		ft f;
		fs_type readfs;
		DKUTIL_RETURN_FALSE(readfs.reset(srcfile,read_mode | binary_mode));
		DKUTIL_RETURN_FALSE(readfs.open());
		

		convert_functor cf(this,&c,fs,it,filesize,user_ptr);
		DKUTIL_RETURN_FALSE(f(&readfs,cf,inner_buffer_size));

		DKUTIL_RETURN_FALSE(c.end());
		

		return true;

	}
	bool operator()(
		const PasswordOption &pass,uint32 signature,
		fs_type *dest,path_string_ref srcfile,
		void *user_ptr = NULL,
		interrupt_type it=interrupt_type(),
		size_t inner_buffer_size = DKUTIL_DEFAULT_INNER_BUFFER_SIZE)
	{
		policy_type p(pass,signature,inner_buffer_size);
		return operator()(srcfile,&p,dest,user_ptr,it,inner_buffer_size);
	}
};

#endif

/**
#define ArcfourDecodeFileToStream ArcfourEncodeFileToStream
template<class STREAM_T,class INTERRUPT_T>
inline bool ArcfourDecodeFileToStream(
	const PasswordOption &pass,uint32 signature,
	STREAM_T *dest,path_string_ref srcfile,
	void *user_ptr = NULL,
	INTERRUPT_T interrupt_ = INTERRUPT_T(),
	size_t inner_buffer_size = DKUTIL_PROPER_TEMPORARY_BUFFER_SIZE())
{
	
	file_to_convert_block_functor<CArcfourConvertStream,STREAM_T,INTERRUPT_T> a;
	DKUTIL_RETURN_FALSE(
		a(
			pass,signature,dest,srcfile,user_ptr,interrupt_,inner_buffer_size
		)
	);
	return true;
}

template<class STREAM_T,class INTERRUPT_T>
inline bool HC256DecodeFileToFile(
	const PasswordOption &pass,
	path_string_ref destfile,path_string_ref srcfile,
	bool overwrite = false,std::ostream *pos = NULL,size_t inner_buffer_size = 1024 * 512)
{
	file_to_convert_block_functor<CHC256DecodeStream> a;
	a.set_ostream(pos);
	return a.convert(pass,destfile,srcfile,overwrite,inner_buffer_size);
}
*/
}//end of dkutil namespace





#endif