/**
@filename reserve.hpp
@brief A[JCuɂvfo^@\

*/
#ifndef DKUTIL_ARCHIVE_RESERVE_HPP
#define DKUTIL_ARCHIVE_RESERVE_HPP

#include <dkutil/archive/interface.hpp>
#include <dkutil/filesystem/littleendian_filestream.hpp>
#include <dkutil/dktl/adapters.hpp>
#include <dkutil/parser/string_util.hpp>
#include <dkutil/filesystem/utility.hpp>

namespace dkutil{
	///A[JCuɂvfit@C⃁̈jo^NX
	class CArchiveGenerateReserve : public IdKingyoArchiveGenerate{
	public:
		typedef IdKingyoArchiveGenerate base_type;
		typedef base_type::size_type size_type;
		typedef base_type::key_type key_type;
		typedef base_type::reserve_type reserve_type;
		typedef set_ex_adapter<std::set<reserve_type> > container_type;
	protected:
		//CLittleEndianFileStream FStream;
		
		container_type mC;

	public:

		bool generate(const dKingyoArchiveGenerateOption &x){
			dkcmNOT_ASSERT("not implementation");
			return false;
		}
		CArchiveGenerateReserve(){
			//reset(filename);
			
		}
		virtual ~CArchiveGenerateReserve(){
			clear();
		}
		void clear(){

			mC.clear();
		}
		bool erase(const key_type &key){
			reserve_type r;
			r.setKey(key);
			container_type::iterator it = mC.find(r);
			if(mC.end()==it){
				return false;
			}
			mC.erase(it);
			return true;
		}

		virtual bool addToArchive(path_string_ref filename){
			dKingyoArchiveReserveElement a;
			a.regist_filename(filename);
			return mC.rb_insert(a);
		}
		bool addFromFile(path_string_ref filename){
			return addToArchive(filename);
		}
		virtual bool addToArchive(const key_type &key,path_string_ref filename)
		{
			dKingyoArchiveReserveElement a;
			a.regist_filename(filename,key);
			return mC.rb_insert(a);
		}
		bool addFromFile(const key_type &key,path_string_ref filename){
			return addToArchive(key,filename);
		}

		virtual bool addToArchive(const key_type &key,const uint8 *pbuff,size_type size)
		{
			dKingyoArchiveReserveElement a;
			shared_buffer f;
			f.copy(pbuff,size);
			return addFromMemory(key,f);
		}
		bool addFromMemory(const key_type &key,const uint8 *pbuff,size_type size){
			return addToArchive(key,pbuff,size);
		}
		virtual bool addToArchive(const key_type &key,const shared_buffer &x){
			dKingyoArchiveReserveElement a;
			a.regist_buffer(x,key);
			return mC.rb_insert(a);
		}
		bool addFromMemory(const key_type &key,const shared_buffer &x){
			return addToArchive(key,x);
		}

		virtual bool addToArchive(const reserve_type &x){
			return mC.rb_insert(x);
		}

	};

}//end of dkutil namespace



#endif