// -*- C++ -*-
//  Boost general library 'format'   ---------------------------
//  See http://www.boost.org for updates, documentation, and revision history.

//  (C) Samuel Krempp 2001
//                  krempp@crans.ens-cachan.fr
//  Permission to copy, use, modify, sell and
//  distribute this software is granted provided this copyright notice appears
//  in all copies. This software is provided "as is" without express or implied
//  warranty, and with no claim as to its suitability for any purpose.

// ideas taken from REiger Loos's format class
// and Karl Nelson's ofstream

// ----------------------------------------------------------------------------
// format.hpp :  primary header
// ----------------------------------------------------------------------------

#ifndef BOOST_FORMAT_HPP
#define BOOST_FORMAT_HPP

#include <vector>
#include <string>
#include <sstream>
#include <dkutil/boost/config.hpp>
#include <dkutil/boost/detail/workaround.hpp>

#ifndef BOOST_NO_STD_LOCALE
#include <locale>
#endif


// make sure our local macros wont override something :
#if defined(BOOST_NO_LOCALE_ISDIGIT) || defined(BOOST_OVERLOAD_FOR_NON_CONST) \
  || defined(BOOST_IO_STD) || defined( BOOST_IO_NEEDS_USING_DECLARATION )
#error "a local macro would overwrite a previously defined macro"
#endif


#include <dkutil/boost/format/macros_stlport.hpp>  // stlport workarounds
#include <dkutil/boost/format/macros_default.hpp> 

#if defined(BOOST_NO_STD_LOCALE) || \
 ( BOOST_WORKAROUND(__BORLANDC__, <= 0x564) \
   || BOOST_WORKAROUND(__BORLANDC__, BOOST_TESTED_AT( 0x570 ) )  )
// some future __BORLANDC__ >0x564  versions might not need this
// 0x570 is Borland's kylix branch
#define BOOST_NO_LOCALE_ISIDIGIT
#endif

#ifdef BOOST_NO_LOCALE_ISIDIGIT
#include <cctype>  // we'll use the non-locale  <cctype>'s std::isdigit(int)
#endif


#if  BOOST_WORKAROUND(__BORLANDC__, BOOST_TESTED_AT(0x570) ) || BOOST_WORKAROUND( BOOST_MSVC, BOOST_TESTED_AT(1300))
#define BOOST_NO_OVERLOAD_FOR_NON_CONST
#endif


// ****  Forward declarations ----------------------------------
#include <dkutil/boost/format/format_fwd.hpp>           // basic_format<Ch,Tr>, and other frontends
#include <dkutil/boost/format/internals_fwd.hpp>        // misc forward declarations for internal use


// ****  Auxiliary structs (stream_format_state<Ch,Tr> , and format_item<Ch,Tr> )
#include <dkutil/boost/format/internals.hpp>    

// ****  Format  class  interface --------------------------------
#include <dkutil/boost/format/format_class.hpp>

// **** Exceptions -----------------------------------------------
#include <dkutil/boost/format/exceptions.hpp>

// **** Implementation -------------------------------------------
#include <dkutil/boost/format/format_implementation.hpp>   // member functions

#include <dkutil/boost/format/group.hpp>                   // class for grouping arguments

#include <dkutil/boost/format/feed_args.hpp>               // argument-feeding functions
#include <dkutil/boost/format/parsing.hpp>                 // format-string parsing (member-)functions

// **** Implementation of the free functions ----------------------
#include <dkutil/boost/format/free_funcs.hpp>


// *** Undefine 'local' macros :
#ifdef BOOST_NO_OVERLOAD_FOR_NON_CONST
#undef BOOST_NO_OVERLOAD_FOR_NON_CONST
#endif
#ifdef BOOST_NO_LOCALE_ISIDIGIT
#undef BOOST_NO_LOCALE_ISIDIGIT
#endif
#ifdef BOOST_IO_STD
#undef BOOST_IO_STD
#endif
#ifdef BOOST_IO_NEEDS_USING_DECLARATION
#undef BOOST_IO_NEEDS_USING_DECLARATION
#endif

#endif // BOOST_FORMAT_HPP
