
#ifndef BOOST_MPL_BOOL_HPP_INCLUDED
#define BOOST_MPL_BOOL_HPP_INCLUDED

// + file: boost/mpl/bool.hpp
// + last modified: 08/mar/03

// Copyright (c) 2000-03
// Aleksey Gurtovoy
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee, 
// provided that the above copyright notice appears in all copies and 
// that both the copyright notice and this permission notice appear in 
// supporting documentation. No representations are made about the 
// suitability of this software for any purpose. It is provided "as is" 
// without express or implied warranty.
//
// See http://www.boost.org/libs/mpl for documentation.

#include "dkutil/boost/mpl/bool_fwd.hpp"
#include "dkutil/boost/mpl/aux_/config/static_constant.hpp"

namespace boost { namespace mpl {

template< bool C_ > struct bool_
{
    BOOST_STATIC_CONSTANT(bool, value = C_);
    typedef bool_ type;
    typedef bool value_type;
    operator bool() const { return this->value; }
};

}} // namespace boost::mpl

#endif // BOOST_MPL_BOOL_HPP_INCLUDED
