//-----------------------------------------------------------------------------
// boost mpl/contains.hpp header file
// See http://www.boost.org for updates, documentation, and revision history.
//-----------------------------------------------------------------------------
//
// Copyright (c) 2002
// Eric Friedman
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee, 
// provided that the above copyright notice appears in all copies and 
// that both the copyright notice and this permission notice appear in 
// supporting documentation. No representations are made about the 
// suitability of this software for any purpose. It is provided "as is" 
// without express or implied warranty.

#ifndef BOOST_MPL_CONTAINS_HPP_INCLUDED
#define BOOST_MPL_CONTAINS_HPP_INCLUDED

#include "dkutil/boost/mpl/begin_end.hpp"
#include "dkutil/boost/mpl/find.hpp"
#include "dkutil/boost/mpl/not.hpp"
#include "dkutil/boost/mpl/aux_/void_spec.hpp"
#include "dkutil/boost/mpl/aux_/lambda_support.hpp"
#include "dkutil/boost/type_traits/is_same.hpp"

namespace boost {
namespace mpl {

template<
      typename BOOST_MPL_AUX_VOID_SPEC_PARAM(Sequence)
    , typename BOOST_MPL_AUX_VOID_SPEC_PARAM(T)
    >
struct contains
    : not_< is_same<
          typename find<Sequence,T>::type
        , typename end<Sequence>::type
        > >
{
    BOOST_MPL_AUX_LAMBDA_SUPPORT(2,contains,(Sequence,T))
};

BOOST_MPL_AUX_VOID_SPEC(2, contains)

} // namespace mpl
} // namespace boost

#endif // BOOST_MPL_CONTAINS_HPP_INCLUDED
