//-----------------------------------------------------------------------------
// boost mpl/vector/aux_/empty.hpp header file
// See http://www.boost.org for updates, documentation, and revision history.
//-----------------------------------------------------------------------------
//
// Copyright (c) 2000-02
// Aleksey Gurtovoy
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee, 
// provided that the above copyright notice appears in all copies and 
// that both the copyright notice and this permission notice appear in 
// supporting documentation. No representations are made about the 
// suitability of this software for any purpose. It is provided "as is" 
// without express or implied warranty.

#ifndef BOOST_MPL_VECTOR_AUX_EMPTY_HPP_INCLUDED
#define BOOST_MPL_VECTOR_AUX_EMPTY_HPP_INCLUDED

#include "dkutil/boost/mpl/empty_fwd.hpp"
#include "dkutil/boost/mpl/not.hpp"
#include "dkutil/boost/mpl/bool.hpp"
#include "dkutil/boost/mpl/vector/aux_/tag.hpp"
#include "dkutil/boost/mpl/aux_/config/vector.hpp"
#include "dkutil/boost/config.hpp"

namespace boost {
namespace mpl {

#if defined(BOOST_MPL_TYPEOF_BASED_VECTOR_IMPL)

template<>
struct empty_traits< aux::vector_tag >
{
    template< typename Vector > struct algorithm
        : not_< typename Vector::size >
    {
    };
};

#else

template<>
struct empty_traits< aux::vector_tag<0> >
{
    template< typename Vector > struct algorithm
        : true_
    {
    };
};

#if !defined(BOOST_NO_TEMPLATE_PARTIAL_SPECIALIZATION)

template< long N >
struct empty_traits< aux::vector_tag<N> >
{
    template< typename Vector > struct algorithm
        : false_
    {
    };
};

#endif // BOOST_NO_TEMPLATE_PARTIAL_SPECIALIZATION

#endif // BOOST_MPL_TYPEOF_BASED_VECTOR_IMPL

} // namespace mpl
} // namespace boost

#endif // BOOST_MPL_VECTOR_AUX_EMPTY_HPP_INCLUDED
