#ifndef BOOST_SERIALIZATION_LEVEL_HPP
#define BOOST_SERIALIZATION_LEVEL_HPP

// MS compatible compilers support #pragma once
#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
// level.hpp:

// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com . 
// Use, modification and distribution is subject to the Boost Software
// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org for updates, documentation, and revision history.

#include <dkutil/boost/config.hpp>
#include <dkutil/boost/detail/workaround.hpp>

#include <dkutil/boost/type_traits/is_fundamental.hpp>
#include <dkutil/boost/type_traits/is_enum.hpp>
#include <dkutil/boost/type_traits/is_array.hpp>
#include <dkutil/boost/type_traits/is_class.hpp>
#include <dkutil/boost/type_traits/is_base_and_derived.hpp>
#include <dkutil/boost/mpl/apply_if.hpp>
#include <dkutil/boost/mpl/int.hpp>

#include <dkutil/boost/serialization/level_enum.hpp>
#include <dkutil/boost/serialization/traits.hpp>

namespace boost {
namespace serialization {

// default serialization implementation level
template<class T>
struct implementation_level {
    template<class U>
    struct traits_class_level {
        typedef  BOOST_DEDUCED_TYPENAME U::level type;
    };
    typedef
        BOOST_DEDUCED_TYPENAME mpl::apply_if<
        	is_base_and_derived<basic_traits, T>,
        	traits_class_level<T>,
        //else
        BOOST_DEDUCED_TYPENAME mpl::apply_if<
        	is_fundamental<T>,
        	mpl::int_<primitive_type>,
        //else
        BOOST_DEDUCED_TYPENAME mpl::apply_if<
        	is_class<T>,
        	mpl::int_<object_class_info>,
        //else
        BOOST_DEDUCED_TYPENAME mpl::apply_if<
        	is_array<T>,
        	#if BOOST_WORKAROUND(__BORLANDC__, BOOST_TESTED_AT(0x564))
        		mpl::int_<not_serializable>,
        	#else
        		mpl::int_<object_serializable>,
        	#endif
        //else
        BOOST_DEDUCED_TYPENAME mpl::apply_if<
        	is_enum<T>,
        	#if BOOST_WORKAROUND(__BORLANDC__, BOOST_TESTED_AT(0x564))
        		mpl::int_<not_serializable>,
        	#else
        		mpl::int_<object_serializable>,
        	#endif
        //else
        	mpl::int_<not_serializable>
        >::type
        >::type
        >::type
        >::type
        >::type type;
        // vc 7.1 doesn't like enums here
    BOOST_STATIC_CONSTANT(int, value = implementation_level::type::value);
};

template<class T, enum level_type L>
inline bool operator>=(implementation_level<T> t, enum level_type l)
{
    return t.value >= (int)l;
}

} // namespace serialization
} // namespace boost

// specify the level of serialization implementation for the class
// require that class info saved when versioning is used
#define BOOST_CLASS_IMPLEMENTATION(T, E)                 \
    namespace boost {                                    \
    namespace serialization {                            \
    template <>                                          \
    struct implementation_level<T>                       \
    {                                                    \
        typedef mpl::int_< E > type;                     \
        BOOST_STATIC_CONSTANT(                           \
        	int,                                         \
        	value = implementation_level::type::value    \
        );                                               \
    };                                                   \
    }                                                    \
    }
    /**/

#endif // BOOST_SERIALIZATION_LEVEL_HPP
