
#ifndef DKUTIL_COMPRESSION_BLOCKSORT_HPP
#define DKUTIL_COMPRESSION_BLOCKSORT_HPP


#include <dkutil_c/dkcBlockSort.h>
#include <dkutil/compression/interface.hpp>

namespace dkutil{



class CBlockSort : public IArrayProcess{

	size_t mEncodedSize;

	struct CBlockSortHeader{
		///VOl`
		ULONG sig;
		///BlockSort̏
		DKC_BLOCKSORT_INFO info;
	};
	BOOST_STATIC_CONSTANT(int,header_size = sizeof(CBlockSortHeader));

	bool check_sig(CBlockSortHeader *p){
		return (p->sig == getSignature());
	}
public:
	///@see reset()
	CBlockSort(ULONG signature=edk_BLOCKSORT_SIGNATURE){
		reset(signature);
		
	}
	~CBlockSort(){
		
	}
	///@param signature[in] BlockSortňkĂ邱ƂؖIDiftHgł dkcdBlockSort_SIGNATURE )
	bool reset(ULONG signature=edk_BLOCKSORT_SIGNATURE){
		setSignature(signature);
		setResult(edk_FAILED);
		mEncodedSize = 0;
		return true;
	}

	int decode(const BYTE *src,size_t size,BYTE *dest,size_t destsize){
		const BYTE *sp = src + header_size;
		size_t ssize = size - header_size;
		int r = edk_FAILED;
		//obt@̐擪Ƀwb_t@CB
		CBlockSortHeader *hp = (CBlockSortHeader*)src;

		dkcmNOT_ASSERT(check_sig(hp)==FALSE);
		if(check_sig(hp)==FALSE){
			return r;
		}
		if(destsize < ssize){
			return r;
		}
		memcpy(dest,sp,ssize);

		r = dkcBlockSortDecode(
			dest,ssize,
			&(hp->info)
		);

		//ʂB
		setResult(r);

		return r;

	}

	int encode(const BYTE *src,size_t size,BYTE *dest,size_t destsize){
		BYTE *bp = dest + header_size;
		size_t bsize = destsize - header_size;
		int r = edk_FAILED;
		DKC_BLOCKSORT_INFO info;
		
		if(size > bsize){
			return r;
		}
		//destɃRs[
		memcpy(bp,src,size);

		//dest\[g
		r = dkcBlockSortEncode(bp,size,&info);
		if(DKUTIL_FAILED(r)){
			return r;
		}

		//update
		CBlockSortHeader *hp = (CBlockSortHeader *)dest;
		hp->sig = getSignature();
		hp->info = info;

		mEncodedSize = size + header_size;
		setResult(r);
		
		return r;
	}	
	
	
	virtual size_t getEncodedSize()const{
		return mEncodedSize;
	}
	
	///GR[h̏o͗\̃TCY (ʂ傫߂̒lԂ܂B) 
	virtual size_t getEncodeOutputSize(size_t size)const{
		return size + header_size;
	}
	/**
	@param pHeader[in] fR[h\̃f[^
	@param size[in] fR[h\̃TCY
	@throw ANZXsȏփANZX悤Ƃ std::runtime_errorՂςȂB
	*/
	///fR[h̏o͗\̃TCY@
	virtual size_t getDecodeOutputSize(const void *pHeader,size_t size)const{
		if(size < header_size){
			DKUTIL_THROW_OR_NOTICE(std::runtime_error("CBLockSort::getDecodeOutputSize() size argument exception"));
			return 0;
		}
		CBlockSortHeader *p = (CBlockSortHeader *)pHeader;
		size_t s = size + header_size;
		return s;
	}

};
		

}//end of dkutil namespace



#endif