
#ifndef DKUTIL_COMPRESSION_LZSS_HPP
#define DKUTIL_COMPRESSION_LZSS_HPP

#include <dkutil_c/dkcLZSS.h>
#include <dkutil/compression/interface.hpp>

namespace dkutil{

class CLZSS : public IArrayProcess{
	DKC_LZSS *mP;
	DKC_LZSS_HEADER mH;
	int mResult;
	///VOl`
	ULONG mSig;
	bool check_sig(DKC_LZSS_HEADER *p)const{
		return p->mSignature == mSig;
	}
public:
	///@see reset()
	CLZSS(ULONG signature=dkcdLZSS_SIGNATURE){
		mP = dkcAllocLZSS();
		DKUTIL_STRUCTURE_INIT(mH);
		mSig = signature;
	}
	~CLZSS(){
		dkcFreeLZSS(&mP);
	}
	///@param signature[in] LZSSňkĂ邱ƂؖIDiftHgł dkcdLZSS_SIGNATURE )
	bool reset(ULONG signature=dkcdLZSS_SIGNATURE){
		DKUTIL_STRUCTURE_INIT(mH);
		dkcFreeLZSS(&mP);
		mP = dkcAllocLZSS();
		//setResult(edk_FAILED);
		setResult(edk_SUCCEEDED);
		setSignature(signature);
		return (NULL != mP);
	}

#if 0
	/*!
	@throw vIȃG[̏ꍇAstd::runtime_error𓊂
	*/
	template<class BUFFER_T>
	bool encode(const BYTE *src,size_t srcsize,BUFFER_T &buff)
	{
		//obt@̐擪Ƀwb_t@CB
		if(buff.size() < srcsize + sizeof(mH)){
			buff.resize(srcsize + sizeof(mH));
		}
		int r = encode(src,srcsize,buff.get(),buff.size());

		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	template<class BUFFER_T>
	bool decode(const BYTE *src,size_t srcsize,BUFFER_T &buff){
		int r = edk_FAILED;
		//obt@̐擪Ƀwb_t@CB
		DKC_LZSS_HEADER *hp = (DKC_LZSS_HEADER *)src;

		dkcmNOT_ASSERT(check_sig(hp)==FALSE);
		if(check_sig(hp)==FALSE){
			return r;
		}
		if(hp->mOriginSize > buff.size())
		{//obt@ȂB
			//TCY
			buff.resize(hp->mOriginSize);
		}		
		
		return DKUTIL_SUCCEEDED_BOOL(decode(src,srcsize,buff.get(),buff.size()));
	}
#endif
	///@return ̃TCY
	size_t origin_size()const{
		return mH.mOriginSize;
	}

	///@return fR[h̃TCY擾
	virtual size_t decoded_size(const BYTE *src,size_t size)const{
		DKC_LZSS_HEADER *hp = (DKC_LZSS_HEADER *)src;
		if(check_sig(hp)==FALSE){
			return 0;
		}
		return hp->mOriginSize;
	}
	
	///@see class IArrayProcess
	virtual size_t getEncodedSize()const{
		return mH.mCompressedSize + sizeof(mH);//header 
	}
	
	///@see class IArrayProcess
	virtual size_t getEncodeOutputSize(size_t size)const{
		return size + sizeof(mH);
	}
	/**
	@param pData[in] fR[h\̃f[^
	@param size[in] fR[h\̃TCY
	@throw ANZXsȏփANZX悤Ƃ std::runtime_errorՂςȂB
	*/
	///fR[h̏o͗\̃TCY@
	virtual size_t getDecodeOutputSize(const void *pData,size_t size)const{
		//obt@̐擪Ƀwb_t@CB
		DKC_LZSS_HEADER *hp = (DKC_LZSS_HEADER *)pData;

		//dkcmNOT_ASSERT(check_sig(hp)==FALSE);
		if(check_sig(hp)==FALSE){
			DKUTIL_THROW_OR_NOTICE(std::runtime_error("CLZSS::getDecodeOutputSize() signature error"));
			return 0;
		}
		return hp->mOriginSize;
	}
	///fR[hLȃf[^̃TCY
	virtual size_t getDecodeValidOutputSize(const void *pData,size_t size)const{
		return getDecodeOutputSize(pData,size);
	}
	int decode(const BYTE *src,size_t size,BYTE *dest,size_t destsize){
		int r = edk_FAILED;
		//obt@̐擪Ƀwb_t@CB
		DKC_LZSS_HEADER *hp = (DKC_LZSS_HEADER *)src;

		//dkcmNOT_ASSERT(check_sig(hp)==FALSE);
		if(check_sig(hp)==FALSE){
			return r;
		}
		if(hp->mOriginSize > destsize){
			return r;
			//buff.resize(hp->mOriginSize);
		}

		r = dkcLZSSDecode(mP,hp,dest,destsize,
			//擪𔲂B
			src + sizeof(DKC_LZSS_HEADER),/*srcsize*/size - sizeof(DKC_LZSS_HEADER),
			mSig
		);

		//ʂB
		mResult = r;

		return mResult;

	}
	int encode(const BYTE *src,size_t size,BYTE *dest,size_t destsize){
		BYTE *bp = dest + sizeof(mH);
		size_t bsize = destsize - sizeof(mH);
		//ʂB
		mResult = dkcLZSSEncode(mP,&mH,bp,bsize,src,size,size,mSig);
		if(DKUTIL_FAILED(mResult)){
			return mResult;
		}

		DKC_LZSS_HEADER *hp = (DKC_LZSS_HEADER *)dest;
		
		*hp = mH;

		return mResult;
	}	
	
	
};
		

}//end of dkutil namespace



#endif