/*!
@note
t`
<a href="http://www.twin-tail.jp/">Luna3rd</a>QlɂĂ܂B
*/

#ifndef DKUTIL_CPU_HPP
#define DKUTIL_CPU_UPP

#include <dkutil/define.hpp>
#include <dkutil/string.hpp>

namespace dkutil{

#ifndef _MSC_VER
///͂茾Ďg邩ǂ͂킩Ȃ
inline ULONGLONG RDTSC(){
	typedef ULONGLONG (__fastcall *RDTSC_TYPE)();
	RDTSC_TYPE t;
	static const BYTE rdtsc[]={
		0x55									 //push				ebp
		,0x8B,0xEC								//mov		,0x ebp,esp
		,0x83,0xEC,0x44						 //sub				 esp,44h
		,0x53									 //push				ebx
		,0x56								 //	push				esi
		,0x57								 //	push				edi
		,0x51								//	 push				ecx
		,0x8D,0x7D,0xBC				 //		lea				 edi,[ebp-44h]
		,0xB9,0x11,0x00,0x00,0x00		//	 mov				 ecx,11h
		,0xB8,0xCC,0xCC,0xCC,0xCC		//	 mov				 eax,0CCCCCCCCh
		,0xF3,0xAB						 //	 rep stos		dword ptr [edi]
		,0x59								//	 pop				 ecx
		,0x89,0x4D,0xFC					//	 mov				 dword ptr [ebp-4],ecx
		,0x0F,0x31						 //	 rdtsc
		,0x5F								//	 pop				 edi
		,0x5E								//	 pop				 esi
		,0x5B								//	 pop				 ebx
		,0x83,0xC4,0x44					//	 add				 esp,44h
		,0x3B,0xEC						 //	 cmp				 ebp,esp
		,0xE8,0x14,0x34,0x00,0x00		//	 call				__chkesp (00405fb0)
		,0x8B,0xE5						 //	 mov				 esp,ebp
		,0x5D								//	 pop				 ebp
		,0xC3								//	 ret
	};
	t = reinterpret_cast<RDTSC_TYPE>(&rdtsc);
	return t();
}
#else
///for MSVC


#pragma warning(disable:4035)
inline ULONGLONG __fastcall RDTSC(){
	_asm{
		RDTSC
	}
}
#pragma warning(default:4035)
#endif


class CPUInfo{
public:
	struct CPU_INFO{
		char CPUName[256];
		char CPUType[128];
		bool bFPU			;
		bool bTSC		;
		bool bCMOV		;
		bool bFCMOV		;
		bool bCPUID		;
		bool bMMX	;
		bool bMMX2		;
		bool bSSE		;
		bool bSSE2	;
		bool b3DNOW			;
		bool bE3DNOW		;
		long TypeID		;
		long FamilyID	;
		long ModelID;
		long SteppingID	;
		long CPUClock	;
	};
private:
	static CPU_INFO minfo;
//BOOST_PROTECTED:
	CPU_INFO &GetInfoRef(){return minfo;}
public:
	CPUInfo(){
		::memset(&minfo,0,sizeof(minfo));
		GetCPUInformation();
	}
	virtual ~CPUInfo(){}
	
	///MMXgȂtrue
	bool isMMX(){return minfo.bMMX;}
	///MMX2gȂtrue
	bool isMMX2(){return minfo.bMMX2;}
	///SSEgȂtrue
	bool isSSE(){return minfo.bSSE;}
	///SSE2gȂtrue
	bool isSSE2(){return minfo.bSSE2;}
	///3DNowgȂtrue
	bool is3DNOW(){return minfo.b3DNOW;}
	///GnXh3DNowgȂtrue
	bool isE3DNOW(){return minfo.bE3DNOW;}
	///@return CPUClockMHzPʂŋA܂B
	long CPUClock(){
		if(minfo.CPUClock==0){
			minfo.CPUClock = BenchCPUClock(minfo.bTSC);
		}
		return minfo.CPUClock;
	}
	///@return FPUgȂTRUE
	bool isFPU(){return minfo.bFPU;}
	///@return TSCgȂTRUE
	static bool isTSC(){return minfo.bTSC;}
	///@return CPUIDĝȂtrue
	bool isCPUID(){return minfo.bCPUID;}
	/*!
	@param buff[in] ̊i[ւ̃|C^ 256byteȏ
	@param buffsize[in] obt@̃TCY
	*/
	///CPU̖OQbg܂B
	void CopyCPUName(char *buff,size_t buffsize){
		strncpy(buff,minfo.CPUName,buffsize);
	}


	///CopyCPUName()ĂB
	///CPUTypeQbg܂BCPUTypeɉȂ͓̂(
	void CopyCPUType(char *buff,size_t buffsize){
		strncpy(buff,minfo.CPUType,buffsize);
	}

	///CPUNbŇvɖ1b̂
	///gƏꏊǂlĂgpĂB
	///@param bTSC[in] CPUTSCLǂHiłAftHgœnĂ̂Ŏۂ͓nȂOK
	///@return CPUClock(MHzP)
	long BenchCPUClock(long bTSC=isTSC());
	///Luna3rd
	///@param isAll[in] trueɂBenchCPUClock()ŎsB
	void GetCPUInformation( bool isAll=false );
	
	/*!
	@param a[in] ̊i[ꏊ(270byteȏmۂĂB)
	@param buffsize[in] åi[eʃTCY
	*/
	///CPU()B
	void CPUInfoToCharPtr(char *a,size_t buffsize);
	/*
	///@param logger[in] HTMLLogNX܂B
	void LogoutHTML(HTMLLog &logger)
	{
		//--------------------------------------------------
		// `FbN`
		//--------------------------------------------------
		char CPUName[256]="";
		if ( (strlen(minfo.CPUType)>0) && (strlen(minfo.CPUName)>0) )
		{
			strncpy(CPUName,minfo.CPUName,256);
			strncat( CPUName, " - " ,256);
			strncat( CPUName, minfo.CPUType,256 );
		}
		else
		{
			strncpy( CPUName, "UnKnown" ,256);
		}

		// O
		logger.LogoutKeyword( "CPU Information" );
		logger.LogoutNextLine();

		logger.Logout( "@@@Name [ %s ]", CPUName );
		logger.LogoutNextLine();

		logger.Logout( "@@@Clock [ %uMHz ]", minfo.CPUClock );
		logger.LogoutNextLine();

		logger.Logout( "@@@Type [ %u ] Family [ %u ] Model [ %u ] Stepping [ %u ]",
			minfo.TypeID, minfo.FamilyID, minfo.ModelID, minfo.SteppingID );
		logger.LogoutNextLine();

		logger.Logout( "@@@FPU %s : CPUID %s : MMX %s\n",
			(minfo.bFPU  )?(""):("~"),
			(minfo.bCPUID )?(""):("~"), (minfo.bMMX )?(""):("~") );
		logger.LogoutNextLine();
		logger.Logout( "@@@MMX2 %s : SSE %s : SSE2 %s\n",
			(minfo.bMMX2 )?(""):("~"),
			(minfo.bSSE   )?(""):("~"), (minfo.bSSE2)?(""):("~") );
		logger.LogoutNextLine();
		logger.Logout( "@@@3DNow %s : E3DNow %s : CMOV %s\n",
			(minfo.b3DNOW)?(""):("~"), (minfo.bE3DNOW)?(""):("~"),
			(minfo.bCMOV)?(""):("~") );
		logger.LogoutNextLine();
		logger.Logout( "@@@FCMOV %s : TSC %s\n",
			(minfo.bFCMOV)?(""):("~"), (minfo.bTSC   )?(""):("~") );
		logger.LogoutNextLine();

		logger.LogoutNextLine();
	}
	*/

};

}//end of dkutil namespace

#ifndef DKUTIL_DETAIL_CPU_CPP
//#	include <dkutil/detail/cpu.cpp>
#endif
	
#endif //end of include once
