
#ifndef DKUTIL_CRYPTOGRAPH_BLOWFISH_HPP
#define DKUTIL_CRYPTOGRAPH_BLOWFISH_HPP

#include <dkutil_c/dkc.h>
#include <dkutil/memory/interface.hpp>

namespace dkutil{

/**
BlowfishÍsNX
type:ubNÍ
*/
class CBlowFish : public IArrayProcess{

	size_t mEncodedSize;

	struct CBlowFishHeader{
		///VOl`
		ULONG sig;
		///IWĩTCY
		size_t origin_size;
		///GR[hς݂̃TCY
		size_t encoded_size;
	};
	DKC_BLOWFISH *mP;
	BOOST_STATIC_CONSTANT(int,header_size = sizeof(CBlowFishHeader));
	
	bool check_sig(CBlowFishHeader *p){
		return (p->sig == getSignature());
	}
	void check_obj__()const{
		if(NULL == mP){
			DKUTIL_THROW_OR_NOTICE(std::runtime_error("CBlowfish uninitialize error"));
			dkcmFORCE_NOT_ASSERT(NULL != mP);
		}
	
	}
public:
	///@see reset()
	CBlowFish(const BYTE *key = NULL,size_t keysize = 0,ULONG signature=edk_BLOWFISH_SIGNATURE){
		mP = NULL;
		mEncodedSize = 0;
		reset(key,keysize);
		
	}
	void clear(){
		dkcFreeBlowfish(&mP);
	}
	
	~CBlowFish(){
		clear();
	}
	///@param signature[in] BlockSortňkĂ邱ƂؖIDiftHgł dkcdBlockSort_SIGNATURE )
	bool reset(const BYTE *key ,size_t keysize,ULONG signature=edk_BLOWFISH_SIGNATURE){
		setSignature(signature);
		setResult(edk_FAILED);
		
		if(NULL==key){
			return false;
		}

		clear();

		BYTE *kp = (BYTE *)malloc(keysize);
		if(NULL==kp){
			return false;
		}
		//L[Rs[
		memcpy(kp,key,keysize);
	

		//IuWFNg擾
		DKC_BLOWFISH *p = dkcAllocBlowfish(kp,keysize);
		bool r = false;
		if(NULL==p){
			goto Error;
		}
		
		mP = p;
		mEncodedSize = 0;
		r = true;
	Error:
		if(kp){free(kp);}
		return r;
	}

	int decode(const BYTE *src,size_t size,BYTE *dest,size_t destsize){
		const BYTE *sp = src + header_size;
		size_t ssize = size - header_size;
		int r = edk_FAILED;
		//obt@̐擪Ƀwb_t@CB
		CBlowFishHeader *hp = (CBlowFishHeader*)src;
		check_obj__();

		dkcmNOT_ASSERT(check_sig(hp)==FALSE);
		if(check_sig(hp)==FALSE){
			return r;
		}
		if(getDecodeOutputSize(hp,size) > destsize){//destȂ
			return r;
		}
		if(hp->encoded_size > size){//input bufferȂ
			return r;
		}
		//[A`
		scoped_buffer_byte buff(getDecodeOutputSize(hp,size));
		if(false==buff.good()){
			return r;
		}
		memcpy(buff.get(),sp,hp->encoded_size);


		dkcBlowfishDecrypt(
			mP,buff.get(),dest,buff.size()
		);

		r = edk_SUCCEEDED;
		//ʂB
		setResult(r);

		return r;

	}

	int encode(const BYTE *src,size_t size,BYTE *dest,size_t destsize){
		BYTE *bp = dest + header_size;
		size_t bsize = destsize - header_size;
		DWORD outputsize;
		check_obj__();

		if(getEncodeOutputSize(size) > destsize){
			return edk_FAILED;
		}
		//inpuẗ̗悪N̂̓CȂ̂ŃRs[Ă
		memcpy(bp,src,size);


		//bsizeÍ
		outputsize = dkcBlowfishEncrypt(mP,bp,bp,bsize);
		if(0==outputsize){
			return edk_FAILED;
		}

		//update
		CBlowFishHeader *hp = (CBlowFishHeader *)dest;
		hp->sig = getSignature();
		hp->origin_size = size;
		hp->encoded_size = outputsize;

		mEncodedSize = hp->encoded_size;
		setResult(edk_SUCCEEDED);
		
		return edk_SUCCEEDED;
	}	
	
	
	virtual size_t getEncodedSize()const{
		return mEncodedSize;
	}
	
	///GR[h̏o͗\̃TCY (ʂ傫߂̒lԂ܂B) 
	virtual size_t getEncodeOutputSize(size_t size)const{
		return dkcBlowfishGetOutputLength(size) + header_size;
	}
	/**
	@param pHeader[in] fR[h\̃f[^
	@param size[in] fR[h\̃TCY
	@throw ANZXsȏփANZX悤Ƃ std::runtime_errorՂςȂB
	*/
	///fR[h̏o͗\̃TCY@
	virtual size_t getDecodeOutputSize(const void *pHeader,size_t size)const{
		if(size < header_size){
			DKUTIL_THROW_OR_NOTICE(std::runtime_error("CBlowfish::getDecodeOutputSize() size argument exception"));
			return 0;
		}
		CBlowFishHeader *p = (CBlowFishHeader *)pHeader;
		//size_t s = p->origin_size;
		size_t s = p->encoded_size;
		return s;
	}
	virtual size_t getDecodeValidOutputSize(const void *pHeader,size_t size)const{
		if(size < header_size){
			DKUTIL_THROW_OR_NOTICE(std::runtime_error("CBlowfish::getDecodeOutputSize() size argument exception"));
			return 0;
		}
		CBlowFishHeader *p = (CBlowFishHeader *)pHeader;
		size_t s = p->origin_size;
		//size_t s = p->encoded_size;
		return s;
	}


};



}//end of dkutil namespace



#endif