
#ifndef DKUTIL_DETAIL_STREAM_CODING_INTERFACE_HPP
#define DKUTIL_DETAIL_STREAM_CODING_INTERFACE_HPP

#include <dkutil/macro.hpp>
#include <dkutil/config.hpp>
#include <dkutil/scoped_buffer.hpp>
#include <dkutil/detail/serialize_interface.hpp>
#include <stdio.h>

namespace dkutil{


template<class SECOND_HEADER_T>
class stream_coding_interface : public read_convert_block<SECOND_HEADER_T>{
	
	
};
class IStreamCoding{
private:
	///߂l
	int mResult;
	///ʎq
	uint32 mSig;

protected:
	
	void setResult(int r){
		mResult = r;
	}
	void setSignature(uint32 a){
		mSig = a;
	}
	ISerializeStream *mP;
public:
	typedef IStreamCoding self_type ;

	
	virtual ~IStreamCoding(){}
	virtual bool reset(uint32 signature_,ISerializeStream *p)
	{
		setSignature(signature_);
		mP = p;
	}
	///B@return edkResult̂ǂꂩ
	virtual int decode(const BYTE *src,size_t size,BYTE *dest,size_t destsize) = 0;
	///ÍB@return edkResult̂ǂꂩ
	virtual int encode(const BYTE *src,size_t size,BYTE *dest,size_t destsize) = 0;

	//decodẽTCY
	//virtual size_t decoded_size(const BYTE *src,size_t size)const = 0;
	
	///GR[h̃TCY
	virtual size_t getEncodedSize()const = 0;
	
	///GR[h̏o͗\̃TCY (ʂ傫߂̒lԂ܂B) 
	virtual size_t getEncodeOutputSize(size_t size)const = 0;
	/**
	@param pData[in] fR[h\̃f[^
	@param size[in] fR[h\̃TCY
	@throw ANZXsȏփANZX悤Ƃ std::runtime_errorՂςȂB
	*/
	///fR[h̏o͗\̃TCY@
	virtual size_t getDecodeOutputSize()const = 0;

	///fR[h̗Lȃf[^̃TCYԂ
	virtual size_t getDecodeValidOutputSize()const = 0;
	///VOl`
	ULONG getSignature()const{
		return mSig;
	}

	///@return encode decode̖߂lԂ
	int getResult()const{
		return mResult;
	}

	///encode ܂ decodeTRUE
	bool isSucceeded()const{
		return DKUTIL_SUCCEEDED_BOOL(mResult);
	}
	///@return obt@I[o[t[悤ȂTRUE
	bool is_bufferoverflow()const{
		return edk_BufferOverFlow==mResult;
	}
	///@return kAÍẢlTRUE
	bool is_valueless()const{
		return edk_NoValueToProcess==mResult;
	}

	/*!
	@throw vIȃG[̏ꍇAstd::runtime_error𓊂
	*/
	template<class BUFFER_T>
	bool encode(const BYTE *src,size_t srcsize,BUFFER_T &buff)
	{
		size_t size = getEncodeOutputSize(srcsize);
		//obt@̐擪Ƀwb_t@CB
		if(buff.size() < size){
			//buff.resize(size);
			buff.reserve(size);
		}
		int r = encode(src,srcsize,buff.get(),buff.size());

		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	template<class BUFFER_T>
	bool decode(const BYTE *src,size_t srcsize,BUFFER_T &buff){
		int r = edk_FAILED;
		size_t size = getDecodeOutputSize(src,srcsize);
		/*if(0==size){
			DKUTIL_THROW_OR_NOTICE(std::runtime_error("
		}*/

		if(size > buff.size())
		{//obt@ȂB
			//TCY
			//buff.resize(size);
			buff.reserve(size);
		}		
		
		return DKUTIL_SUCCEEDED_BOOL(decode(src,srcsize,buff.get(),buff.size()));
	}
	/*
	int encode(const BYTE *src,size_t size,IStream *dest_s){
		if(dest_s->type() != 	memory_stream_type){
			return edk_ArgumentException;
		}
		return encode(src,size,(unsigned char *)dest_s->data(),dest_s->size());
	}

	int decode(const BYTE *src,size_t size,IStream *dest_s){
		if(dest_s->type() != memory_stream_type){
			return edk_ArgumentException;
		}
		return decode(src,size,(unsigned char *)dest_s->data(),dest_s->size());
	}
	*/
	int encode(const BYTE *src,size_t size,IMemoryStream *dest_s){
	
		return encode(src,size,(unsigned char *)dest_s->data(),dest_s->size());
	}

	int decode(const BYTE *src,size_t size,IMemoryStream *dest_s){
		
		return decode(src,size,(unsigned char *)dest_s->data(),dest_s->size());
	}
};



}//end of dkutil namespace



#endif